/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginGroupHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndGroupBodyHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;
import org.pentaho.reporting.engine.classic.core.states.process.ReportFooterHandler;

public class JoinEndGroupHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new JoinEndGroupHandler();

    private JoinEndGroupHandler() {
    }

    @Override
    public int getEventCode() {
        return -2147483520;
    }

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        return state.deriveForAdvance();
    }

    @Override
    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        next.leaveGroup();
        DefaultFlowController fc = next.getFlowController();
        boolean advanceRequested = fc.isAdvanceRequested();
        boolean advanceable = fc.getMasterRow().isAdvanceable();
        if (this.isRootGroup(next)) {
            if (advanceRequested && advanceable) {
                DefaultFlowController cfc = fc.performCommit();
                next.setFlowController(cfc);
                next.setAdvanceHandler(BeginGroupHandler.HANDLER);
                return next;
            }
            next.setAdvanceHandler(ReportFooterHandler.HANDLER);
            return next;
        }
        if (!advanceRequested || !advanceable) {
            next.setAdvanceHandler(EndGroupBodyHandler.HANDLER);
            return next;
        }
        Group group = next.getReport().getGroup(next.getCurrentGroupIndex());
        DefaultFlowController cfc = fc.performCommit();
        if (ProcessState.isLastItemInGroup(group, fc.getMasterRow(), cfc.getMasterRow())) {
            next.setAdvanceHandler(EndGroupBodyHandler.HANDLER);
            return next;
        }
        next.setFlowController(cfc);
        next.setAdvanceHandler(BeginGroupHandler.HANDLER);
        return next;
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    private boolean isRootGroup(ProcessState state) {
        return state.getCurrentGroupIndex() == -1;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

