/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.css;

import java.io.Serializable;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;

public class ElementStyleDefinition
implements Serializable,
Cloneable {
    private ArrayList<ElementStyleDefinition> styles;
    private ArrayList<ElementStyleSheet> rules = new ArrayList();

    public ElementStyleDefinition() {
        this.styles = new ArrayList();
    }

    public ElementStyleSheet getRule(int index) {
        return this.rules.get(index);
    }

    public void addRule(ElementStyleSheet rule) {
        this.rules.add(rule);
    }

    public void addRule(int index, ElementStyleSheet rule) {
        this.rules.add(index, rule);
    }

    public void removeRule(int index) {
        this.rules.remove(index);
    }

    public void removeRule(ElementStyleSheet rule) {
        this.rules.remove(rule);
    }

    public boolean updateRule(ElementStyleSheet rule) {
        for (int index = 0; index < this.getRuleCount(); ++index) {
            ElementStyleSheet styleDefinition = this.getRule(index);
            if (styleDefinition == null || styleDefinition.getId() != rule.getId()) continue;
            this.removeRule(index);
            this.addRule(index, rule);
            return true;
        }
        return false;
    }

    public void clearRules() {
        this.rules.clear();
    }

    public int getRuleCount() {
        return this.rules.size();
    }

    public int getStyleSheetCount() {
        return this.styles.size();
    }

    public ElementStyleDefinition getStyleSheet(int index) {
        return this.styles.get(index);
    }

    public void addStyleSheet(ElementStyleDefinition rule) {
        this.styles.add(rule);
    }

    public void addStyleSheet(int index, ElementStyleDefinition rule) {
        this.styles.add(index, rule);
    }

    public void removeStyleSheet(int index) {
        this.styles.remove(index);
    }

    public void removeStyleSheet(ElementStyleDefinition rule) {
        this.styles.remove(rule);
    }

    public void clearStyleSheet() {
        this.styles.clear();
    }

    public ElementStyleDefinition clone() {
        try {
            Cloneable styleDefinition;
            int i;
            ElementStyleDefinition clone = (ElementStyleDefinition)super.clone();
            clone.styles = (ArrayList)this.styles.clone();
            for (i = 0; i < this.styles.size(); ++i) {
                styleDefinition = this.styles.get(i);
                clone.styles.set(i, ((ElementStyleDefinition)styleDefinition).clone());
            }
            clone.rules = (ArrayList)this.rules.clone();
            for (i = 0; i < this.rules.size(); ++i) {
                styleDefinition = this.rules.get(i);
                clone.rules.set(i, ((ElementStyleSheet)styleDefinition).clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public ElementStyleDefinition derive(boolean preserveIds) {
        try {
            Cloneable styleDefinition;
            int i;
            ElementStyleDefinition clone = (ElementStyleDefinition)super.clone();
            clone.styles = (ArrayList)this.styles.clone();
            for (i = 0; i < this.styles.size(); ++i) {
                styleDefinition = this.styles.get(i);
                clone.styles.set(i, ((ElementStyleDefinition)styleDefinition).derive(preserveIds));
            }
            clone.rules = (ArrayList)this.rules.clone();
            for (i = 0; i < this.rules.size(); ++i) {
                styleDefinition = this.rules.get(i);
                clone.rules.set(i, ((ElementStyleSheet)styleDefinition).derive(preserveIds));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

