/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.css;

import org.pentaho.reporting.engine.classic.core.style.css.StyleSheetParserUtil;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class FixNamespaceSelectorFactory
implements SelectorFactory {
    private SelectorFactory parent;
    private StyleSheetParserUtil styleSheetParserUtil;
    private NamespaceCollection namespaceCollection;

    public FixNamespaceSelectorFactory(SelectorFactory parent, NamespaceCollection namespaceCollection) {
        this.namespaceCollection = namespaceCollection;
        if (parent == null) {
            throw new NullPointerException();
        }
        this.styleSheetParserUtil = StyleSheetParserUtil.getInstance();
        this.parent = parent;
    }

    public ConditionalSelector createConditionalSelector(SimpleSelector selector, Condition condition) throws CSSException {
        return this.parent.createConditionalSelector(selector, condition);
    }

    public SimpleSelector createAnyNodeSelector() throws CSSException {
        return this.parent.createAnyNodeSelector();
    }

    public SimpleSelector createRootNodeSelector() throws CSSException {
        return this.parent.createRootNodeSelector();
    }

    public NegativeSelector createNegativeSelector(SimpleSelector selector) throws CSSException {
        return this.parent.createNegativeSelector(selector);
    }

    public ElementSelector createElementSelector(String namespaceURI, String tagName) throws CSSException {
        if (namespaceURI != null) {
            return this.parent.createElementSelector(namespaceURI, tagName);
        }
        if (tagName == null) {
            return this.parent.createElementSelector(null, null);
        }
        this.styleSheetParserUtil = StyleSheetParserUtil.getInstance();
        String[] ns = this.styleSheetParserUtil.parseNamespaceIdent(tagName, this.namespaceCollection);
        return this.parent.createElementSelector(ns[0], ns[1]);
    }

    public CharacterDataSelector createTextNodeSelector(String data) throws CSSException {
        return this.parent.createTextNodeSelector(data);
    }

    public CharacterDataSelector createCDataSectionSelector(String data) throws CSSException {
        return this.parent.createCDataSectionSelector(data);
    }

    public ProcessingInstructionSelector createProcessingInstructionSelector(String target, String data) throws CSSException {
        return this.parent.createProcessingInstructionSelector(target, data);
    }

    public CharacterDataSelector createCommentSelector(String data) throws CSSException {
        return this.parent.createCommentSelector(data);
    }

    public ElementSelector createPseudoElementSelector(String namespaceURI, String pseudoName) throws CSSException {
        if (namespaceURI != null) {
            return this.parent.createPseudoElementSelector(namespaceURI, pseudoName);
        }
        String[] ns = this.styleSheetParserUtil.parseNamespaceIdent(pseudoName, this.namespaceCollection);
        return this.parent.createPseudoElementSelector(ns[0], ns[1]);
    }

    public DescendantSelector createDescendantSelector(Selector parent, SimpleSelector descendant) throws CSSException {
        return this.parent.createDescendantSelector(parent, descendant);
    }

    public DescendantSelector createChildSelector(Selector parent, SimpleSelector child) throws CSSException {
        return this.parent.createChildSelector(parent, child);
    }

    public SiblingSelector createDirectAdjacentSelector(short nodeType, Selector child, SimpleSelector directAdjacent) throws CSSException {
        return this.parent.createDirectAdjacentSelector(nodeType, child, directAdjacent);
    }
}

