/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.io.Serializable;
import java.util.Arrays;

public class LongList
implements Serializable,
Cloneable {
    private static final long[] EMPTY_ARRAY = new long[0];
    private long[] data;
    private int size;
    private int increment;

    public LongList(int capacity) {
        this.data = new long[capacity];
        this.increment = capacity;
    }

    public LongList(long[] data, int increment) {
        this.increment = increment;
        this.data = (long[])data.clone();
    }

    private void ensureCapacity(int c) {
        if (this.data.length <= c) {
            long[] newData = new long[Math.max(this.data.length + this.increment, c + 1)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void add(long value) {
        this.ensureCapacity(this.size);
        this.data[this.size] = value;
        ++this.size;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException();
        }
        int tailSize = this.size - index - 1;
        if (tailSize > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, tailSize);
        }
        --this.size;
        this.data[this.size] = 0L;
    }

    public void set(int index, long value) {
        this.ensureCapacity(index);
        this.data[index] = value;
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    public long get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Illegal Index: " + index + " Max:" + this.size);
        }
        return this.data[index];
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public long[] toArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        if (this.size == this.data.length) {
            return (long[])this.data.clone();
        }
        long[] retval = new long[this.size];
        System.arraycopy(this.data, 0, retval, 0, this.size);
        return retval;
    }

    public long[] toArray(long[] retval) {
        if (retval == null || retval.length < this.size) {
            retval = new long[this.size];
        }
        System.arraycopy(this.data, 0, retval, 0, this.size);
        return retval;
    }

    public Object clone() throws CloneNotSupportedException {
        LongList intList = (LongList)super.clone();
        intList.data = (long[])this.data.clone();
        return intList;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LongList={size=");
        b.append(this.size);
        b.append(", data={");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append(this.data[i]);
        }
        b.append("}}");
        return b.toString();
    }

    public void fill(long value) {
        Arrays.fill(this.data, value);
    }
}

