/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import org.pentaho.reporting.engine.classic.core.util.PropertyLookupParser;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

public abstract class BeanPropertyLookupParser
extends PropertyLookupParser {
    protected BeanPropertyLookupParser() {
    }

    protected abstract Object performInitialLookup(String var1);

    @Override
    protected String lookupVariable(String entity) {
        CSVTokenizer tokenizer = new CSVTokenizer(entity, ".");
        if (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            Object base = this.performInitialLookup(name);
            try {
                if (tokenizer.hasMoreTokens()) {
                    return BeanPropertyLookupParser.continueLookupVariable(tokenizer, base);
                }
                return ConverterRegistry.toAttributeValue(base);
            }
            catch (BeanException e) {
                return entity;
            }
        }
        return entity;
    }

    private static String continueLookupVariable(CSVTokenizer tokenizer, Object parent) throws BeanException {
        if (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            Object base = ConverterRegistry.toPropertyValue(name, parent.getClass());
            if (tokenizer.hasMoreTokens()) {
                return BeanPropertyLookupParser.continueLookupVariable(tokenizer, base);
            }
            return ConverterRegistry.toAttributeValue(base);
        }
        return null;
    }
}

