/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer;

import java.io.IOException;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataFactoryWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer.CubeFileProviderWriteHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer.DataSourceProviderWriteHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public abstract class AbstractMDXDataFactoryWriteHandler
implements DataFactoryWriteHandler {
    protected AbstractMDXDataFactoryWriteHandler() {
    }

    protected void writeBody(ReportWriterContext reportWriterContext, AbstractMDXDataFactory mdxDataFactory, XmlWriter xmlWriter) throws IOException, ReportWriterException {
        CubeFileProvider cubeFileProvider;
        AttributeList configAttrs = new AttributeList();
        if (mdxDataFactory.getJdbcPassword() != null) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "jdbc-password", String.valueOf(mdxDataFactory.getJdbcPassword()));
        }
        if (mdxDataFactory.getJdbcUser() != null) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "jdbc-user", String.valueOf(mdxDataFactory.getJdbcUser()));
        }
        if (mdxDataFactory.getRole() != null) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "role", String.valueOf(mdxDataFactory.getRole()));
        }
        if (mdxDataFactory.getJdbcPasswordField() != null) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "jdbc-password-field", String.valueOf(mdxDataFactory.getJdbcPasswordField()));
        }
        if (mdxDataFactory.getJdbcUserField() != null) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "jdbc-user-field", String.valueOf(mdxDataFactory.getJdbcUserField()));
        }
        if (mdxDataFactory.getRoleField() != null) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "role-field", String.valueOf(mdxDataFactory.getRoleField()));
        }
        if (mdxDataFactory.getDesignTimeName() != null) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "design-time-name", String.valueOf(mdxDataFactory.getDesignTimeName()));
        }
        this.writeProperties(xmlWriter, mdxDataFactory.getBaseConnectionProperties(), "mondrian-properties");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "connection", configAttrs, false);
        DataSourceProvider dataSourceProvider = mdxDataFactory.getDataSourceProvider();
        if (dataSourceProvider != null) {
            this.writeConnectionInfo(reportWriterContext, xmlWriter, dataSourceProvider);
        }
        if ((cubeFileProvider = mdxDataFactory.getCubeFileProvider()) != null) {
            this.writeCubeInfo(reportWriterContext, xmlWriter, cubeFileProvider);
        }
        xmlWriter.writeCloseTag();
    }

    private void writeProperties(XmlWriter writer, Properties properties, String tagName) throws IOException {
        if (properties.isEmpty()) {
            return;
        }
        writer.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", tagName, false);
        String[] propertyNames = properties.keySet().toArray(new String[properties.size()]);
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = propertyNames[i];
            String value = properties.getProperty(name);
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/mondrian", "property", "name", name, false);
            if (name.toLowerCase().contains("password")) {
                writer.writeTextNormalized(PasswordEncryptionService.getInstance().encrypt(value), false);
            } else {
                writer.writeTextNormalized(value, false);
            }
            writer.writeCloseTag();
        }
        writer.writeCloseTag();
    }

    private void writeConnectionInfo(ReportWriterContext context, XmlWriter xmlWriter, DataSourceProvider connectionProvider) throws IOException, ReportWriterException {
        String configKey = "org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer.datasource-provider." + connectionProvider.getClass().getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value == null) {
            throw new ReportWriterException("Unable to locate writer for " + connectionProvider.getClass().getName());
        }
        DataSourceProviderWriteHandler handler = (DataSourceProviderWriteHandler)ObjectUtilities.loadAndInstantiate((String)value, AbstractMDXDataFactoryWriteHandler.class, DataSourceProviderWriteHandler.class);
        if (handler == null) {
            throw new ReportWriterException("Invalid handler for " + connectionProvider.getClass().getName());
        }
        handler.write(context, xmlWriter, connectionProvider);
    }

    private void writeCubeInfo(ReportWriterContext context, XmlWriter xmlWriter, CubeFileProvider cubeFileProvider) throws IOException, ReportWriterException {
        String configKey = "org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.writer.cubefile-provider." + cubeFileProvider.getClass().getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value == null) {
            throw new ReportWriterException("Unable to locate writer for " + cubeFileProvider.getClass().getName());
        }
        CubeFileProviderWriteHandler handler = (CubeFileProviderWriteHandler)ObjectUtilities.loadAndInstantiate((String)value, AbstractMDXDataFactoryWriteHandler.class, CubeFileProviderWriteHandler.class);
        if (handler == null) {
            throw new ReportWriterException("Invalid handler for " + cubeFileProvider.getClass().getName());
        }
        handler.write(context, xmlWriter, cubeFileProvider);
    }
}

