/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.context.Allocator;
import javolution.context.AllocatorContext;
import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.util.FastMap;
import javolution.util.FastTable;

public final class ImmortalContext
extends AllocatorContext {
    private static final Class CLASS = new ImmortalContext().getClass();
    private static final ThreadLocal FACTORY_TO_ALLOCATOR = new ThreadLocal(){

        protected Object initialValue() {
            return new FastMap();
        }
    };
    private static final ThreadLocal ACTIVE_ALLOCATORS = new ThreadLocal(){

        protected Object initialValue() {
            return new FastTable();
        }
    };

    public static ImmortalContext enter() {
        return (ImmortalContext)Context.enter(CLASS);
    }

    public static ImmortalContext exit() {
        return (ImmortalContext)Context.exit();
    }

    private ImmortalContext() {
    }

    protected void deactivate() {
        FastTable fastTable = (FastTable)ACTIVE_ALLOCATORS.get();
        int n = 0;
        int n2 = fastTable.size();
        while (n < n2) {
            ((Allocator)fastTable.get((int)n++)).user = null;
        }
        fastTable.clear();
    }

    protected Allocator getAllocator(ObjectFactory objectFactory) {
        FastMap fastMap = (FastMap)FACTORY_TO_ALLOCATOR.get();
        ImmortalAllocator immortalAllocator = (ImmortalAllocator)fastMap.get(objectFactory);
        if (immortalAllocator == null) {
            immortalAllocator = new ImmortalAllocator(objectFactory);
            fastMap.put(objectFactory, immortalAllocator);
        }
        if (immortalAllocator.user == null) {
            immortalAllocator.user = Thread.currentThread();
            FastTable fastTable = (FastTable)ACTIVE_ALLOCATORS.get();
            fastTable.add(immortalAllocator);
        }
        return immortalAllocator;
    }

    protected void enterAction() {
        this.getOuter().getAllocatorContext().deactivate();
    }

    protected void exitAction() {
        this.deactivate();
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new ImmortalContext();
            }
        }, CLASS);
    }

    private static final class ImmortalAllocator
    extends Allocator {
        private static final MemoryArea IMMORTAL = MemoryArea.getMemoryArea("");
        private final ObjectFactory _factory;
        private Object _allocated;
        private final Runnable _allocate = new Runnable(){

            public void run() {
                ImmortalAllocator.this._allocated = ImmortalAllocator.this._factory.create();
            }
        };
        private final Runnable _resize = new Runnable(){

            public void run() {
                ImmortalAllocator.this.resize();
            }
        };

        public ImmortalAllocator(ObjectFactory objectFactory) {
            this._factory = objectFactory;
        }

        protected Object allocate() {
            IMMORTAL.executeInArea(this._allocate);
            return this._allocated;
        }

        protected void recycle(Object object) {
            if (this._factory.doCleanup()) {
                this._factory.cleanup(object);
            }
            if (this.queueSize >= this.queue.length) {
                IMMORTAL.executeInArea(this._resize);
            }
            this.queue[this.queueSize++] = object;
        }

        public String toString() {
            return "Immortal allocator for " + this._factory.getClass();
        }
    }
}

