/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.realtime.MemoryArea;
import javolution.JavolutionError;
import javolution.context.LogContext;
import javolution.context.ObjectFactory;
import javolution.context.PersistentContext;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.lang.Reusable;
import javolution.text.Text;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.xml.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastMap<K, V>
implements Map<K, V>,
Reusable,
XMLSerializable,
Realtime {
    private static final int B0 = 4;
    private static final int C0 = 16;
    private static final int B1 = 10;
    private static final int C1 = 1024;
    private static final int B2 = 6;
    private static final int C2 = 64;
    private transient Entry<K, V>[] _entries;
    private transient FastMap[] _subMaps;
    private transient boolean _useSubMaps;
    private transient int _keyShift;
    private transient Entry<K, V> _head;
    private transient Entry<K, V> _tail;
    private transient int _size;
    private transient Values _values;
    private transient KeySet _keySet;
    private transient EntrySet _entrySet;
    private transient Map<K, V> _unmodifiable;
    private transient int _nullCount;
    private transient FastComparator _keyComparator = FastComparator.DEFAULT;
    private transient FastComparator _valueComparator = FastComparator.DEFAULT;
    private transient FastComparator _keyComp = FastComparator._Rehash ? FastComparator.REHASH : null;
    private transient boolean _isShared;
    private static final Entry[] NULL_ENTRIES = new Entry[1024];
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastMap();
        }

        public void cleanup(Object object) {
            ((FastMap)object).reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public FastMap() {
        this(4);
    }

    public FastMap(String string) {
        this();
        new PersistentContext.Reference(string, this){

            protected void notifyChange() {
                FastMap.this.clear();
                FastMap.this.putAll((FastMap)this.get());
            }
        };
    }

    public FastMap(int n) {
        this.setup(n);
    }

    private void setup(int n) {
        int n2;
        for (n2 = 16; n2 < n; n2 <<= 1) {
        }
        n2 = MathLib.min(n2 << 1, 1024);
        this._entries = new Entry[n2];
        this._head = this.newEntry();
        this._tail = this.newEntry();
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        Entry<K, V> entry = this._tail;
        int n3 = 0;
        while (n3++ < n) {
            Entry<K, V> entry2 = this.newEntry();
            ((Entry)entry2)._previous = (Entry)entry;
            ((Entry)entry)._next = (Entry)entry2;
            entry = entry2;
        }
    }

    public FastMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    private FastMap(Entry[] entryArray) {
        this._entries = entryArray;
    }

    public static <K, V> FastMap<K, V> newInstance() {
        return (FastMap)FACTORY.object();
    }

    public static void recycle(FastMap fastMap) {
        FACTORY.recycle(fastMap);
    }

    public final Entry<K, V> head() {
        return this._head;
    }

    public final Entry<K, V> tail() {
        return this._tail;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final boolean isEmpty() {
        return ((Entry)this._head)._next == this._tail;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public final boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    @Override
    public final V get(Object object) {
        Entry entry = this.getEntry(object, this._keyComp == null ? object.hashCode() : this._keyComp.hashCodeOf(object));
        return (V)(entry != null ? entry._value : null);
    }

    public final Entry<K, V> getEntry(Object object) {
        return this.getEntry(object, this._keyComp == null ? object.hashCode() : this._keyComp.hashCodeOf(object));
    }

    private final Entry getEntry(Object object, int n) {
        Entry<K, V> entry;
        int n2 = n >> this._keyShift;
        if (this._useSubMaps) {
            return this._subMaps[n2 & 0x3F].getEntry(object, n);
        }
        Entry<K, V>[] entryArray = this._entries;
        do {
            if ((entry = entryArray[n2++ & entryArray.length - 1]) != null) continue;
            return null;
        } while (object != ((Entry)entry)._key && (n != ((Entry)entry)._keyHash || !(this._keyComp == null ? object.equals(((Entry)entry)._key) : this._keyComp.areEqual(object, ((Entry)entry)._key))));
        return entry;
    }

    @Override
    public final V put(K k, V v) {
        int n = this._keyComp == null ? k.hashCode() : this._keyComp.hashCodeOf(k);
        Entry entry = this.getEntry(k, n);
        if (entry != null) {
            Object object = entry._value;
            entry._value = v;
            return (V)object;
        }
        if (this._isShared) {
            return this.putShared(k, v, n);
        }
        this.addEntry(n, k, v);
        return null;
    }

    private synchronized V putShared(K k, V v, int n) {
        Entry entry = this.getEntry(k, n);
        if (entry == null) {
            this.addEntry(n, k, v);
            return null;
        }
        Object object = entry._value;
        entry._value = v;
        return (V)object;
    }

    private void addEntry(int n, K k, V v) {
        if (((Entry)this._tail)._next == null) {
            this.createNewEntries();
        }
        Entry entry = ((Entry)this._tail)._next;
        ((Entry)this._tail)._key = k;
        ((Entry)this._tail)._value = v;
        ((Entry)this._tail)._keyHash = n;
        this.mapEntry(this._tail);
        this._tail = entry;
    }

    private void createNewEntries() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                Entry entry = FastMap.this.newEntry();
                entry._previous = FastMap.this._tail;
                FastMap.this._tail._next = entry;
                Entry entry2 = FastMap.this.newEntry();
                entry2._previous = entry;
                entry._next = entry2;
                Entry entry3 = FastMap.this.newEntry();
                entry3._previous = entry2;
                entry2._next = entry3;
                Entry entry4 = FastMap.this.newEntry();
                entry4._previous = entry3;
                entry3._next = entry4;
            }
        });
    }

    private void mapEntry(Entry entry) {
        int n;
        Entry<K, V> entry2;
        ++this._size;
        int n2 = entry._keyHash >> this._keyShift;
        if (this._useSubMaps) {
            this._subMaps[n2 & 0x3F].mapEntry(entry);
            return;
        }
        while ((entry2 = this._entries[n = n2++ & this._entries.length - 1]) != null && entry2 != Entry.NULL) {
        }
        this._entries[n] = entry;
        if (this._size + this._nullCount > this._entries.length >> 1) {
            this.resizeTable();
        }
    }

    private void resizeTable() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int n;
                Entry entry;
                int n2;
                int n3 = FastMap.this._nullCount > FastMap.this._size ? FastMap.this._entries.length : FastMap.this._entries.length << 1;
                FastMap.this._nullCount = 0;
                if (n3 > 1024) {
                    int n4;
                    if (FastMap.this._subMaps == null) {
                        FastMap.access$902(FastMap.this, new FastMap[64]);
                        for (n4 = 0; n4 < 64; ++n4) {
                            FastMap fastMap = new FastMap(new Entry[16]);
                            fastMap._keyShift = 6 + FastMap.this._keyShift;
                            ((FastMap)FastMap.this)._subMaps[n4] = fastMap;
                        }
                    }
                    n4 = 1;
                    n2 = 0;
                    while (n2 < FastMap.this._entries.length) {
                        entry = FastMap.this._entries[n2++];
                        if (entry == null || entry == Entry.NULL) continue;
                        n = entry._keyHash >> FastMap.this._keyShift;
                        FastMap fastMap = FastMap.this._subMaps[n & 0x3F];
                        if (fastMap._size >= FastMap.this._size >> 1) {
                            n4 = 0;
                            break;
                        }
                        fastMap.mapEntry(entry);
                    }
                    if (n4 != 0) {
                        FastMap.this._useSubMaps = true;
                        return;
                    }
                    LogContext.warning("Uneven hash distribution");
                    FastMap.access$902(FastMap.this, null);
                }
                Entry[] entryArray = new Entry[n3];
                n2 = 0;
                block2: while (n2 < FastMap.this._entries.length) {
                    entry = FastMap.this._entries[n2++];
                    if (entry == null || entry == Entry.NULL) continue;
                    n = entry._keyHash >> FastMap.this._keyShift;
                    while (true) {
                        int n5;
                        Entry entry2;
                        if ((entry2 = entryArray[n5 = n & n3 - 1]) == null) {
                            entryArray[n5] = entry;
                            continue block2;
                        }
                        ++n;
                    }
                }
                FastMap.access$802(FastMap.this, entryArray);
            }
        });
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V putIfAbsent(K k, V v) {
        int n = this._keyComp == null ? k.hashCode() : this._keyComp.hashCodeOf(k);
        Entry entry = this.getEntry(k, n);
        if (entry != null) {
            return (V)entry._value;
        }
        if (this._isShared) {
            FastMap fastMap = this;
            synchronized (fastMap) {
                entry = this.getEntry(k, n);
                if (entry != null) {
                    return (V)entry._value;
                }
                this.addEntry(n, k, v);
                return null;
            }
        }
        this.addEntry(n, k, v);
        return null;
    }

    @Override
    public final V remove(Object object) {
        int n = this._keyComp == null ? object.hashCode() : this._keyComp.hashCodeOf(object);
        Entry entry = this.getEntry(object, n);
        if (entry == null) {
            return null;
        }
        if (this._isShared) {
            return this.removeShared(object, n);
        }
        Object object2 = entry._value;
        this.removeEntry(entry);
        return (V)object2;
    }

    private synchronized V removeShared(Object object, int n) {
        Entry entry = this.getEntry(object, n);
        if (entry == null) {
            return null;
        }
        Object object2 = entry._value;
        this.removeEntry(entry);
        return (V)object2;
    }

    private final void removeEntry(Entry entry) {
        entry._previous._next = entry._next;
        entry._next._previous = entry._previous;
        this.unmapEntry(entry);
        if (!this._isShared) {
            entry._key = null;
            entry._value = null;
            Entry entry2 = ((Entry)this._tail)._next;
            entry._previous = (Entry)this._tail;
            entry._next = entry2;
            ((Entry)this._tail)._next = entry;
            if (entry2 != null) {
                entry2._previous = entry;
            }
        }
    }

    private void unmapEntry(Entry entry) {
        --this._size;
        if (this._useSubMaps) {
            this._subMaps[entry._keyHash >> this._keyShift & 0x3F].unmapEntry(entry);
            return;
        }
        this._entries[FastMap.indexOf((Entry)entry, (Entry[])this._entries, (int)this._keyShift)] = Entry.NULL;
        ++this._nullCount;
    }

    public FastMap<K, V> setShared(boolean bl) {
        this._isShared = bl;
        return this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public FastMap<K, V> setKeyComparator(FastComparator<? super K> fastComparator) {
        this._keyComparator = fastComparator;
        this._keyComp = fastComparator instanceof FastComparator.Default ? (FastComparator._Rehash ? FastComparator.REHASH : null) : (fastComparator instanceof FastComparator.Direct ? null : fastComparator);
        return this;
    }

    public FastComparator<? super K> getKeyComparator() {
        return this._keyComparator;
    }

    public FastMap<K, V> setValueComparator(FastComparator<? super V> fastComparator) {
        this._valueComparator = fastComparator;
        return this;
    }

    public FastComparator<? super V> getValueComparator() {
        return this._valueComparator;
    }

    @Override
    public final void clear() {
        if (this._isShared) {
            this.clearShared();
            return;
        }
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            entry._key = null;
            entry._value = null;
        }
        this._tail = ((Entry)this._head)._next;
        this.clearTables();
    }

    private void clearTables() {
        if (this._useSubMaps) {
            int n = 0;
            while (n < 64) {
                this._subMaps[n++].clearTables();
            }
            this._useSubMaps = false;
        }
        System.arraycopy(NULL_ENTRIES, 0, this._entries, 0, this._entries.length);
        this._size = 0;
        this._nullCount = 0;
    }

    private synchronized void clearShared() {
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        this._entries = new Entry[16];
        if (this._useSubMaps) {
            this._useSubMaps = false;
            int n = 0;
            while (n < 64) {
                this._subMaps[n++] = new FastMap<K, V>(new Entry[16]);
            }
        }
        this._size = 0;
        this._nullCount = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((Object)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            n += entry.hashCode();
        }
        return n;
    }

    @Override
    public Text toText() {
        return Text.valueOf(this.entrySet());
    }

    public final String toString() {
        return this.toText().toString();
    }

    protected Entry<K, V> newEntry() {
        return new Entry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream printStream) {
        long l = this.getSumDistance();
        int n = this._size != 0 ? (int)(l / (long)this._size) : 0;
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.print("SIZE: " + this._size);
            printStream.print(", TABLE LENGTH: " + this._entries.length);
            printStream.print(", USE SUB-MAPS: " + this._useSubMaps);
            printStream.print(", SUB-MAPS DEPTH: " + this.getSubMapDepth());
            printStream.print(", NULL COUNT: " + this._nullCount);
            printStream.print(", IS SHARED: " + this._isShared);
            printStream.print(", AVG DISTANCE: " + n);
            printStream.print(", MAX DISTANCE: " + this.getMaximumDistance());
            printStream.println();
        }
    }

    private int getMaximumDistance() {
        int n = 0;
        if (this._useSubMaps) {
            for (int i = 0; i < 64; ++i) {
                int n2 = this._subMaps[i].getMaximumDistance();
                n = MathLib.max(n, n2);
            }
            return n;
        }
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<K, V> entry = this._entries[i];
            if (entry == null) continue;
            int n3 = i - FastMap.slotOf(entry, this._entries, this._keyShift);
            if (n3 < 0) {
                n3 += this._entries.length;
            }
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    private long getSumDistance() {
        long l = 0L;
        if (this._useSubMaps) {
            for (int i = 0; i < 64; ++i) {
                l += this._subMaps[i].getSumDistance();
            }
            return l;
        }
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<K, V> entry = this._entries[i];
            if (entry == null) continue;
            int n = i - FastMap.slotOf(entry, this._entries, this._keyShift);
            if (n < 0) {
                n += this._entries.length;
            }
            l += (long)n;
        }
        return l;
    }

    private int getSubMapDepth() {
        if (this._useSubMaps) {
            int n = 0;
            for (int i = 0; i < 64; ++i) {
                int n2 = this._subMaps[i].getSubMapDepth();
                n = MathLib.max(n, n2);
            }
            return n + 1;
        }
        return 0;
    }

    @Override
    public final Collection<V> values() {
        if (this._values == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._values = new Values();
                }
            });
        }
        return this._values;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this._entrySet == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._entrySet = new EntrySet();
                }
            });
        }
        return this._entrySet;
    }

    @Override
    public final Set<K> keySet() {
        if (this._keySet == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._keySet = new KeySet();
                }
            });
        }
        return this._keySet;
    }

    public final Map<K, V> unmodifiable() {
        if (this._unmodifiable == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastMap.this._unmodifiable = new Unmodifiable();
                }
            });
        }
        return this._unmodifiable;
    }

    @Override
    public void reset() {
        this.setShared(false);
        this.clear();
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setKeyComparator((FastComparator)objectInputStream.readObject());
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        this.setShared(objectInputStream.readBoolean());
        int n = objectInputStream.readInt();
        this.setup(n);
        for (int i = 0; i < n; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.addEntry(this._keyComparator.hashCodeOf(object), object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getKeyComparator());
        objectOutputStream.writeObject(this.getValueComparator());
        objectOutputStream.writeBoolean(this._isShared);
        objectOutputStream.writeInt(this._size);
        Entry entry = this._head;
        Entry<K, V> entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            objectOutputStream.writeObject(entry._key);
            objectOutputStream.writeObject(entry._value);
        }
    }

    private static int slotOf(Entry entry, Entry[] entryArray, int n) {
        return entry._keyHash >> n & entryArray.length - 1;
    }

    private static int indexOf(Entry entry, Entry[] entryArray, int n) {
        int n2 = FastMap.slotOf(entry, entryArray, n);
        Entry entry2;
        while ((entry2 = entryArray[n2]) != entry) {
            if (entry2 == null) {
                throw new JavolutionError("Concurrent maps should be marked shared");
            }
            n2 = n2 + 1 & entryArray.length - 1;
        }
        return n2;
    }

    static /* synthetic */ FastMap[] access$902(FastMap fastMap, FastMap[] fastMapArray) {
        fastMap._subMaps = fastMapArray;
        return fastMapArray;
    }

    static /* synthetic */ Entry[] access$802(FastMap fastMap, Entry[] entryArray) {
        fastMap._entries = entryArray;
        return entryArray;
    }

    private final class Unmodifiable
    implements Map,
    Serializable {
        private Unmodifiable() {
        }

        public boolean equals(Object object) {
            return FastMap.this.equals(object);
        }

        public int hashCode() {
            return FastMap.this.hashCode();
        }

        public Text toText() {
            return FastMap.this.toText();
        }

        public int size() {
            return FastMap.this.size();
        }

        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        public boolean containsKey(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return FastMap.this.containsValue(object);
        }

        public Object get(Object object) {
            return FastMap.this.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Set keySet() {
            return (Set)((KeySet)FastMap.this.keySet()).unmodifiable();
        }

        public Collection values() {
            return ((Values)FastMap.this.values()).unmodifiable();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("Direct view over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the keySet() and values() fast collection views in conjonction.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K, V>
    implements Map.Entry<K, V>,
    FastCollection.Record {
        public static final Entry NULL = new Entry();
        private Entry<K, V> _next;
        private Entry<K, V> _previous;
        private K _key;
        private V _value;
        private int _keyHash;

        protected Entry() {
        }

        @Override
        public final Entry<K, V> getNext() {
            return this._next;
        }

        @Override
        public final Entry<K, V> getPrevious() {
            return this._previous;
        }

        @Override
        public final K getKey() {
            return this._key;
        }

        @Override
        public final V getValue() {
            return this._value;
        }

        @Override
        public final V setValue(V v) {
            V v2 = this._value;
            this._value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return FastComparator.DEFAULT.areEqual(this._key, entry.getKey()) && FastComparator.DEFAULT.areEqual(this._value, entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this._key != null ? this._key.hashCode() : 0) ^ (this._value != null ? this._value.hashCode() : 0);
        }
    }

    private static final class KeyIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new KeyIterator();
            }

            protected void cleanup(Object object) {
                KeyIterator keyIterator = (KeyIterator)object;
                keyIterator._map = null;
                keyIterator._current = null;
                keyIterator._next = null;
                keyIterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static KeyIterator valueOf(FastMap fastMap) {
            KeyIterator keyIterator = (KeyIterator)FACTORY.object();
            keyIterator._map = fastMap;
            keyIterator._next = fastMap._head._next;
            keyIterator._tail = fastMap._tail;
            return keyIterator;
        }

        private KeyIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current._key;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class KeySet
    extends FastCollection
    implements Set {
        private KeySet() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return FastMap.this.remove(object) != null;
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._key;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return FastMap.this._keyComparator;
        }

        public Iterator iterator() {
            return KeyIterator.valueOf(FastMap.this);
        }
    }

    private static final class EntryIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new EntryIterator();
            }

            protected void cleanup(Object object) {
                EntryIterator entryIterator = (EntryIterator)object;
                entryIterator._map = null;
                entryIterator._current = null;
                entryIterator._next = null;
                entryIterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static EntryIterator valueOf(FastMap fastMap) {
            EntryIterator entryIterator = (EntryIterator)FACTORY.object();
            entryIterator._map = fastMap;
            entryIterator._next = fastMap._head._next;
            entryIterator._tail = fastMap._tail;
            return entryIterator;
        }

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class EntrySet
    extends FastCollection
    implements Set {
        private final FastComparator _entryComparator = new FastComparator(){

            public boolean areEqual(Object object, Object object2) {
                if (object instanceof Map.Entry && object2 instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    Map.Entry entry2 = (Map.Entry)object2;
                    return FastMap.this._keyComparator.areEqual(entry.getKey(), entry2.getKey()) && FastMap.this._valueComparator.areEqual(entry.getValue(), entry2.getValue());
                }
                return object == null && object2 == null;
            }

            public int compare(Object object, Object object2) {
                return FastMap.this._keyComparator.compare(object, object2);
            }

            public int hashCodeOf(Object object) {
                Map.Entry entry = (Map.Entry)object;
                return FastMap.this._keyComparator.hashCodeOf(entry.getKey()) + FastMap.this._valueComparator.hashCodeOf(entry.getValue());
            }
        };

        private EntrySet() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Entry entry = (Entry)object;
                Entry entry2 = FastMap.this.getEntry(entry.getKey());
                if (entry2 == null) {
                    return false;
                }
                return FastMap.this._valueComparator.areEqual(entry2.getValue(), entry.getValue());
            }
            return false;
        }

        public Text toText() {
            Text text = Text.valueOf('[');
            Text text2 = Text.valueOf('=');
            Text text3 = Text.valueOf((Object)", ");
            Entry entry = FastMap.this._head;
            Entry entry2 = FastMap.this._tail;
            while ((entry = entry._next) != entry2) {
                text = text.concat(Text.valueOf(entry._key)).concat(text2).concat(Text.valueOf(entry._value));
                if (entry._next == entry2) continue;
                text = text.concat(text3);
            }
            return text.concat(Text.valueOf(']'));
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return (Map.Entry)((Object)record);
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return this._entryComparator;
        }

        public Iterator iterator() {
            return EntryIterator.valueOf(FastMap.this);
        }
    }

    private static final class ValueIterator
    implements Iterator {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            protected Object create() {
                return new ValueIterator();
            }

            protected void cleanup(Object object) {
                ValueIterator valueIterator = (ValueIterator)object;
                valueIterator._map = null;
                valueIterator._current = null;
                valueIterator._next = null;
                valueIterator._tail = null;
            }
        };
        private FastMap _map;
        private Entry _current;
        private Entry _next;
        private Entry _tail;

        public static ValueIterator valueOf(FastMap fastMap) {
            ValueIterator valueIterator = (ValueIterator)FACTORY.object();
            valueIterator._map = fastMap;
            valueIterator._next = fastMap._head._next;
            valueIterator._tail = fastMap._tail;
            return valueIterator;
        }

        private ValueIterator() {
        }

        public boolean hasNext() {
            return this._next != this._tail;
        }

        public Object next() {
            if (this._next == this._tail) {
                throw new NoSuchElementException();
            }
            this._current = this._next;
            this._next = this._next._next;
            return this._current._value;
        }

        public void remove() {
            if (this._current == null) {
                throw new IllegalStateException();
            }
            this._next = this._current._next;
            this._map.remove(this._current._key);
            this._current = null;
        }
    }

    private final class Values
    extends FastCollection {
        private Values() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._value;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }

        public FastComparator getValueComparator() {
            return FastMap.this._valueComparator;
        }

        public Iterator iterator() {
            return ValueIterator.valueOf(FastMap.this);
        }
    }
}

