/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates.crs;

import java.util.Collection;
import java.util.Set;
import javax.measure.unit.NonSI;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.InternationalString;

public abstract class GeographicCRS<C extends Coordinates<?>>
extends CoordinateReferenceSystem<C> {
    public static final CoordinateSystem LATITUDE_LONGITUDE_CS = new CoordinateSystem(){
        CoordinateReferenceSystem.Axis latitudeAxis = new CoordinateReferenceSystem.Axis("Geodetic Latitude", "Lat", NonSI.DEGREE_ANGLE, AxisDirection.NORTH);
        CoordinateReferenceSystem.Axis longitudeAxis = new CoordinateReferenceSystem.Axis("Geodetic Longitude", "Long", NonSI.DEGREE_ANGLE, AxisDirection.EAST);

        @Override
        public int getDimension() {
            return 2;
        }

        @Override
        public CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
            if (dimension == 0) {
                return this.latitudeAxis;
            }
            if (dimension == 1) {
                return this.longitudeAxis;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Identifier getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<String> getAlias() {
            return CoordinateReferenceSystem.EMPTY_SET;
        }

        @Override
        public Set<String> getIdentifiers() {
            return CoordinateReferenceSystem.EMPTY_SET;
        }

        @Override
        public InternationalString getRemarks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toWKT() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    };
}

