/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.function;

import java.io.Serializable;
import javolution.context.ArrayFactory;
import javolution.lang.MathLib;
import javolution.lang.Realtime;
import javolution.lang.ValueType;
import javolution.text.Text;
import javolution.text.TextBuilder;
import org.jscience.mathematics.function.FunctionException;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.structure.Ring;

public final class Term
implements Serializable,
Comparable<Term>,
ValueType,
Realtime {
    public static Term ONE = new Term(0);
    private static final ArrayFactory<Term> FACTORY = new ArrayFactory<Term>(){

        @Override
        protected Term create(int size) {
            return new Term(size);
        }
    };
    private final Variable<?>[] _variables;
    private final int[] _powers;
    private int _size;
    private static final long serialVersionUID = 1L;

    private Term(int capacity) {
        this._variables = new Variable[capacity];
        this._powers = new int[capacity];
    }

    public static Term valueOf(Variable<?> v, int n) {
        if (n == 0) {
            return ONE;
        }
        if (n < 0) {
            throw new IllegalArgumentException("n: " + n + " negative values are not allowed");
        }
        Term term = FACTORY.array(1);
        term._variables[0] = v;
        term._powers[0] = n;
        term._size = 1;
        return term;
    }

    public int size() {
        return this._size;
    }

    public Variable<?> getVariable(int index) {
        if (index > this._size) {
            throw new IllegalArgumentException();
        }
        return this._variables[index];
    }

    public int getPower(int index) {
        if (index > this._size) {
            throw new IllegalArgumentException();
        }
        return this._powers[index];
    }

    public int getPower(Variable<?> v) {
        for (int i = 0; i < this._size; ++i) {
            if (this._variables[i] != v) continue;
            return this._powers[i];
        }
        return 0;
    }

    public Term times(Term that) {
        Variable<?> left;
        int thisSize = this.size();
        int thatSize = that.size();
        Term result = FACTORY.array(thisSize + thatSize);
        result._size = 0;
        int i = 0;
        int j = 0;
        while (true) {
            Variable<?> right;
            left = i < thisSize ? this._variables[i] : null;
            Variable<?> variable = right = j < thatSize ? that._variables[j] : null;
            if (left == null) {
                if (right == null) {
                    return result;
                }
                result._powers[result._size] = that._powers[j++];
                result._variables[result._size++] = right;
                continue;
            }
            if (right == null) {
                result._powers[result._size] = this._powers[i++];
                result._variables[result._size++] = left;
                continue;
            }
            if (right == left) {
                result._powers[result._size] = this._powers[i++] + that._powers[j++];
                result._variables[result._size++] = right;
                continue;
            }
            int cmp = left.getSymbol().compareTo(right.getSymbol());
            if (cmp < 0) {
                result._powers[result._size] = this._powers[i++];
                result._variables[result._size++] = left;
                continue;
            }
            if (cmp <= 0) break;
            result._powers[result._size] = that._powers[j++];
            result._variables[result._size++] = right;
        }
        throw new IllegalArgumentException("Found distinct variables with same symbol: " + left.getSymbol());
    }

    public Term divide(Term that) {
        int cmp;
        Variable<?> left;
        int thisSize = this._size;
        int thatSize = that._size;
        Term result = FACTORY.array(MathLib.max(thisSize, thatSize));
        result._size = 0;
        int i = 0;
        int j = 0;
        while (true) {
            Variable<?> right;
            left = i < thisSize ? this._variables[i] : null;
            Variable<?> variable = right = j < thatSize ? that._variables[j] : null;
            if (left == null) {
                if (right == null) {
                    return result;
                }
                throw new UnsupportedOperationException(this + "/" + that + " would result in a negative power");
            }
            if (right == null) {
                result._powers[result._size] = this._powers[i++];
                result._variables[result._size++] = left;
                continue;
            }
            if (right == left) {
                int power;
                if ((power = this._powers[i++] - that._powers[j++]) < 0) {
                    throw new UnsupportedOperationException(this + "/" + that + " would result in a negative power");
                }
                if (power <= 0) continue;
                result._powers[result._size] = power;
                result._variables[result._size++] = right;
                continue;
            }
            cmp = left.getSymbol().compareTo(right.getSymbol());
            if (cmp >= 0) break;
            result._powers[result._size] = this._powers[i++];
            result._variables[result._size++] = left;
        }
        if (cmp > 0) {
            throw new UnsupportedOperationException(this + "/" + that + " would result in a negative power");
        }
        throw new IllegalArgumentException("Found distinct variables with same symbol: " + left.getSymbol());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Term)) {
            return false;
        }
        Term that = (Term)obj;
        if (this._size != that._size) {
            return false;
        }
        for (int i = 0; i < this._size; ++i) {
            if (this._variables[i].equals(that._variables[i]) && this._powers[i] == that._powers[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int h = 0;
        for (int i = 0; i < this._size; ++i) {
            h += this._variables[i].hashCode() * this._powers[i];
        }
        return h;
    }

    public final String toString() {
        return this.toText().toString();
    }

    @Override
    public Text toText() {
        TextBuilder tb = TextBuilder.newInstance();
        block5: for (int i = 0; i < this._size; ++i) {
            tb.append(this._variables[i].getSymbol());
            int power = this._powers[i];
            switch (power) {
                case 1: {
                    continue block5;
                }
                case 2: {
                    tb.append('\u00b2');
                    continue block5;
                }
                case 3: {
                    tb.append('\u00b3');
                    continue block5;
                }
                default: {
                    tb.append(power);
                }
            }
        }
        return tb.toText();
    }

    @Override
    public Term copy() {
        Term term = FACTORY.array(this._size);
        term._size = this._size;
        for (int i = 0; i < this._size; ++i) {
            term._powers[i] = this._powers[i];
            term._variables[i] = this._variables[i];
        }
        return term;
    }

    @Override
    public int compareTo(Term that) {
        int n = Math.min(this._size, that._size);
        for (int i = 0; i < n; ++i) {
            int cmp = this._variables[i].getSymbol().compareTo(that._variables[i].getSymbol());
            if (cmp != 0) {
                return cmp;
            }
            cmp = that._powers[i] - this._powers[i];
            if (cmp == 0) continue;
            return cmp;
        }
        return that._size - this._size;
    }

    Ring evaluate() {
        Ring result = null;
        for (int i = 0; i < this._size; ++i) {
            Ring pow2 = (Ring)this._variables[i].get();
            if (pow2 == null) {
                throw new FunctionException("Variable: " + this._variables[i] + " is not set");
            }
            for (int n = this._powers[i]; n >= 1; n >>>= 1) {
                if ((n & 1) == 1) {
                    result = result == null ? pow2 : result.times(pow2);
                }
                pow2 = pow2.times(pow2);
            }
        }
        return result;
    }
}

