/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.util.FastTable;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DenseVector;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.LUDecomposition;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.Vector;

public final class DenseMatrix<F extends Field<F>>
extends Matrix<F> {
    int _n;
    boolean _transposed;
    final FastTable<DenseVector<F>> _rows = new FastTable();
    private static ObjectFactory<DenseMatrix> FACTORY = new ObjectFactory<DenseMatrix>(){

        @Override
        protected DenseMatrix create() {
            return new DenseMatrix();
        }

        @Override
        protected void cleanup(DenseMatrix matrix) {
            matrix._rows.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static <F extends Field<F>> DenseMatrix<F> valueOf(F[][] elements) {
        int m = elements.length;
        int n = elements[0].length;
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        for (int i = 0; i < m; ++i) {
            DenseVector row = DenseVector.valueOf(elements[i]);
            if (row.getDimension() != n) {
                throw new DimensionException();
            }
            M._rows.add(row);
        }
        return M;
    }

    public static <F extends Field<F>> DenseMatrix<F> valueOf(DenseVector<F> ... rows) {
        int n = rows[0].getDimension();
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        for (DenseVector<F> rowi : rows) {
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add(rowi);
        }
        return M;
    }

    public static <F extends Field<F>> DenseMatrix<F> valueOf(List<DenseVector<F>> rows) {
        int n = rows.get(0).getDimension();
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        Iterator<DenseVector<F>> iterator = rows.iterator();
        int m = rows.size();
        for (int i = 0; i < m; ++i) {
            DenseVector<F> rowi = iterator.next();
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add(rowi);
        }
        return M;
    }

    public static <F extends Field<F>> DenseMatrix<F> valueOf(Matrix<F> that) {
        if (that instanceof DenseMatrix) {
            return (DenseMatrix)that;
        }
        int n = that.getNumberOfColumns();
        int m = that.getNumberOfRows();
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        for (int i = 0; i < m; ++i) {
            DenseVector<F> rowi = DenseVector.valueOf(that.getRow(i));
            M._rows.add(rowi);
        }
        return M;
    }

    @Override
    public int getNumberOfRows() {
        return this._transposed ? this._n : this._rows.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this._transposed ? this._rows.size() : this._n;
    }

    @Override
    public F get(int i, int j) {
        return this._transposed ? this._rows.get(j).get(i) : this._rows.get(i).get(j);
    }

    @Override
    public DenseVector<F> getRow(int i) {
        if (!this._transposed) {
            return this._rows.get(i);
        }
        int n = this._rows.size();
        int m = this._n;
        if (i < 0 || i >= m) {
            throw new DimensionException();
        }
        DenseVector V = DenseVector.newInstance();
        for (int j = 0; j < n; ++j) {
            V._elements.add(this._rows.get(j).get(i));
        }
        return V;
    }

    @Override
    public DenseVector<F> getColumn(int j) {
        if (this._transposed) {
            return this._rows.get(j);
        }
        int m = this._rows.size();
        if (j < 0 || j >= this._n) {
            throw new DimensionException();
        }
        DenseVector V = DenseVector.newInstance();
        for (int i = 0; i < m; ++i) {
            V._elements.add(this._rows.get(i).get(j));
        }
        return V;
    }

    @Override
    public DenseVector<F> getDiagonal() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int dimension = MathLib.min(m, n);
        DenseVector V = DenseVector.newInstance();
        for (int i = 0; i < dimension; ++i) {
            V._elements.add(this.get(i, i));
        }
        return V;
    }

    @Override
    public DenseMatrix<F> opposite() {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add((DenseVector<F>)this._rows.get(i).opposite());
        }
        return M;
    }

    @Override
    public DenseMatrix<F> plus(Matrix<F> that) {
        if (this.getNumberOfRows() != that.getNumberOfRows()) {
            throw new DimensionException();
        }
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add((DenseVector<F>)this._rows.get(i).plus((Vector)(this._transposed ? that.getColumn(i) : that.getRow(i))));
        }
        return M;
    }

    @Override
    public DenseMatrix<F> minus(Matrix<F> that) {
        return this.plus((Matrix)that.opposite());
    }

    @Override
    public DenseMatrix<F> times(F k) {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add((DenseVector<F>)this._rows.get(i).times((Field)k));
        }
        return M;
    }

    @Override
    public DenseVector<F> times(Vector<F> v) {
        if (v.getDimension() != this.getNumberOfColumns()) {
            throw new DimensionException();
        }
        int m = this.getNumberOfRows();
        DenseVector V = DenseVector.newInstance();
        for (int i = 0; i < m; ++i) {
            V._elements.add(((DenseVector)this.getRow(i)).times(v));
        }
        return V;
    }

    @Override
    public DenseMatrix<F> times(Matrix<F> that) {
        int n = this.getNumberOfColumns();
        int m = this.getNumberOfRows();
        int p = that.getNumberOfColumns();
        if (that.getNumberOfRows() != n) {
            throw new DimensionException();
        }
        DenseMatrix<F> M = DenseMatrix.newInstance(m, true);
        M._rows.setSize(p);
        Multiply<F> multiply = Multiply.valueOf(this, that, 0, p, M._rows);
        multiply.run();
        Multiply.recycle(multiply);
        return M;
    }

    private FastTable<DenseVector<F>> getRows() {
        if (!this._transposed) {
            return this._rows;
        }
        FastTable<DenseVector<F>> rows = FastTable.newInstance();
        for (int i = 0; i < this._n; ++i) {
            rows.add((DenseVector<F>)this.getRow(i));
        }
        return rows;
    }

    @Override
    public DenseMatrix<F> inverse() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        return LUDecomposition.valueOf(this).inverse();
    }

    @Override
    public F determinant() {
        return LUDecomposition.valueOf(this).determinant();
    }

    @Override
    public DenseMatrix<F> transpose() {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, !this._transposed);
        M._rows.addAll(this._rows);
        return M;
    }

    @Override
    public F cofactor(int i, int j) {
        if (this._transposed) {
            int k = i;
            i = j;
            j = k;
        }
        int m = this._rows.size();
        DenseMatrix<F> M = DenseMatrix.newInstance(m - 1, this._transposed);
        for (int k1 = 0; k1 < m; ++k1) {
            if (k1 == i) continue;
            DenseVector<F> row = this._rows.get(k1);
            DenseVector V = DenseVector.newInstance();
            M._rows.add(V);
            for (int k2 = 0; k2 < this._n; ++k2) {
                if (k2 == j) continue;
                V._elements.add(row.get(k2));
            }
        }
        return M.determinant();
    }

    @Override
    public DenseMatrix<F> adjoint() {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        int m = this._rows.size();
        for (int i = 0; i < m; ++i) {
            DenseVector row = DenseVector.newInstance();
            M._rows.add(row);
            for (int j = 0; j < this._n; ++j) {
                F cofactor = this._transposed ? this.cofactor(j, i) : this.cofactor(i, j);
                row._elements.add((i + j) % 2 == 0 ? cofactor : (Field)cofactor.opposite());
            }
        }
        return M.transpose();
    }

    @Override
    public Matrix<F> tensor(Matrix<F> that) {
        int thism = this.getNumberOfRows();
        int thisn = this.getNumberOfColumns();
        int thatm = that.getNumberOfRows();
        int thatn = that.getNumberOfColumns();
        int n = thisn * thatn;
        int m = thism * thatm;
        DenseMatrix<F> M = DenseMatrix.newInstance(n, false);
        for (int i = 0; i < m; ++i) {
            int i_rem_thatm = i % thatm;
            int i_div_thatm = i / thatm;
            DenseVector row = DenseVector.newInstance();
            M._rows.add(row);
            for (int j = 0; j < thisn; ++j) {
                F a = this.get(i_div_thatm, j);
                for (int k = 0; k < thatn; ++k) {
                    row._elements.add(a.times(that.get(i_rem_thatm, k)));
                }
            }
        }
        return M;
    }

    @Override
    public Vector<F> vectorization() {
        DenseVector V = DenseVector.newInstance();
        int n = this.getNumberOfColumns();
        for (int j = 0; j < n; ++j) {
            Vector column = this.getColumn(j);
            int m = column.getDimension();
            for (int i = 0; i < m; ++i) {
                V._elements.add(column.get(i));
            }
        }
        return V;
    }

    @Override
    public DenseMatrix<F> copy() {
        DenseMatrix<F> M = DenseMatrix.newInstance(this._n, this._transposed);
        for (DenseVector<F> row : this._rows) {
            M._rows.add((DenseVector<F>)row.copy());
        }
        return M;
    }

    void set(int i, int j, F e) {
        if (this._transposed) {
            this._rows.get((int)j)._elements.set(i, e);
        } else {
            this._rows.get((int)i)._elements.set(j, e);
        }
    }

    static <F extends Field<F>> DenseMatrix<F> newInstance(int n, boolean transposed) {
        DenseMatrix M = FACTORY.object();
        M._n = n;
        M._transposed = transposed;
        return M;
    }

    private DenseMatrix() {
    }

    private static class Multiply<F extends Field<F>>
    implements Runnable {
        private static final ObjectFactory<Multiply> FACTORY = new ObjectFactory<Multiply>(){

            @Override
            protected Multiply create() {
                return new Multiply();
            }
        };
        private DenseMatrix<F> _left;
        private Matrix<F> _right;
        private int _rightColumnStart;
        private int _rightColumnEnd;
        private FastTable<DenseVector<F>> _columnsResult;

        private Multiply() {
        }

        static <F extends Field<F>> Multiply<F> valueOf(DenseMatrix<F> left, Matrix<F> right, int rightColumnStart, int rightColumnEnd, FastTable<DenseVector<F>> columnsResult) {
            Multiply multiply = FACTORY.object();
            multiply._left = left;
            multiply._right = right;
            multiply._rightColumnStart = rightColumnStart;
            multiply._rightColumnEnd = rightColumnEnd;
            multiply._columnsResult = columnsResult;
            return multiply;
        }

        static <F extends Field<F>> void recycle(Multiply<F> multiply) {
            multiply._left = null;
            multiply._right = null;
            multiply._columnsResult = null;
            FACTORY.recycle(multiply);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this._rightColumnEnd - this._rightColumnStart < 32) {
                FastTable rows = ((DenseMatrix)this._left).getRows();
                int m = rows.size();
                for (int j = this._rightColumnStart; j < this._rightColumnEnd; ++j) {
                    Vector<F> thatColj = this._right.getColumn(j);
                    DenseVector column = DenseVector.newInstance();
                    this._columnsResult.set(j, column);
                    for (int i = 0; i < m; ++i) {
                        column._elements.add(((DenseVector)rows.get(i)).times(thatColj));
                    }
                }
            } else {
                int halfIndex = this._rightColumnStart + this._rightColumnEnd >> 1;
                Multiply<F> firstHalf = Multiply.valueOf(this._left, this._right, this._rightColumnStart, halfIndex, this._columnsResult);
                Multiply<F> secondHalf = Multiply.valueOf(this._left, this._right, halfIndex, this._rightColumnEnd, this._columnsResult);
                ConcurrentContext.enter();
                try {
                    ConcurrentContext.execute(firstHalf);
                    ConcurrentContext.execute(secondHalf);
                }
                finally {
                    ConcurrentContext.exit();
                }
                Multiply.recycle(firstHalf);
                Multiply.recycle(secondHalf);
            }
        }
    }
}

