/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.cda;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaQueryEntry;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.HttpQueryBackend;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.ui.datasources.cda.Messages;
import org.pentaho.reporting.ui.datasources.cda.ParameterEditorDialog;
import org.pentaho.reporting.ui.datasources.cda.QueriesTableModel;

public class CdaDataSourceEditor
extends CommonDialog {
    private JTextField baseUrl;
    private JComboBox baseUrlField;
    private JTextField solution;
    private JTextField path;
    private JTextField file;
    private JCheckBox sugarMode;
    private JTextField username;
    private JTextField password;
    private JCheckBox useLocalCall;
    private QueriesTableModel queriesTableModel;
    private DesignTimeContext designTimeContext;
    private JTable queriesTable;
    private Action editParameterAction;
    private Action previewAction;

    public CdaDataSourceEditor(DesignTimeContext context) {
        this.init(context);
    }

    public CdaDataSourceEditor(DesignTimeContext context, Frame owner) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    public CdaDataSourceEditor(DesignTimeContext context, Dialog owner) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    private void init(DesignTimeContext context) {
        this.designTimeContext = context;
        this.queriesTableModel = new QueriesTableModel();
        this.queriesTable = new JTable(this.queriesTableModel);
        this.baseUrl = new JTextField();
        this.baseUrl.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CdaDataSourceEditor.this.checkBaseUrl();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.baseUrlField = new SmartComboBox();
        this.baseUrlField.setEditable(true);
        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>(context.getDataSchemaModel().getColumnNames());
        comboBoxModel.insertElementAt(null, 0);
        comboBoxModel.setSelectedItem(null);
        this.baseUrlField.setModel(comboBoxModel);
        this.solution = new JTextField();
        this.path = new JTextField();
        this.file = new JTextField();
        this.sugarMode = new JCheckBox(Messages.getString("CdaDataSourceEditor.SugarMode", new Object[0]));
        this.sugarMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CdaDataSourceEditor.this.changeSugarMode(CdaDataSourceEditor.this.sugarMode.isSelected());
            }
        });
        this.username = new JTextField();
        this.password = new JTextField();
        this.useLocalCall = new JCheckBox(Messages.getString("CdaDataSourceEditor.AllowLocalAPICalls", new Object[0]));
        this.editParameterAction = new EditParameterAction();
        this.previewAction = new PreviewAction();
        super.init();
    }

    protected String getDialogId() {
        return "CdaDataSourceEditor";
    }

    protected Component createContentPane() {
        JPanel fetchQueriesPanel = new JPanel();
        fetchQueriesPanel.setLayout(new BorderLayout());
        fetchQueriesPanel.add((Component)new JLabel(Messages.getString("CdaDataSourceEditor.FetchQueryFromServer", new Object[0])), "Center");
        fetchQueriesPanel.add((Component)new JButton(new FetchAction()), "East");
        JPanel previewAndParameterPanel = new JPanel(new BorderLayout());
        previewAndParameterPanel.add((Component)new JButton(this.previewAction), "East");
        previewAndParameterPanel.add((Component)new JButton(this.editParameterAction), "Center");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        panel.add(new JLabel(Messages.getString("CdaDataSourceEditor.ServerURL", new Object[0])));
        panel.add(this.baseUrl);
        panel.add(new JLabel(Messages.getString("CdaDataSourceEditor.ServerURLField", new Object[0])));
        panel.add(this.baseUrlField);
        panel.add(this.sugarMode);
        panel.add(new JLabel(Messages.getString("CdaDataSourceEditor.Username", new Object[0])));
        panel.add(this.username);
        panel.add(new JLabel(Messages.getString("CdaDataSourceEditor.Password", new Object[0])));
        panel.add(this.password);
        panel.add(new JLabel(Messages.getString("CdaDataSourceEditor.Solution", new Object[0])));
        panel.add(this.solution);
        panel.add(new JLabel(Messages.getString("CdaDataSourceEditor.Path", new Object[0])));
        panel.add(this.path);
        panel.add(new JLabel(Messages.getString("CdaDataSourceEditor.File", new Object[0])));
        panel.add(this.file);
        panel.add(this.useLocalCall);
        panel.add(fetchQueriesPanel);
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new BorderLayout());
        cpanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        cpanel.add((Component)panel, "North");
        cpanel.add((Component)new JScrollPane(this.queriesTable), "Center");
        cpanel.add((Component)previewAndParameterPanel, "South");
        return cpanel;
    }

    public DataFactory performConfiguration(CdaDataFactory input, String queryName) {
        if (input != null) {
            this.baseUrl.setText(input.getBaseUrl());
            this.baseUrlField.setSelectedItem(input.getBaseUrlField());
            this.password.setText(input.getPassword());
            this.username.setText(input.getUsername());
            this.file.setText(input.getFile());
            this.solution.setText(input.getSolution());
            this.path.setText(input.getPath());
            this.useLocalCall.setSelected(input.isUseLocalCall());
            this.sugarMode.setSelected(input.isSugarMode());
            this.queriesTableModel.clear();
            String[] queryNames = input.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String name = queryNames[i];
                CdaQueryEntry queryEntry = input.getQueryEntry(name);
                this.queriesTableModel.add(new QueriesTableModel.QueryData(queryEntry, new String[0]));
            }
        } else {
            this.useLocalCall.setSelected(true);
        }
        if (!this.performEdit()) {
            return null;
        }
        return this.produceDataFactory();
    }

    private CdaDataFactory produceDataFactory() {
        CdaDataFactory dataFactory = new CdaDataFactory();
        dataFactory.setBaseUrl(this.baseUrl.getText());
        dataFactory.setBaseUrlField((String)this.baseUrlField.getSelectedItem());
        dataFactory.setPassword(this.password.getText());
        dataFactory.setUsername(this.username.getText());
        dataFactory.setFile(this.file.getText());
        dataFactory.setPath(this.path.getText());
        dataFactory.setSolution(this.solution.getText());
        dataFactory.setUseLocalCall(this.useLocalCall.isSelected());
        dataFactory.setSugarMode(this.sugarMode.isSelected());
        for (int i = 0; i < this.queriesTableModel.size(); ++i) {
            QueriesTableModel.QueryData queryData = this.queriesTableModel.get(i);
            dataFactory.setQueryEntry(queryData.getQueryEntry().getName(), queryData.getQueryEntry());
        }
        return dataFactory;
    }

    private TableModel fetchData(String method, Map<String, String> extraParameter) throws ReportProcessingException {
        CdaDataFactory dataFactory = this.produceDataFactory();
        DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)this.designTimeContext);
        HttpQueryBackend httpQuery = this.getHttpQuery();
        httpQuery.initialize(dataFactory.getDataFactoryContext());
        return httpQuery.fetchData(null, method, extraParameter);
    }

    private HttpQueryBackend getHttpQuery() {
        HttpQueryBackend query = new HttpQueryBackend();
        query.setBaseUrl(this.baseUrl.getText());
        query.setFile(this.file.getText());
        query.setPath(this.path.getText());
        query.setSolution(this.solution.getText());
        query.setSugarMode(this.sugarMode.isSelected());
        query.setUsername(this.username.getText());
        query.setPassword(this.password.getText());
        return query;
    }

    private void checkBaseUrl() {
        if (this.baseUrl.getText().endsWith("/")) {
            this.baseUrl.setText(this.baseUrl.getText().substring(0, this.baseUrl.getText().length() - 1));
        }
    }

    private void changeSugarMode(boolean sugarMode) {
        if (sugarMode) {
            if (!StringUtils.isEmpty((String)this.solution.getText())) {
                String newPathPrefix = this.joinPathStrings("/public", this.solution.getText());
                this.solution.setText("");
                this.path.setText(this.joinPathStrings(newPathPrefix, this.path.getText()));
            }
            if (!StringUtils.isEmpty((String)this.file.getText())) {
                this.path.setText(this.joinPathStrings(this.path.getText(), this.file.getText()));
                this.file.setText("");
            }
        }
        this.file.setEnabled(!sugarMode);
        this.solution.setEnabled(!sugarMode);
    }

    private String joinPathStrings(String first, String second) {
        String separator = "/";
        boolean inFirst = first.endsWith("/");
        boolean inSecond = second.startsWith("/");
        if (inFirst && inSecond) {
            return first + second.substring(1);
        }
        if (!inFirst && !inSecond) {
            return first + "/" + second;
        }
        return first + second;
    }

    private class EditParameterAction
    extends AbstractAction {
        private EditParameterAction() {
            this.putValue("Name", Messages.getString("CdaDataSourceEditor.EditParameter.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = CdaDataSourceEditor.this.queriesTable.getSelectedRow();
            if (selectedRow == -1 || CdaDataSourceEditor.this.queriesTable.getSelectedRowCount() > 1) {
                return;
            }
            QueriesTableModel.QueryData queryData = CdaDataSourceEditor.this.queriesTableModel.get(selectedRow);
            CdaQueryEntry queryEntry = queryData.getQueryEntry();
            try {
                ParameterEditorDialog dialog = new ParameterEditorDialog((Dialog)((Object)CdaDataSourceEditor.this));
                String[] reportFields = CdaDataSourceEditor.this.designTimeContext.getDataSchemaModel().getColumnNames();
                ParameterEditorDialog.EditResult editResult = dialog.performEdit(queryEntry.getParameters(), reportFields, queryData.getDeclaredParameter());
                if (editResult == null) {
                    return;
                }
                queryEntry.setParameters(editResult.getParameterMappings());
            }
            catch (Exception e1) {
                CdaDataSourceEditor.this.designTimeContext.error(e1);
            }
            catch (Throwable t1) {
                CdaDataSourceEditor.this.designTimeContext.error((Exception)new RuntimeException("Fatal error", t1));
            }
        }
    }

    private static class CdaPreviewWorker
    implements PreviewWorker {
        private CdaDataFactory dataFactory;
        private TableModel resultTableModel;
        private ReportDataFactoryException exception;
        private String query;

        private CdaPreviewWorker(CdaDataFactory dataFactory, String query) {
            if (dataFactory == null) {
                throw new NullPointerException();
            }
            this.query = query;
            this.dataFactory = dataFactory;
        }

        public ReportDataFactoryException getException() {
            return this.exception;
        }

        public TableModel getResultTableModel() {
            return this.resultTableModel;
        }

        public void close() {
        }

        public void cancelProcessing(CancelEvent event) {
            this.dataFactory.cancelRunningQuery();
        }

        public void run() {
            try {
                this.resultTableModel = this.dataFactory.queryData(this.query, (DataRow)new ReportParameterValues());
                this.dataFactory.close();
            }
            catch (ReportDataFactoryException e) {
                this.exception = e;
            }
        }
    }

    private class PreviewAction
    extends AbstractAction {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("CdaDataSourceEditor.Preview.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            int selectedRow = CdaDataSourceEditor.this.queriesTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            try {
                CdaDataFactory dataFactory = CdaDataSourceEditor.this.produceDataFactory();
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)CdaDataSourceEditor.this.designTimeContext);
                DataPreviewDialog previewDialog = new DataPreviewDialog((Dialog)((Object)CdaDataSourceEditor.this));
                CdaPreviewWorker worker = new CdaPreviewWorker(dataFactory, CdaDataSourceEditor.this.queriesTableModel.getName(selectedRow));
                previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)CdaDataSourceEditor.this), (String)Messages.getString("ErrorDialog.Title", new Object[0]), (String)Messages.getString("ErrorDialog.PreviewError", new Object[0]), (Exception)((Object)factoryException));
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)((Object)CdaDataSourceEditor.this), (String)Messages.getString("ErrorDialog.Title", new Object[0]), (String)Messages.getString("ErrorDialog.PreviewError", new Object[0]), (Exception)e);
            }
        }
    }

    private class FetchAction
    extends AbstractAction {
        private FetchAction() {
            this.putValue("Name", Messages.getString("CdaDataSourceEditor.FetchAction.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TableModel model = CdaDataSourceEditor.this.fetchData("listQueries", new HashMap());
                QueriesTableModel clone = (QueriesTableModel)CdaDataSourceEditor.this.queriesTableModel.clone();
                CdaDataSourceEditor.this.queriesTableModel.clear();
                for (int i = 0; i < model.getRowCount(); ++i) {
                    String query = (String)model.getValueAt(i, 0);
                    String name = (String)model.getValueAt(i, 1);
                    HashMap<String, String> extraParameter = new HashMap<String, String>();
                    extraParameter.put("dataAccessId", query);
                    TableModel param = CdaDataSourceEditor.this.fetchData("listParameters", extraParameter);
                    HashMap<String, String> oldParamMappings = new HashMap<String, String>();
                    QueriesTableModel.QueryData queryById = clone.getQueryById(query);
                    if (queryById != null) {
                        ParameterMapping[] parameters;
                        for (ParameterMapping parameter : parameters = queryById.getQueryEntry().getParameters()) {
                            oldParamMappings.put(parameter.getAlias(), parameter.getName());
                        }
                    }
                    ParameterMapping[] parameterMappings = new ParameterMapping[param.getRowCount()];
                    String[] declaredParameters = new String[parameterMappings.length];
                    for (int j = 0; j < parameterMappings.length; ++j) {
                        String paramNameOnServer = (String)param.getValueAt(j, 0);
                        String mappedName = (String)oldParamMappings.get(paramNameOnServer);
                        if (mappedName == null) {
                            mappedName = paramNameOnServer;
                        }
                        parameterMappings[j] = new ParameterMapping(mappedName, paramNameOnServer);
                        declaredParameters[j] = paramNameOnServer;
                    }
                    String queryName = StringUtils.isEmpty((String)name) ? "Anonymous Query #" + i : name;
                    CdaQueryEntry entry = new CdaQueryEntry(queryName, query);
                    entry.setParameters(parameterMappings);
                    CdaDataSourceEditor.this.queriesTableModel.add(new QueriesTableModel.QueryData(entry, declaredParameters));
                    extraParameter.clear();
                }
            }
            catch (ReportProcessingException e1) {
                CdaDataSourceEditor.this.designTimeContext.error((Exception)((Object)e1));
            }
        }
    }
}

