/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.cda;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.TagListTableCellEditor;
import org.pentaho.reporting.ui.datasources.cda.CdaDataSourceEditor;
import org.pentaho.reporting.ui.datasources.cda.Messages;
import org.pentaho.reporting.ui.datasources.cda.ParameterMappingTableModel;

public class ParameterEditorDialog
extends CommonDialog {
    private JTable parameterMappingTable;
    private TagListTableCellEditor innerTableCellEditor;
    private TagListTableCellEditor outerTableCellEditor;

    public ParameterEditorDialog() {
        this.init();
    }

    public ParameterEditorDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public ParameterEditorDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    protected void init() {
        super.init();
        this.setTitle(Messages.getString("ParameterEditorDialog.Title", new Object[0]));
    }

    protected String getDialogId() {
        return "CdaDataSourceEditor.ParameterEditor";
    }

    protected Component createContentPane() {
        this.innerTableCellEditor = new TagListTableCellEditor();
        this.outerTableCellEditor = new TagListTableCellEditor();
        this.parameterMappingTable = new JTable(new ParameterMappingTableModel());
        this.parameterMappingTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)this.innerTableCellEditor);
        this.parameterMappingTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)this.outerTableCellEditor);
        this.parameterMappingTable.setSelectionMode(0);
        RemoveParameterAction removeParameterAction = new RemoveParameterAction();
        this.parameterMappingTable.getSelectionModel().addListSelectionListener(removeParameterAction);
        JPanel parameterMappingButtonPanel = new JPanel(new FlowLayout(2, 5, 5));
        parameterMappingButtonPanel.add((Component)new BorderlessButton((Action)new AddParameterAction()));
        parameterMappingButtonPanel.add((Component)new BorderlessButton((Action)new RemoveParameterAction()));
        JPanel parameterMappingPanel = new JPanel(new BorderLayout());
        parameterMappingPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ParameterEditorDialog.ParameterBox", new Object[0])));
        parameterMappingPanel.add((Component)new JScrollPane(this.parameterMappingTable), "Center");
        parameterMappingPanel.add((Component)parameterMappingButtonPanel, "North");
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridLayout(1, 2, 5, 5));
        contentPane.add(parameterMappingPanel);
        return contentPane;
    }

    public EditResult performEdit(ParameterMapping[] parameterMappings, String[] reportFields, String[] declaredParameter) {
        this.innerTableCellEditor.setTags(reportFields);
        this.outerTableCellEditor.setTags(declaredParameter);
        ParameterMappingTableModel parameterMappingTableModel = (ParameterMappingTableModel)this.parameterMappingTable.getModel();
        parameterMappingTableModel.setMappings(parameterMappings);
        if (!super.performEdit()) {
            return null;
        }
        TableCellEditor cellEditor = this.parameterMappingTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        return new EditResult(parameterMappingTableModel.getMappings());
    }

    public static class EditResult {
        private ParameterMapping[] parameterMappings;

        public EditResult(ParameterMapping[] parameterMappings) {
            if (parameterMappings == null) {
                throw new NullPointerException();
            }
            this.parameterMappings = (ParameterMapping[])parameterMappings.clone();
        }

        public ParameterMapping[] getParameterMappings() {
            return (ParameterMapping[])this.parameterMappings.clone();
        }
    }

    private class AddParameterAction
    extends AbstractAction {
        private AddParameterAction() {
            URL resource = CdaDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/cda/resources/Add.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("ParameterEditorDialog.AddParameter.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("ParameterEditorDialog.AddParameter.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TableCellEditor tableCellEditor = ParameterEditorDialog.this.parameterMappingTable.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            ParameterMappingTableModel tableModel = (ParameterMappingTableModel)ParameterEditorDialog.this.parameterMappingTable.getModel();
            tableModel.addRow();
        }
    }

    private class RemoveParameterAction
    extends AbstractAction
    implements ListSelectionListener {
        private RemoveParameterAction() {
            URL resource = CdaDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/cda/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("ParameterEditorDialog.RemoveParameter.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("ParameterEditorDialog.RemoveParameter.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            TableCellEditor tableCellEditor = ParameterEditorDialog.this.parameterMappingTable.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            if ((i = ParameterEditorDialog.this.parameterMappingTable.getSelectedRow()) == -1) {
                return;
            }
            ParameterMappingTableModel tableModel = (ParameterMappingTableModel)ParameterEditorDialog.this.parameterMappingTable.getModel();
            tableModel.removeRow(i);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(ParameterEditorDialog.this.parameterMappingTable.getSelectedRow() != -1);
        }
    }
}

