/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hive;

import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.jdbc.JdbcUrl;
import org.pentaho.big.data.api.jdbc.JdbcUrlParser;

public class HiveDriver
implements Driver {
    protected static final String SIMBA_SPECIFIC_URL_PARAMETER = "AuthMech=";
    public static final String SQL_STATE_NOT_SUPPORTED = "0A000";
    protected final Driver delegate;
    private final boolean defaultConfiguration;
    private final JdbcUrlParser jdbcUrlParser;
    private final String hadoopConfigurationId;

    public HiveDriver(Driver delegate, String hadoopConfigurationId, boolean defaultConfiguration, JdbcUrlParser jdbcUrlParser) {
        this.delegate = delegate;
        this.hadoopConfigurationId = hadoopConfigurationId;
        this.defaultConfiguration = defaultConfiguration;
        this.jdbcUrlParser = jdbcUrlParser;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        NamedCluster namedCluster;
        JdbcUrl jdbcUrl;
        Driver driver = this.checkBeforeCallActiveDriver(url);
        try {
            jdbcUrl = this.jdbcUrlParser.parse(url);
        }
        catch (URISyntaxException e1) {
            throw new SQLException("Unable to parse jdbc url: " + url, e1);
        }
        try {
            namedCluster = jdbcUrl.getNamedCluster();
        }
        catch (Exception e) {
            return null;
        }
        if (!this.acceptsURL(url, driver, namedCluster)) {
            return null;
        }
        try {
            return this.doConnect(driver, jdbcUrl, info);
        }
        catch (Exception ex) {
            Throwable cause = ex;
            do {
                if (!(cause instanceof SQLException) || !SQL_STATE_NOT_SUPPORTED.equals(((SQLException)cause).getSQLState())) continue;
                return null;
            } while ((cause = cause.getCause()) != null);
            throw ex;
        }
    }

    public Connection doConnect(Driver driver, JdbcUrl url, Properties info) throws SQLException {
        return driver.connect(url.toString(), info);
    }

    @Override
    public final boolean acceptsURL(String url) throws SQLException {
        try {
            return this.acceptsURL(url, this.checkBeforeCallActiveDriver(url), null);
        }
        catch (Exception e) {
            return false;
        }
    }

    private final boolean acceptsURL(String url, Driver driver, NamedCluster namedCluster) throws SQLException {
        if (!this.defaultConfiguration) {
            return false;
        }
        if (driver == null) {
            return false;
        }
        try {
            return driver.acceptsURL(url);
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected Driver checkBeforeCallActiveDriver(String url) throws SQLException {
        if (url.contains(SIMBA_SPECIFIC_URL_PARAMETER)) {
            return null;
        }
        return this.delegate;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Driver delegate = this.delegate;
        if (delegate == null) {
            return null;
        }
        return delegate.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        Driver delegate = this.delegate;
        if (delegate == null) {
            return -1;
        }
        return delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        Driver delegate = this.delegate;
        if (delegate == null) {
            return -1;
        }
        return delegate.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        Driver delegate = this.delegate;
        if (delegate == null) {
            return false;
        }
        try {
            return delegate.jdbcCompliant();
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        Driver delegate = this.delegate;
        if (delegate == null) {
            return null;
        }
        try {
            return delegate.getParentLogger();
        }
        catch (Throwable e) {
            if (e instanceof SQLFeatureNotSupportedException) {
                throw e;
            }
            throw new SQLFeatureNotSupportedException(e);
        }
    }
}

