/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Count
extends FsCommand {
    private static final String OPTION_QUOTA = "q";
    private static final String OPTION_HUMAN = "h";
    private static final String OPTION_HEADER = "v";
    private static final String OPTION_TYPE = "t";
    public static final String NAME = "count";
    public static final String USAGE = "[-q] [-h] [-v] [-t [<storage type>]] <path> ...";
    public static final String DESCRIPTION = "Count the number of directories, files and bytes under the paths\nthat match the specified file pattern.  The output columns are:\n" + StringUtils.join((Object[])ContentSummary.getHeaderFields(), (char)' ') + " PATHNAME\n" + "or, with the -" + "q" + " option:\n" + StringUtils.join((Object[])ContentSummary.getQuotaHeaderFields(), (char)' ') + "\n" + "      " + StringUtils.join((Object[])ContentSummary.getHeaderFields(), (char)' ') + " PATHNAME\n" + "The -" + "h" + " option shows file sizes in human readable format.\n" + "The -" + "v" + " option displays a header line.\n" + "The -" + "t" + " option displays quota by storage types.\n" + "It must be used with -" + "q" + " option.\n" + "If a comma-separated list of storage types is given after the -" + "t" + " option, \n" + "it displays the quota and usage for the specified types. \n" + "Otherwise, it displays the quota and usage for all the storage \n" + "types that support quota";
    private boolean showQuotas;
    private boolean humanReadable;
    private boolean showQuotabyType;
    private List<StorageType> storageTypes = null;

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Count.class, "-count");
    }

    public Count() {
    }

    @Deprecated
    public Count(String[] cmd, int pos, Configuration conf) {
        super(conf);
        this.args = Arrays.copyOfRange(cmd, pos, cmd.length);
    }

    @Override
    protected void processOptions(LinkedList<String> args) {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, OPTION_QUOTA, OPTION_HUMAN, OPTION_HEADER);
        cf.addOptionWithValue(OPTION_TYPE);
        cf.parse(args);
        if (args.isEmpty()) {
            args.add(".");
        }
        this.showQuotas = cf.getOpt(OPTION_QUOTA);
        this.humanReadable = cf.getOpt(OPTION_HUMAN);
        if (this.showQuotas) {
            String types = cf.getOptValue(OPTION_TYPE);
            if (null != types) {
                this.showQuotabyType = true;
                this.storageTypes = this.getAndCheckStorageTypes(types);
            } else {
                this.showQuotabyType = false;
            }
        }
        if (cf.getOpt(OPTION_HEADER)) {
            if (this.showQuotabyType) {
                this.out.println(ContentSummary.getStorageTypeHeader(this.storageTypes) + "PATHNAME");
            } else {
                this.out.println(ContentSummary.getHeader(this.showQuotas) + "PATHNAME");
            }
        }
    }

    private List<StorageType> getAndCheckStorageTypes(String types) {
        if ("".equals(types) || "all".equalsIgnoreCase(types)) {
            return StorageType.getTypesSupportingQuota();
        }
        String[] typeArray = StringUtils.split((String)types, (char)',');
        ArrayList<StorageType> stTypes = new ArrayList<StorageType>();
        for (String t : typeArray) {
            stTypes.add(StorageType.parseStorageType(t));
        }
        return stTypes;
    }

    @Override
    protected void processPath(PathData src) throws IOException {
        ContentSummary summary = src.fs.getContentSummary(src.path);
        this.out.println(summary.toString(this.showQuotas, this.isHumanReadable(), this.showQuotabyType, this.storageTypes) + src);
    }

    @InterfaceAudience.Private
    boolean isShowQuotas() {
        return this.showQuotas;
    }

    @InterfaceAudience.Private
    boolean isHumanReadable() {
        return this.humanReadable;
    }

    @InterfaceAudience.Private
    boolean isShowQuotabyType() {
        return this.showQuotabyType;
    }

    @InterfaceAudience.Private
    List<StorageType> getStorageTypes() {
        return this.storageTypes;
    }
}

