/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.retry.AtMostOnce;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.io.retry.MultiException;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcInvocationHandler;

@InterfaceAudience.Private
public class RetryInvocationHandler<T>
implements RpcInvocationHandler {
    public static final Log LOG = LogFactory.getLog(RetryInvocationHandler.class);
    private final ProxyDescriptor<T> proxyDescriptor;
    private volatile boolean hasMadeASuccessfulCall = false;
    private final RetryPolicy defaultPolicy;
    private final Map<String, RetryPolicy> methodNameToPolicyMap;

    protected RetryInvocationHandler(FailoverProxyProvider<T> proxyProvider, RetryPolicy retryPolicy) {
        this(proxyProvider, retryPolicy, Collections.emptyMap());
    }

    protected RetryInvocationHandler(FailoverProxyProvider<T> proxyProvider, RetryPolicy defaultPolicy, Map<String, RetryPolicy> methodNameToPolicyMap) {
        this.proxyDescriptor = new ProxyDescriptor<T>(proxyProvider);
        this.defaultPolicy = defaultPolicy;
        this.methodNameToPolicyMap = methodNameToPolicyMap;
    }

    private RetryPolicy getRetryPolicy(Method method) {
        RetryPolicy policy = this.methodNameToPolicyMap.get(method.getName());
        return policy != null ? policy : this.defaultPolicy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean isRpc = RetryInvocationHandler.isRpcInvocation(this.proxyDescriptor.getProxy());
        int callId = isRpc ? Client.nextCallId() : -2;
        return this.invoke(method, args, isRpc, callId, new Counters());
    }

    private Object invoke(Method method, Object[] args, boolean isRpc, int callId, Counters counters) throws Throwable {
        RetryPolicy policy = this.getRetryPolicy(method);
        while (true) {
            long failoverCount = this.proxyDescriptor.getFailoverCount();
            if (isRpc) {
                Client.setCallIdAndRetryCount(callId, counters.retries);
            }
            try {
                Object ret = this.invokeMethod(method, args);
                this.hasMadeASuccessfulCall = true;
                return ret;
            }
            catch (Exception ex) {
                if (Thread.currentThread().isInterrupted()) {
                    throw ex;
                }
                this.handleException(method, policy, failoverCount, counters, ex);
                continue;
            }
            break;
        }
    }

    private void handleException(Method method, RetryPolicy policy, long expectedFailoverCount, Counters counters, Exception ex) throws Exception {
        RetryInfo retryInfo = RetryInfo.newRetryInfo(policy, ex, counters, this.proxyDescriptor.idempotentOrAtMostOnce(method));
        counters.retries++;
        if (retryInfo.fail != null) {
            if (((RetryInfo)retryInfo).fail.reason != null) {
                LOG.warn((Object)("Exception while invoking " + this.proxyDescriptor.getProxyInfo().getString(method.getName()) + ". Not retrying because " + ((RetryInfo)retryInfo).fail.reason), (Throwable)ex);
            }
            throw ex;
        }
        boolean isFailover = retryInfo.failover != null;
        this.log(method, isFailover, counters.failovers, retryInfo.delay, ex);
        if (retryInfo.delay > 0L) {
            try {
                Thread.sleep(retryInfo.delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn((Object)"Interrupted while waiting to retry", (Throwable)e);
                InterruptedIOException intIOE = new InterruptedIOException("Retry interrupted");
                intIOE.initCause(e);
                throw intIOE;
            }
        }
        if (isFailover) {
            this.proxyDescriptor.failover(expectedFailoverCount, method);
            counters.failovers++;
        }
    }

    private void log(Method method, boolean isFailover, int failovers, long delay, Exception ex) {
        boolean info;
        boolean bl = info = this.hasMadeASuccessfulCall || failovers != 0;
        if (!info && !LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder b = new StringBuilder().append("Exception while invoking ").append(this.proxyDescriptor.getProxyInfo().getString(method.getName()));
        if (failovers > 0) {
            b.append(" after ").append(failovers).append(" failover attempts");
        }
        b.append(isFailover ? ". Trying to failover " : ". Retrying ");
        b.append(delay > 0L ? "after sleeping for " + delay + "ms." : "immediately.");
        if (info) {
            LOG.info((Object)b.toString(), (Throwable)ex);
        } else {
            LOG.debug((Object)b.toString(), (Throwable)ex);
        }
    }

    protected Object invokeMethod(Method method, Object[] args) throws Throwable {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.proxyDescriptor.getProxy(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @VisibleForTesting
    static boolean isRpcInvocation(Object proxy) {
        if (proxy instanceof ProtocolTranslator) {
            proxy = ((ProtocolTranslator)proxy).getUnderlyingProxyObject();
        }
        if (!Proxy.isProxyClass(proxy.getClass())) {
            return false;
        }
        InvocationHandler ih = Proxy.getInvocationHandler(proxy);
        return ih instanceof RpcInvocationHandler;
    }

    @Override
    public void close() throws IOException {
        this.proxyDescriptor.close();
    }

    @Override
    public Client.ConnectionId getConnectionId() {
        return RPC.getConnectionIdForProxy(this.proxyDescriptor.getProxy());
    }

    private static class RetryInfo {
        private final long delay;
        private final RetryPolicy.RetryAction failover;
        private final RetryPolicy.RetryAction fail;

        RetryInfo(long delay, RetryPolicy.RetryAction failover, RetryPolicy.RetryAction fail) {
            this.delay = delay;
            this.failover = failover;
            this.fail = fail;
        }

        static RetryInfo newRetryInfo(RetryPolicy policy, Exception e, Counters counters, boolean idempotentOrAtMostOnce) throws Exception {
            long maxRetryDelay = 0L;
            RetryPolicy.RetryAction failover = null;
            RetryPolicy.RetryAction retry = null;
            RetryPolicy.RetryAction fail = null;
            List<Exception> exceptions = e instanceof MultiException ? ((MultiException)e).getExceptions().values() : Collections.singletonList(e);
            for (Exception exception : exceptions) {
                RetryPolicy.RetryAction a = policy.shouldRetry(exception, counters.retries, counters.failovers, idempotentOrAtMostOnce);
                if (a.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                    fail = a;
                    continue;
                }
                if (a.action == RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY) {
                    failover = a;
                } else {
                    retry = a;
                }
                if (a.delayMillis <= maxRetryDelay) continue;
                maxRetryDelay = a.delayMillis;
            }
            return new RetryInfo(maxRetryDelay, failover, failover == null && retry == null ? fail : null);
        }
    }

    private static class ProxyDescriptor<T> {
        private final FailoverProxyProvider<T> fpp;
        private long failoverCount = 0L;
        private FailoverProxyProvider.ProxyInfo<T> proxyInfo;

        ProxyDescriptor(FailoverProxyProvider<T> fpp) {
            this.fpp = fpp;
            this.proxyInfo = fpp.getProxy();
        }

        synchronized FailoverProxyProvider.ProxyInfo<T> getProxyInfo() {
            return this.proxyInfo;
        }

        synchronized T getProxy() {
            return this.proxyInfo.proxy;
        }

        synchronized long getFailoverCount() {
            return this.failoverCount;
        }

        synchronized void failover(long expectedFailoverCount, Method method) {
            if (this.failoverCount == expectedFailoverCount) {
                this.fpp.performFailover(this.proxyInfo.proxy);
                ++this.failoverCount;
            } else {
                LOG.warn((Object)("A failover has occurred since the start of " + this.proxyInfo.getString(method.getName())));
            }
            this.proxyInfo = this.fpp.getProxy();
        }

        boolean idempotentOrAtMostOnce(Method method) throws NoSuchMethodException {
            Method m = this.fpp.getInterface().getMethod(method.getName(), method.getParameterTypes());
            return m.isAnnotationPresent(Idempotent.class) || m.isAnnotationPresent(AtMostOnce.class);
        }

        void close() throws IOException {
            this.fpp.close();
        }
    }

    private static class Counters {
        private int retries;
        private int failovers;

        private Counters() {
        }
    }
}

