/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodboutput;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputMeta;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;
import org.pentaho.mongo.wrapper.cursor.MongoCursorWrapper;

public class MongoDbOutputData
extends BaseStepData
implements StepDataInterface {
    private static Class<?> PKG = MongoDbOutputMeta.class;
    public static final int MONGO_DEFAULT_PORT = 27017;
    public static final String LOCAL_DB = "local";
    public static final String REPL_SET_COLLECTION = "system.replset";
    public static final String REPL_SET_SETTINGS = "settings";
    public static final String REPL_SET_LAST_ERROR_MODES = "getLastErrorModes";
    protected RowMetaInterface m_outputRowMeta;
    protected MongoClientWrapper clientWrapper;
    protected MongoCollectionWrapper m_collection;
    protected List<MongoDbOutputMeta.MongoField> m_userFields;
    protected Map<String, List<MongoDbOutputMeta.MongoField>> m_setComplexArrays = new HashMap<String, List<MongoDbOutputMeta.MongoField>>();
    protected Map<String, List<MongoDbOutputMeta.MongoField>> m_pushComplexStructures = new HashMap<String, List<MongoDbOutputMeta.MongoField>>();
    protected Map<String, Object[]> m_primitiveLeafModifiers = new LinkedHashMap<String, Object[]>();
    protected boolean m_hasTopLevelJSONDocInsert = false;

    public static boolean scanForInsertTopLevelJSONDoc(List<MongoDbOutputMeta.MongoField> fieldDefs) throws KettleException {
        int countNonMatchFields = 0;
        boolean hasTopLevelJSONDocInsert = false;
        for (MongoDbOutputMeta.MongoField f : fieldDefs) {
            if (f.m_JSON && !f.m_updateMatchField && Const.isEmpty((String)f.m_mongoDocPath) && !f.m_useIncomingFieldNameAsMongoFieldName) {
                hasTopLevelJSONDocInsert = true;
            }
            if (f.m_updateMatchField) continue;
            ++countNonMatchFields;
        }
        if (hasTopLevelJSONDocInsert && countNonMatchFields > 1) {
            throw new KettleException("Path specifications contains a top-level document in JSON format to be inserted as is, but there are other insert paths defined. When a top-level JSON document is to be inserted it must be the only non-match field defined in the path specifications");
        }
        return hasTopLevelJSONDocInsert;
    }

    public void setMongoFields(List<MongoDbOutputMeta.MongoField> fields) {
        this.m_userFields = new ArrayList<MongoDbOutputMeta.MongoField>();
        for (MongoDbOutputMeta.MongoField f : fields) {
            this.m_userFields.add(f.copy());
        }
    }

    public List<MongoDbOutputMeta.MongoField> getMongoFields() {
        return this.m_userFields;
    }

    public void init(VariableSpace vars) throws KettleException {
        if (this.m_userFields != null) {
            for (MongoDbOutputMeta.MongoField f : this.m_userFields) {
                f.init(vars);
            }
        }
    }

    public MongoClientWrapper getConnection() {
        return this.clientWrapper;
    }

    public void setConnection(MongoClientWrapper clientWrapper) {
        this.clientWrapper = clientWrapper;
    }

    public void createCollection(String db, String collectionName) throws Exception {
        if (this.clientWrapper == null) {
            throw new Exception(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoDatabaseSet", (String[])new String[0]));
        }
        this.clientWrapper.createCollection(db, collectionName);
    }

    public void setCollection(MongoCollectionWrapper col) {
        this.m_collection = col;
    }

    public MongoCollectionWrapper getCollection() {
        return this.m_collection;
    }

    public void setOutputRowMeta(RowMetaInterface outM) {
        this.m_outputRowMeta = outM;
    }

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public void applyIndexes(List<MongoDbOutputMeta.MongoIndex> indexes, LogChannelInterface log, boolean truncate) throws MongoException, KettleException, MongoDbException {
        for (MongoDbOutputMeta.MongoIndex index : indexes) {
            String[] indexParts = index.m_pathToFields.split(",");
            BasicDBObject mongoIndex = new BasicDBObject();
            for (String indexKey : indexParts) {
                String name;
                String[] nameAndDirection = indexKey.split(":");
                int direction = 1;
                if (nameAndDirection.length == 2) {
                    direction = Integer.parseInt(nameAndDirection[1].trim());
                }
                if ((name = nameAndDirection[0]).indexOf(91) > 0) {
                    name = name.substring(name.indexOf(91) + 1, name.length());
                }
                mongoIndex.put((Object)name, (Object)direction);
            }
            if (index.m_drop) {
                if (truncate) {
                    log.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.TruncateBeforeInsert", (Object[])new Object[]{index}));
                } else {
                    this.m_collection.dropIndex(mongoIndex);
                }
                log.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.DropIndex", (Object[])new Object[]{index}));
                continue;
            }
            BasicDBObject options = new BasicDBObject();
            options.put((Object)"background", (Object)true);
            options.put((Object)"unique", (Object)index.m_unique);
            options.put((Object)"sparse", (Object)index.m_sparse);
            this.m_collection.createIndex(mongoIndex, options);
            log.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.CreateIndex", (Object[])new Object[]{index}));
        }
    }

    protected DBObject getModifierUpdateObject(List<MongoDbOutputMeta.MongoField> fieldDefs, RowMetaInterface inputMeta, Object[] row, VariableSpace vars, MongoTopLevel topLevelStructure) throws KettleException, MongoDbException {
        List<MongoDbOutputMeta.MongoField> fds;
        boolean haveUpdateFields = false;
        boolean hasNonNullUpdateValues = false;
        BasicDBObject updateObject = new BasicDBObject();
        this.m_setComplexArrays.clear();
        this.m_primitiveLeafModifiers.clear();
        this.m_pushComplexStructures.clear();
        boolean checkForMatch = false;
        for (MongoDbOutputMeta.MongoField field : fieldDefs) {
            if (field.m_updateMatchField || !field.m_modifierOperationApplyPolicy.equals("Insert") && !field.m_modifierOperationApplyPolicy.equals("Update")) continue;
            checkForMatch = true;
            break;
        }
        boolean isUpdate = false;
        if (checkForMatch) {
            DBObject query = MongoDbOutputData.getQueryObject(fieldDefs, inputMeta, row, vars, topLevelStructure);
            MongoCursorWrapper mongoCursorWrapper = this.getCollection().find(query).limit(1);
            if (mongoCursorWrapper.hasNext()) {
                isUpdate = true;
            }
        }
        for (MongoDbOutputMeta.MongoField mongoField : fieldDefs) {
            MongoDbOutputMeta.MongoField a;
            String arrayPath;
            String modifierUpdateOpp;
            if (mongoField.m_updateMatchField || Const.isEmpty((String)(modifierUpdateOpp = vars.environmentSubstitute(mongoField.m_modifierUpdateOperation))) || modifierUpdateOpp.equals("N/A") || checkForMatch && (isUpdate && mongoField.m_modifierOperationApplyPolicy.equals("Insert") || !isUpdate && mongoField.m_modifierOperationApplyPolicy.equals("Update"))) continue;
            haveUpdateFields = true;
            String incomingFieldName = vars.environmentSubstitute(mongoField.m_incomingFieldName);
            int index = inputMeta.indexOfValue(incomingFieldName);
            ValueMetaInterface vm = inputMeta.getValueMeta(index);
            if (vm.isNull(row[index]) && !mongoField.insertNull) continue;
            hasNonNullUpdateValues = true;
            String mongoPath = mongoField.m_mongoDocPath != null ? mongoField.m_mongoDocPath : "";
            String path = vars.environmentSubstitute(mongoPath);
            if (path.endsWith("]") && modifierUpdateOpp.equals("$push") && !mongoField.m_useIncomingFieldNameAsMongoFieldName) {
                path = path.substring(0, path.indexOf(91));
            }
            boolean hasPath = !Const.isEmpty((String)path);
            path = path + (mongoField.m_useIncomingFieldNameAsMongoFieldName ? (hasPath ? "." + incomingFieldName : incomingFieldName) : "");
            if (modifierUpdateOpp.equals("$set") && path.indexOf(91) > 0) {
                arrayPath = path.substring(0, path.indexOf(91));
                String arraySpec = path.substring(path.indexOf(91), path.length());
                a = new MongoDbOutputMeta.MongoField();
                a.m_incomingFieldName = mongoField.m_incomingFieldName;
                a.m_mongoDocPath = arraySpec;
                a.m_useIncomingFieldNameAsMongoFieldName = false;
                a.m_JSON = mongoField.m_JSON;
                a.init(vars);
                List<MongoDbOutputMeta.MongoField> fds2 = this.m_setComplexArrays.get(arrayPath);
                if (fds2 == null) {
                    fds2 = new ArrayList<MongoDbOutputMeta.MongoField>();
                    this.m_setComplexArrays.put(arrayPath, fds2);
                }
                fds2.add(a);
                continue;
            }
            if (modifierUpdateOpp.equals("$push") && path.indexOf(91) > 0) {
                arrayPath = path.substring(0, path.indexOf(91));
                String structureToPush = path.substring(path.indexOf(93) + 1, path.length());
                if (structureToPush.charAt(0) == '.') {
                    structureToPush = structureToPush.substring(1, structureToPush.length());
                }
                a = new MongoDbOutputMeta.MongoField();
                a.m_incomingFieldName = mongoField.m_incomingFieldName;
                a.m_mongoDocPath = structureToPush;
                a.m_useIncomingFieldNameAsMongoFieldName = false;
                a.m_JSON = mongoField.m_JSON;
                a.init(vars);
                List<MongoDbOutputMeta.MongoField> fds2 = this.m_pushComplexStructures.get(arrayPath);
                if (fds2 == null) {
                    fds2 = new ArrayList<MongoDbOutputMeta.MongoField>();
                    this.m_pushComplexStructures.put(arrayPath, fds2);
                }
                fds2.add(a);
                continue;
            }
            Object[] params = new Object[]{modifierUpdateOpp, index, mongoField.m_JSON, mongoField.insertNull};
            this.m_primitiveLeafModifiers.put(path, params);
        }
        for (String string : this.m_setComplexArrays.keySet()) {
            fds = this.m_setComplexArrays.get(string);
            DBObject valueToSet = MongoDbOutputData.kettleRowToMongo(fds, inputMeta, row, vars, MongoTopLevel.ARRAY, false);
            Object fieldsToUpdateWithValues = updateObject.get("$set") != null ? (DBObject)updateObject.get("$set") : new BasicDBObject();
            fieldsToUpdateWithValues.put(string, (Object)valueToSet);
            updateObject.put((Object)"$set", fieldsToUpdateWithValues);
        }
        for (String string : this.m_pushComplexStructures.keySet()) {
            fds = this.m_pushComplexStructures.get(string);
            MongoTopLevel topLevel = MongoTopLevel.RECORD;
            if (fds.get((int)0).m_mongoDocPath.charAt(0) == '[') {
                topLevel = MongoTopLevel.RECORD;
            }
            DBObject valueToSet = MongoDbOutputData.kettleRowToMongo(fds, inputMeta, row, vars, topLevel, false);
            Object fieldsToUpdateWithValues = null;
            fieldsToUpdateWithValues = updateObject.get("$push") != null ? (DBObject)updateObject.get("$push") : new BasicDBObject();
            fieldsToUpdateWithValues.put(string, (Object)valueToSet);
            updateObject.put((Object)"$push", fieldsToUpdateWithValues);
        }
        for (Map.Entry entry : this.m_primitiveLeafModifiers.entrySet()) {
            String path = (String)entry.getKey();
            Object[] params = (Object[])entry.getValue();
            String modifierUpdateOpp = params[0].toString();
            int index = (Integer)params[1];
            boolean isJSON = (Boolean)params[2];
            boolean allowNull = (Boolean)params[3];
            ValueMetaInterface vm = inputMeta.getValueMeta(index);
            Object fieldsToUpdateWithValues = null;
            fieldsToUpdateWithValues = updateObject.get(modifierUpdateOpp) != null ? (DBObject)updateObject.get(modifierUpdateOpp) : new BasicDBObject();
            MongoDbOutputData.setMongoValueFromKettleValue((DBObject)fieldsToUpdateWithValues, path, vm, row[index], isJSON, allowNull);
            updateObject.put((Object)modifierUpdateOpp, fieldsToUpdateWithValues);
        }
        if (!haveUpdateFields) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoFieldsToUpdateSpecifiedForModifierOpp", (String[])new String[0]));
        }
        if (!hasNonNullUpdateValues) {
            return null;
        }
        return updateObject;
    }

    protected static DBObject getQueryObject(List<MongoDbOutputMeta.MongoField> fieldDefs, RowMetaInterface inputMeta, Object[] row, VariableSpace vars, MongoTopLevel topLevelStructure) throws KettleException {
        BasicDBObject query = new BasicDBObject();
        boolean haveMatchFields = false;
        boolean hasNonNullMatchValues = false;
        for (MongoDbOutputMeta.MongoField field : fieldDefs) {
            if (!field.m_updateMatchField) continue;
            haveMatchFields = true;
            String incomingFieldName = vars.environmentSubstitute(field.m_incomingFieldName);
            int index = inputMeta.indexOfValue(incomingFieldName);
            ValueMetaInterface vm = inputMeta.getValueMeta(index);
            if (vm.isNull(row[index]) && !field.insertNull) continue;
            hasNonNullMatchValues = true;
            if (field.m_JSON && Const.isEmpty((String)field.m_mongoDocPath) && !field.m_useIncomingFieldNameAsMongoFieldName) {
                if (vm.isString()) {
                    String val = vm.getString(row[index]);
                    query = (BasicDBObject)JSON.parse((String)val);
                    break;
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.MatchFieldJSONButIncomingValueNotString", (String[])new String[0]));
            }
            String mongoPath = field.m_mongoDocPath != null ? field.m_mongoDocPath : "";
            String path = vars.environmentSubstitute(mongoPath);
            boolean hasPath = !Const.isEmpty((String)path);
            path = path + (field.m_useIncomingFieldNameAsMongoFieldName ? (hasPath ? "." + incomingFieldName : incomingFieldName) : "");
            if (path.indexOf(91) > 0) {
                path = path.replace("[", ".").replace("]", "");
            }
            MongoDbOutputData.setMongoValueFromKettleValue((DBObject)query, path, vm, row[index], field.m_JSON, field.insertNull);
        }
        if (!haveMatchFields) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoFieldsToUpdateSpecifiedForMatch", (String[])new String[0]));
        }
        if (!hasNonNullMatchValues) {
            return null;
        }
        return query;
    }

    protected static DBObject kettleRowToMongo(List<MongoDbOutputMeta.MongoField> fieldDefs, RowMetaInterface inputMeta, Object[] row, VariableSpace vars, MongoTopLevel topLevelStructure, boolean hasTopLevelJSONDocInsert) throws KettleException {
        if (hasTopLevelJSONDocInsert) {
            for (MongoDbOutputMeta.MongoField f : fieldDefs) {
                if (!f.m_JSON || !Const.isEmpty((String)f.m_mongoDocPath) || f.m_useIncomingFieldNameAsMongoFieldName) continue;
                String incomingFieldName = vars.environmentSubstitute(f.m_incomingFieldName);
                int index = inputMeta.indexOfValue(incomingFieldName);
                ValueMetaInterface vm = inputMeta.getValueMeta(index);
                if (!vm.isNull(row[index])) {
                    String jsonDoc = vm.getString(row[index]);
                    DBObject docToInsert = (DBObject)JSON.parse((String)jsonDoc);
                    return docToInsert;
                }
                return null;
            }
        }
        BasicDBObject root = null;
        if (topLevelStructure == MongoTopLevel.RECORD) {
            root = new BasicDBObject();
        } else if (topLevelStructure == MongoTopLevel.ARRAY) {
            root = new BasicDBList();
        }
        if (vars == null) {
            vars = new Variables();
        }
        boolean haveNonNullFields = false;
        for (MongoDbOutputMeta.MongoField field : fieldDefs) {
            BasicDBObject current = root;
            field.reset();
            List<String> pathParts = field.m_tempPathList;
            String incomingFieldName = vars.environmentSubstitute(field.m_incomingFieldName);
            int index = inputMeta.indexOfValue(incomingFieldName);
            ValueMetaInterface vm = inputMeta.getValueMeta(index);
            Object lookup = MongoDbOutputData.getPathElementName(pathParts, (DBObject)current, field.m_useIncomingFieldNameAsMongoFieldName);
            do {
                if (lookup != null && lookup instanceof Integer) {
                    boolean res;
                    BasicDBList temp = (BasicDBList)current;
                    if (temp.get(lookup.toString()) == null) {
                        if (pathParts.size() == 0 && !field.m_useIncomingFieldNameAsMongoFieldName) {
                            res = MongoDbOutputData.setMongoValueFromKettleValue((DBObject)temp, lookup, vm, row[index], field.m_JSON, field.insertNull);
                            haveNonNullFields = haveNonNullFields || res;
                            continue;
                        }
                        BasicDBObject newRec = new BasicDBObject();
                        temp.put(lookup.toString(), (Object)newRec);
                        current = newRec;
                        if (pathParts.size() != 0) continue;
                        if (field.m_useIncomingFieldNameAsMongoFieldName) {
                            boolean res2 = MongoDbOutputData.setMongoValueFromKettleValue((DBObject)current, incomingFieldName, vm, row[index], field.m_JSON, field.insertNull);
                            haveNonNullFields = haveNonNullFields || res2;
                            continue;
                        }
                        throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoFieldNameSpecifiedForPath", (String[])new String[0]));
                    }
                    current = (DBObject)temp.get(lookup.toString());
                    if (pathParts != null && pathParts.size() != 0 || !(current instanceof BasicDBObject)) continue;
                    if (field.m_useIncomingFieldNameAsMongoFieldName) {
                        res = MongoDbOutputData.setMongoValueFromKettleValue((DBObject)current, incomingFieldName, vm, row[index], field.m_JSON, field.insertNull);
                        haveNonNullFields = haveNonNullFields || res;
                        continue;
                    }
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoFieldNameSpecifiedForPath", (String[])new String[0]));
                }
                if (lookup == null && pathParts.size() == 0) {
                    if (field.m_useIncomingFieldNameAsMongoFieldName) {
                        boolean res = MongoDbOutputData.setMongoValueFromKettleValue((DBObject)current, incomingFieldName, vm, row[index], field.m_JSON, field.insertNull);
                        haveNonNullFields = haveNonNullFields || res;
                        continue;
                    }
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoFieldNameSpecifiedForPath", (String[])new String[0]));
                }
                if (pathParts.size() == 0) {
                    if (!field.m_useIncomingFieldNameAsMongoFieldName) {
                        boolean res = MongoDbOutputData.setMongoValueFromKettleValue((DBObject)current, lookup.toString(), vm, row[index], field.m_JSON, field.insertNull);
                        haveNonNullFields = haveNonNullFields || res;
                        continue;
                    }
                    current = (DBObject)current.get(lookup.toString());
                    boolean res = MongoDbOutputData.setMongoValueFromKettleValue((DBObject)current, incomingFieldName, vm, row[index], field.m_JSON, field.insertNull);
                    haveNonNullFields = haveNonNullFields || res;
                    continue;
                }
                current = (DBObject)current.get(lookup.toString());
            } while ((lookup = MongoDbOutputData.getPathElementName(pathParts, (DBObject)current, field.m_useIncomingFieldNameAsMongoFieldName)) != null);
        }
        if (!haveNonNullFields) {
            return null;
        }
        return root;
    }

    private static boolean setMongoValueFromKettleValue(DBObject mongoObject, Object lookup, ValueMetaInterface kettleType, Object kettleValue, boolean kettleValueIsJSON, boolean allowNull) throws KettleValueException {
        if (kettleType.isNull(kettleValue)) {
            if (allowNull) {
                mongoObject.put(lookup.toString(), null);
                return true;
            }
            return false;
        }
        if (kettleType.isString()) {
            String val = kettleType.getString(kettleValue);
            if (kettleValueIsJSON) {
                Object mongoO = JSON.parse((String)val);
                mongoObject.put(lookup.toString(), mongoO);
            } else {
                mongoObject.put(lookup.toString(), (Object)val);
            }
            return true;
        }
        if (kettleType.isBoolean()) {
            Boolean val = kettleType.getBoolean(kettleValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (kettleType.isInteger()) {
            Long val = kettleType.getInteger(kettleValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (kettleType.isDate()) {
            Date val = kettleType.getDate(kettleValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (kettleType.isNumber()) {
            Double val = kettleType.getNumber(kettleValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (kettleType.isBigNumber()) {
            String val = kettleType.getString(kettleValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (kettleType.isBinary()) {
            byte[] val = kettleType.getBinary(kettleValue);
            mongoObject.put(lookup.toString(), (Object)val);
            return true;
        }
        if (kettleType.isSerializableType()) {
            throw new KettleValueException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.CantStoreKettleSerializableVals", (String[])new String[0]));
        }
        return false;
    }

    private static Object getPathElementName(List<String> pathParts, DBObject current, boolean incomingAsFieldName) throws KettleException {
        if (pathParts == null || pathParts.size() == 0) {
            return null;
        }
        String part = pathParts.get(0);
        if (part.startsWith("[")) {
            String index = part.substring(1, part.indexOf(93)).trim();
            if ((part = part.substring(part.indexOf(93) + 1).trim()).length() > 0) {
                pathParts.set(0, part);
                if (current.get(index) == null) {
                    BasicDBList newArr = new BasicDBList();
                    current.put(index, (Object)newArr);
                }
            } else {
                pathParts.remove(0);
            }
            return new Integer(index);
        }
        if (part.endsWith("]")) {
            String fieldName = part.substring(0, part.indexOf(91));
            Object mongoField = current.get(fieldName);
            if (mongoField == null) {
                BasicDBList newField = new BasicDBList();
                current.put(fieldName, (Object)newField);
            } else if (!(mongoField instanceof BasicDBList)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.FieldExistsButIsntAnArray", (String[])new String[]{part}));
            }
            part = part.substring(part.indexOf(91));
            pathParts.set(0, part);
            return fieldName;
        }
        Object mongoField = current.get(part);
        if (mongoField == null) {
            if (incomingAsFieldName || pathParts.size() > 1) {
                BasicDBObject newField = new BasicDBObject();
                current.put(part, (Object)newField);
            }
        } else if (!(mongoField instanceof BasicDBObject) && pathParts.size() > 1) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.FieldExistsButIsntARecord", (String[])new String[]{part}));
        }
        pathParts.remove(0);
        return part;
    }

    protected static MongoTopLevel checkTopLevelConsistency(List<MongoDbOutputMeta.MongoField> fieldDefs, VariableSpace vars) throws KettleException {
        if (fieldDefs == null || fieldDefs.size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoMongoPathsDefined", (String[])new String[0]));
        }
        int numRecords = 0;
        int numArrays = 0;
        for (MongoDbOutputMeta.MongoField field : fieldDefs) {
            String mongoPath = vars.environmentSubstitute(field.m_mongoDocPath);
            if (Const.isEmpty((String)mongoPath)) {
                ++numRecords;
                continue;
            }
            if (mongoPath.startsWith("[")) {
                ++numArrays;
                continue;
            }
            ++numRecords;
        }
        if (numRecords < fieldDefs.size() && numArrays < fieldDefs.size()) {
            return MongoTopLevel.INCONSISTENT;
        }
        if (numRecords > 0) {
            return MongoTopLevel.RECORD;
        }
        return MongoTopLevel.ARRAY;
    }

    public static enum MongoTopLevel {
        RECORD,
        ARRAY,
        INCONSISTENT;

    }
}

