/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import com.infobright.io.ClientProxy;
import com.infobright.io.NamedPipe;
import com.infobright.io.NamedPipeFactory;
import com.infobright.logging.EtlLogger;
import java.io.IOException;
import java.io.OutputStream;

public class NamedPipeOutputStream
extends OutputStream {
    private NamedPipe namedPipe = null;
    private byte[] oneByte = new byte[1];
    private final EtlLogger logger;

    public NamedPipeOutputStream(String pipeName) throws IOException {
        this(pipeName, null, null);
    }

    public NamedPipeOutputStream(String pipeName, ClientProxy proxy) throws IOException {
        this(pipeName, proxy, null);
    }

    public NamedPipeOutputStream(String pipeName, ClientProxy proxy, EtlLogger logger) throws IOException {
        this.logger = logger;
        if (this.logger != null) {
            this.logger.debug(String.format("creating named pipe client \"%s\"", pipeName));
        }
        this.namedPipe = new NamedPipeFactory(proxy).createClient(pipeName);
        this.namedPipe.connect();
        if (logger != null) {
            logger.debug("NamedPipeFactory.createClient(name) returned " + this.namedPipe);
        }
    }

    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int bytesWritten = 0;
        bytesWritten = this.namedPipe.write(b, off, len);
        if (bytesWritten != len) {
            throw new IOException(String.format("Meant to write %d bytes but wrote %d bytes", len, bytesWritten));
        }
    }

    public void close() throws IOException {
        this.namedPipe.close();
        this.namedPipe = null;
    }

    protected void finalize() throws Throwable {
        if (this.namedPipe != null) {
            this.close();
        }
    }
}

