/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import com.infobright.io.ClientProxy;
import com.infobright.io.NamedPipeOutputStream;
import com.infobright.io.PipeCallStrategy;
import com.infobright.logging.EtlLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;

class WindowsPipeCallStrategy
implements PipeCallStrategy {
    private final ClientProxy proxy;
    private final EtlLogger logger;

    WindowsPipeCallStrategy(ClientProxy proxy, EtlLogger logger) {
        this.proxy = proxy;
        this.logger = logger;
    }

    public void setupForLoad(Statement statement, Object[] params) throws SQLException {
        if (params.length != 1) {
            throw new IllegalArgumentException("Expected timeout parameter");
        }
        int timeout = (Integer)params[0];
        String setupSql = "set @bh_pipemode='" + PipeMode.SERVER.getBhPipeMode() + "';";
        if (this.logger != null) {
            this.logger.debug(String.format("exec sql: %s", setupSql));
        }
        statement.execute(setupSql);
        setupSql = "set @bh_timeout=" + timeout + ";";
        if (this.logger != null) {
            this.logger.debug(String.format("exec sql: %s", setupSql));
        }
        statement.execute(setupSql);
    }

    public NamedPipeOutputStream beforeExecuteCreate(String pipeName) throws IOException {
        return null;
    }

    public NamedPipeOutputStream afterExecuteCreate(String pipeName) throws IOException {
        return new NamedPipeOutputStream(pipeName, this.proxy, this.logger);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PipeMode {
        CLIENT("client"),
        SERVER("server");

        private String bhPipeMode;

        private PipeMode(String bhPipeMode) {
            this.bhPipeMode = bhPipeMode;
        }

        public String getBhPipeMode() {
            return this.bhPipeMode;
        }
    }
}

