/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.cxf.common.classloader.ClassLoaderUtils;

public final class URIParserUtil {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"));
    private static final String EXCLUDED_CHARS = "<>\"{}|\\^`";
    private static final String HEX_DIGITS = "0123456789abcdef";

    private URIParserUtil() {
    }

    private static boolean isExcluded(char ch) {
        return ch <= ' ' || ch >= '\u007f' || EXCLUDED_CHARS.indexOf(ch) != -1;
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken());
            URL url = null;
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    public static String parsePackageName(String namespace, String defaultPackageName) {
        String packageName;
        String string = packageName = defaultPackageName != null && defaultPackageName.trim().length() > 0 ? defaultPackageName : null;
        if (packageName == null) {
            packageName = URIParserUtil.getPackageName(namespace);
        }
        return packageName;
    }

    public static String getPackageName(String nameSpaceURI) {
        List<String> r;
        String domain;
        String lastToken;
        List<String> tokens;
        int idx = nameSpaceURI.indexOf(58);
        String scheme = "";
        if (idx >= 0 && ("http".equalsIgnoreCase(scheme = nameSpaceURI.substring(0, idx)) || "urn".equalsIgnoreCase(scheme))) {
            nameSpaceURI = nameSpaceURI.substring(idx + 1);
        }
        if ((tokens = URIParserUtil.tokenize(nameSpaceURI, "/: ")).size() == 0) {
            return "cxf";
        }
        if (tokens.size() > 1 && (idx = (lastToken = tokens.get(tokens.size() - 1)).lastIndexOf(46)) > 0) {
            lastToken = lastToken.replace('.', '_');
            tokens.set(tokens.size() - 1, lastToken);
        }
        if ((idx = (domain = tokens.get(0)).indexOf(58)) >= 0) {
            domain = domain.substring(0, idx);
        }
        if ("www".equalsIgnoreCase((r = URIParserUtil.reverse(URIParserUtil.tokenize(domain, "urn".equals(scheme) ? ".-" : "."))).get(r.size() - 1))) {
            r.remove(r.size() - 1);
        }
        tokens.addAll(1, r);
        tokens.remove(0);
        for (int i = 0; i < tokens.size(); ++i) {
            String token = tokens.get(i);
            if (URIParserUtil.containsReservedKeywords(token = URIParserUtil.removeIllegalIdentifierChars(token))) {
                token = '_' + token;
            }
            tokens.set(i, token.toLowerCase());
        }
        return URIParserUtil.combine(tokens, '.');
    }

    public static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            for (int i = tokenizer.countTokens() - 1; i >= 0; --i) {
                tokens[i] = tokenizer.nextToken();
            }
        }
        StringBuilder namespace = new StringBuilder("http://");
        String dot = "";
        for (int i = 0; i < tokens.length; ++i) {
            if (i == 1) {
                dot = ".";
            }
            namespace.append(dot + tokens[i]);
        }
        namespace.append('/');
        return namespace.toString();
    }

    private static List<String> tokenize(String str, String sep) {
        StringTokenizer tokens = new StringTokenizer(str, sep);
        ArrayList<String> r = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            r.add(tokens.nextToken());
        }
        return r;
    }

    private static String removeIllegalIdentifierChars(String token) {
        StringBuilder newToken = new StringBuilder();
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c)) {
                newToken.append("_" + c);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                newToken.append('_');
                continue;
            }
            newToken.append(c);
        }
        return newToken.toString();
    }

    private static String combine(List<String> r, char sep) {
        StringBuilder buf = new StringBuilder(r.get(0));
        for (int i = 1; i < r.size(); ++i) {
            buf.append(sep);
            buf.append(r.get(i));
        }
        return buf.toString();
    }

    private static <T> List<T> reverse(List<T> a) {
        ArrayList<T> r = new ArrayList<T>();
        for (int i = a.size() - 1; i >= 0; --i) {
            r.add(a.get(i));
        }
        return r;
    }

    public static boolean containsReservedKeywords(String token) {
        return KEYWORDS.contains(token);
    }

    public static String escapeChars(String s) {
        StringBuilder b = new StringBuilder(s.length());
        for (int x = 0; x < s.length(); ++x) {
            char ch = s.charAt(x);
            if (URIParserUtil.isExcluded(ch)) {
                try {
                    byte[] bytes = Character.toString(ch).getBytes("UTF-8");
                    for (int y = 0; y < bytes.length; ++y) {
                        b.append("%");
                        b.append(HEX_DIGITS.charAt((bytes[y] & 0xFF) >> 4));
                        b.append(HEX_DIGITS.charAt(bytes[y] & 0xF));
                    }
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
            }
            b.append(ch);
        }
        return b.toString();
    }

    public static String normalize(String uri) {
        URL url = null;
        String result = null;
        try {
            url = new URL(uri);
            result = URIParserUtil.escapeChars(url.toURI().normalize().toString().replace("\\", "/"));
        }
        catch (MalformedURLException e1) {
            try {
                if (uri.startsWith("classpath:")) {
                    url = ClassLoaderUtils.getResource(uri.substring(10), URIParserUtil.class);
                    return url != null ? url.toExternalForm() : uri;
                }
                File file = new File(uri);
                if (file.exists()) {
                    return file.toURI().normalize().toString();
                }
                String f = null;
                f = uri.indexOf(":") != -1 && !uri.startsWith("/") ? "file:/" + uri : "file:" + uri;
                url = new URL(f);
                return URIParserUtil.escapeChars(url.toString().replace("\\", "/"));
            }
            catch (Exception e2) {
                return URIParserUtil.escapeChars(uri.replace("\\", "/"));
            }
        }
        catch (URISyntaxException e) {
            result = URIParserUtil.escapeChars(url.toString().replace("\\", "/"));
        }
        return result;
    }

    public static String getAbsoluteURI(String arg) {
        if (arg == null) {
            return null;
        }
        try {
            URI uri = new URI(arg);
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                if (!uri.isOpaque()) {
                    return uri.normalize().toString();
                }
                return new File("").toURI().resolve(uri.getPath()).toString();
            }
            return URIParserUtil.normalize(arg);
        }
        catch (Exception e2) {
            return URIParserUtil.normalize(arg);
        }
    }

    public static String relativize(String base, String toBeRelativized) throws URISyntaxException {
        if (base == null || toBeRelativized == null) {
            return null;
        }
        return URIParserUtil.relativize(new URI(base), new URI(toBeRelativized));
    }

    public static String relativize(URI baseURI, URI toBeRelativizedURI) throws URISyntaxException {
        if (baseURI == null || toBeRelativizedURI == null) {
            return null;
        }
        if (baseURI.isAbsolute() ^ toBeRelativizedURI.isAbsolute()) {
            return null;
        }
        String base = baseURI.getSchemeSpecificPart();
        String toBeRelativized = toBeRelativizedURI.getSchemeSpecificPart();
        int l1 = base.length();
        int l2 = toBeRelativized.length();
        if (l1 == 0) {
            return toBeRelativized;
        }
        int slashes = 0;
        StringBuilder sb = new StringBuilder();
        boolean differenceFound = false;
        for (int i = 0; i < l1; ++i) {
            char c = base.charAt(i);
            if (i < l2) {
                if (!differenceFound && c == toBeRelativized.charAt(i)) {
                    sb.append(c);
                    continue;
                }
                differenceFound = true;
                if (c != '/') continue;
                ++slashes;
                continue;
            }
            if (c != '/') continue;
            ++slashes;
        }
        String rResolved = new URI(URIParserUtil.getRoot(sb.toString())).relativize(new URI(toBeRelativized)).toString();
        StringBuilder relativizedPath = new StringBuilder();
        for (int i = 0; i < slashes; ++i) {
            relativizedPath.append("../");
        }
        relativizedPath.append(rResolved);
        return relativizedPath.toString();
    }

    private static String getRoot(String uri) {
        int idx = uri.lastIndexOf(47);
        if (idx == uri.length() - 1) {
            return uri;
        }
        if (idx == -1) {
            return "";
        }
        return uri.substring(0, idx + 1);
    }
}

