/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.spark;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.spark.JobEntrySparkSubmit;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.ControlSpaceKeyAdapter;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.core.widget.TextVarButtonRenderCallback;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class JobEntrySparkSubmitDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntrySparkSubmit.class;
    private static final int SHELL_MINIMUM_WIDTH = 400;
    private static final String[] FILEFORMATS = new String[]{BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Fileformat.All", (String[])new String[0])};
    private static final String[] MASTER_URLS = new String[]{"yarn-cluster", "yarn-client"};
    public static final String LOCAL_ENVIRONMENT = "Local";
    public static final String STATIC_ENVIRONMENT = "<Static>";
    protected static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Fileformat.All", (String[])new String[0])};
    protected Shell shell;
    private Text txtEntryName;
    private TextVar txtSparkSubmitUtility;
    private Button btnSparkSubmitUtility;
    private Button btnOK;
    private Button btnCancel;
    private TextVar txtClass;
    private TextVar txtFilesApplicationJar;
    private Text txtArguments;
    private Button btnFilesApplicationJar;
    private TextVar txtFilesPyFile;
    private Button btnFilesPyFile;
    private TableView tblFilesSupportingDocs;
    private TableView tblUtilityParameters;
    private Combo cmbType;
    private ComboVar cmbMasterURL;
    private Composite filesHeader;
    private Composite tabFilesComposite;
    private TextVar txtExecutorMemory;
    private TextVar txtDriverMemory;
    private Button chkEnableBlocking;
    private JobEntrySparkSubmit jobEntry;
    private boolean backupChanged;
    private SelectionAdapter btnSparkSubmitUtilityListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(JobEntrySparkSubmitDialog.this.shell, 4096);
            dialog.setFilterExtensions(new String[]{"*;*.*"});
            dialog.setFilterNames(FILEFORMATS);
            if (JobEntrySparkSubmitDialog.this.txtSparkSubmitUtility.getText() != null) {
                dialog.setFileName(JobEntrySparkSubmitDialog.this.txtSparkSubmitUtility.getText());
            }
            if (dialog.open() != null) {
                JobEntrySparkSubmitDialog.this.txtSparkSubmitUtility.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
            }
        }
    };
    private ModifyListener lsMod = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            JobEntrySparkSubmitDialog.this.jobEntry.setChanged();
        }
    };
    SelectionAdapter pathSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FileObject selectedFile = null;
            try {
                FileObject rootFile = null;
                FileObject initialFile = null;
                FileObject defaultInitialFile = null;
                String original = JobEntrySparkSubmitDialog.this.tblFilesSupportingDocs.getActiveTableItem().getText(JobEntrySparkSubmitDialog.this.tblFilesSupportingDocs.getActiveTableColumn());
                if (original != null) {
                    String fileName = JobEntrySparkSubmitDialog.this.jobMeta.environmentSubstitute(original);
                    if (fileName != null && !fileName.equals("")) {
                        try {
                            initialFile = KettleVFS.getFileObject((String)fileName);
                        }
                        catch (KettleException ex) {
                            initialFile = KettleVFS.getFileObject((String)"");
                        }
                        defaultInitialFile = KettleVFS.getFileObject((String)"file:///c:/");
                        rootFile = initialFile.getFileSystem().getRoot();
                    } else {
                        defaultInitialFile = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
                    }
                }
                if (rootFile == null) {
                    rootFile = defaultInitialFile.getFileSystem().getRoot();
                    initialFile = defaultInitialFile;
                }
                VfsFileChooserDialog fileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(rootFile, initialFile);
                fileChooserDialog.defaultInitialFile = defaultInitialFile;
                selectedFile = fileChooserDialog.open(JobEntrySparkSubmitDialog.this.shell, new String[]{"file"}, "file", true, null, new String[]{"*.*"}, FILETYPES, true, 2, false, false);
                if (selectedFile != null) {
                    String url = selectedFile.getURL().toString();
                    JobEntrySparkSubmitDialog.this.tblFilesSupportingDocs.getActiveTableItem().setText(JobEntrySparkSubmitDialog.this.tblFilesSupportingDocs.getActiveTableColumn(), url);
                }
            }
            catch (KettleFileException kettleFileException) {
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    };
    private SelectionAdapter btnFilesApplicationJarListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(JobEntrySparkSubmitDialog.this.shell, 4096);
            dialog.setFilterExtensions(new String[]{"*;*.*"});
            dialog.setFilterNames(FILEFORMATS);
            if (JobEntrySparkSubmitDialog.this.txtFilesApplicationJar.getText() != null) {
                dialog.setFileName(JobEntrySparkSubmitDialog.this.txtFilesApplicationJar.getText());
            }
            if (dialog.open() != null) {
                JobEntrySparkSubmitDialog.this.txtFilesApplicationJar.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
            }
        }
    };
    private SelectionAdapter btnFilesPyFileListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(JobEntrySparkSubmitDialog.this.shell, 4096);
            dialog.setFilterExtensions(new String[]{"*;*.*"});
            dialog.setFilterNames(FILEFORMATS);
            if (JobEntrySparkSubmitDialog.this.txtFilesPyFile.getText() != null) {
                dialog.setFileName(JobEntrySparkSubmitDialog.this.txtFilesPyFile.getText());
            }
            if (dialog.open() != null) {
                JobEntrySparkSubmitDialog.this.txtFilesPyFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
            }
        }
    };
    private SelectionAdapter typeSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            String text = JobEntrySparkSubmitDialog.this.cmbType.getText();
            if (Const.isEmpty((String)text)) {
                return;
            }
            for (Control c : JobEntrySparkSubmitDialog.this.filesHeader.getChildren()) {
                c.dispose();
            }
            if ("Python".equals(text)) {
                JobEntrySparkSubmitDialog.this.addOnFilesTabPython(JobEntrySparkSubmitDialog.this.filesHeader);
                JobEntrySparkSubmitDialog.this.jobEntry.setPyFile(JobEntrySparkSubmitDialog.this.txtFilesPyFile.getText());
                JobEntrySparkSubmitDialog.this.jobEntry.setJobType("Python");
            } else {
                JobEntrySparkSubmitDialog.this.addOnFilesTabJavaScala(JobEntrySparkSubmitDialog.this.filesHeader);
                JobEntrySparkSubmitDialog.this.jobEntry.setJar(JobEntrySparkSubmitDialog.this.txtFilesApplicationJar.getText());
                JobEntrySparkSubmitDialog.this.jobEntry.setClassName(JobEntrySparkSubmitDialog.this.txtClass.getText());
                JobEntrySparkSubmitDialog.this.jobEntry.setJobType("Java or Scala");
            }
            JobEntrySparkSubmitDialog.this.tabFilesComposite.layout(true);
            JobEntrySparkSubmitDialog.this.filesHeader.layout(true);
        }
    };

    public static void main(String[] a) {
        Display display = new Display();
        PropsUI.init((Display)display, (int)1);
        Shell shell = new Shell(display);
        JobEntrySparkSubmitDialog sh = new JobEntrySparkSubmitDialog(shell, new JobEntrySparkSubmit("Spark submit job entry"), null, new JobMeta());
        sh.open();
    }

    public JobEntrySparkSubmitDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntrySparkSubmit)jobEntryInt;
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.jobEntry);
        this.backupChanged = this.jobEntry.hasChanged();
        this.createContents();
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.pack();
        this.shell.setMinimumSize(400, this.shell.getSize().y);
        this.shell.setSize(530, 652);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobEntrySparkSubmitDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private void createContents() {
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Title", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        Label lblIcon = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)lblIcon);
        lblIcon.setImage(GUIResource.getInstance().getImage("org/pentaho/di/ui/job/entries/spark/img/spark.svg", ((Object)((Object)this)).getClass().getClassLoader(), 32, 32));
        lblIcon.setLayoutData((Object)this.fd(null, this.fa(0, 0), this.fa(100, 0)));
        Label lblEntryName = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)lblEntryName);
        lblEntryName.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Name.Label", (String[])new String[0]));
        lblEntryName.setLayoutData((Object)this.fd(new FormAttachment[0]));
        this.txtEntryName = new Text((Composite)this.shell, 2048);
        this.props.setLook((Control)this.txtEntryName);
        this.txtEntryName.setLayoutData((Object)this.fdwidth(300, null, this.fa((Control)lblEntryName, 5)));
        this.txtEntryName.addModifyListener(this.lsMod);
        Label sep = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)sep);
        sep.setLayoutData((Object)this.fd(this.fa(0, 0), this.fa((Control)this.txtEntryName, 15), this.fa(100, 0)));
        Label lblSparkSubmitUtility = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)lblSparkSubmitUtility);
        lblSparkSubmitUtility.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.ScriptPath.Label", (String[])new String[0]));
        lblSparkSubmitUtility.setLayoutData((Object)this.fd(null, this.fa((Control)sep, 15)));
        this.txtSparkSubmitUtility = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.txtSparkSubmitUtility);
        this.txtSparkSubmitUtility.setLayoutData((Object)this.fdwidth(300, null, this.fa((Control)lblSparkSubmitUtility, 5)));
        this.btnSparkSubmitUtility = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.btnSparkSubmitUtility);
        this.btnSparkSubmitUtility.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.btnSparkSubmitUtility.setLayoutData((Object)this.fd(this.fa((Control)this.txtSparkSubmitUtility, 10), this.fa((Control)this.txtSparkSubmitUtility, 0, 128), null));
        this.btnSparkSubmitUtility.addSelectionListener((SelectionListener)this.btnSparkSubmitUtilityListener);
        Label lblMasterURL = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)lblMasterURL);
        lblMasterURL.setLayoutData((Object)this.fd(null, this.fa((Control)this.txtSparkSubmitUtility, 10)));
        lblMasterURL.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.SparkMaster.Label", (String[])new String[0]));
        this.cmbMasterURL = new ComboVar((VariableSpace)this.jobMeta, (Composite)this.shell, 2048);
        this.props.setLook((Control)this.cmbMasterURL);
        this.cmbMasterURL.setLayoutData((Object)this.fd(this.fa(0, 0), this.fa((Control)lblMasterURL, 5), this.fa((Control)this.txtSparkSubmitUtility, 0, 131072)));
        Label lblType = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)lblType);
        lblType.setLayoutData((Object)this.fd(this.fa((Control)this.cmbMasterURL, 10), this.fa((Control)this.txtSparkSubmitUtility, 10)));
        lblType.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Type.Label", (String[])new String[0]));
        this.cmbType = new Combo((Composite)this.shell, 8);
        this.props.setLook((Control)this.cmbType);
        this.cmbType.setLayoutData((Object)this.fdwidth(300, this.fa((Control)this.cmbMasterURL, 10), this.fa((Control)lblType, 5), this.fa(100, 0)));
        this.cmbType.addSelectionListener((SelectionListener)this.typeSelectionListener);
        this.btnCancel = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.btnCancel);
        this.btnCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.btnCancel.setLayoutData((Object)this.fd(null, null, this.fa(100, 0), this.fa(100, 0)));
        this.btnOK = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.btnOK);
        this.btnOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.btnOK.setLayoutData((Object)this.fd(null, null, this.fa((Control)this.btnCancel, -5), this.fa(100, 0)));
        Label sep2 = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)sep2);
        sep2.setLayoutData((Object)this.fd(this.fa(0, 0), null, this.fa(100, 0), this.fa((Control)this.btnOK, -15)));
        this.chkEnableBlocking = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.chkEnableBlocking);
        this.chkEnableBlocking.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.BlockExecution.Label", (String[])new String[0]));
        this.chkEnableBlocking.setLayoutData((Object)this.fd(this.fa(0, 0), null, null, this.fa((Control)sep2, -15)));
        CTabFolder tabs = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)tabs, 5);
        this.props.setLook((Control)tabs);
        tabs.setLayoutData((Object)this.fd(this.fa(0, 0), this.fa((Control)this.cmbMasterURL, 15), this.fa(100, 0), this.fa((Control)this.chkEnableBlocking, -15)));
        CTabItem tabFiles = new CTabItem(tabs, 0);
        tabFiles.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Files.TabLabel", (String[])new String[0]));
        this.tabFilesComposite = new Composite((Composite)tabs, 0);
        this.props.setLook((Control)this.tabFilesComposite);
        tabFiles.setControl((Control)this.tabFilesComposite);
        this.addOnFilesTab(this.tabFilesComposite);
        CTabItem tabArguments = new CTabItem(tabs, 0);
        tabArguments.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Arguments.TabLabel", (String[])new String[0]));
        Composite tabArgumentsComposite = new Composite((Composite)tabs, 0);
        this.props.setLook((Control)tabArgumentsComposite);
        tabArguments.setControl((Control)tabArgumentsComposite);
        this.addOnArgumentsTab(tabArgumentsComposite);
        CTabItem tabOptions = new CTabItem(tabs, 0);
        tabOptions.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Options.TabLabel", (String[])new String[0]));
        Composite tabOptionsComposite = new Composite((Composite)tabs, 0);
        this.props.setLook((Control)tabOptionsComposite);
        tabOptions.setControl((Control)tabOptionsComposite);
        this.addOnOptionsTab(tabOptionsComposite);
        tabs.setSelection(tabFiles);
        this.typeSelectionListener.widgetSelected(null);
        this.btnOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JobEntrySparkSubmitDialog.this.ok();
            }
        });
        this.btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JobEntrySparkSubmitDialog.this.cancel();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntrySparkSubmitDialog.this.cancel();
            }
        });
    }

    private void addOnArgumentsTab(Composite tab) {
        tab.setLayout((Layout)new FormLayout());
        Label lblArguments = new Label(tab, 0);
        this.props.setLook((Control)lblArguments);
        lblArguments.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Args.Label", (String[])new String[0]));
        lblArguments.setLayoutData((Object)this.fd(this.fa(0, 15), this.fa(0, 15)));
        this.txtArguments = new Text(tab, 2114);
        this.props.setLook((Control)this.txtArguments);
        this.txtArguments.setLayoutData((Object)this.fd(this.fa(0, 15), this.fa((Control)lblArguments, 5), this.fa(100, -15), this.fa(100, -15)));
        ControlSpaceKeyAdapter controlSpaceKeyAdapter = new ControlSpaceKeyAdapter((VariableSpace)this.jobMeta, (Control)this.txtArguments, null, null);
        this.txtArguments.addKeyListener((KeyListener)controlSpaceKeyAdapter);
        Label txtArgumentsVar = new Label(tab, 0);
        txtArgumentsVar.setImage(GUIResource.getInstance().getImageVariable());
        txtArgumentsVar.setToolTipText(BaseMessages.getString(TextVar.class, (String)"TextVar.tooltip.InsertVariable", (String[])new String[0]));
        this.props.setLook((Control)txtArgumentsVar);
        FormData fdArgumentsVar = new FormData();
        fdArgumentsVar.right = new FormAttachment(100, -15);
        fdArgumentsVar.bottom = new FormAttachment((Control)this.txtArguments, 0, 128);
        txtArgumentsVar.setLayoutData((Object)fdArgumentsVar);
    }

    private void addOnOptionsTab(Composite tab) {
        tab.setLayout((Layout)new FormLayout());
        Label lblExecutorMemory = new Label(tab, 0);
        this.props.setLook((Control)lblExecutorMemory);
        lblExecutorMemory.setLayoutData((Object)this.fd(this.fa(0, 15), this.fa(0, 15)));
        lblExecutorMemory.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.MemoryAllocation.Executor.Label", (String[])new String[0]));
        this.txtExecutorMemory = new TextVar((VariableSpace)this.jobMeta, tab, 18436);
        this.props.setLook((Control)this.txtExecutorMemory);
        this.txtExecutorMemory.setLayoutData((Object)this.fdwidth(200, this.fa(0, 15), this.fa((Control)lblExecutorMemory, 5)));
        Label lblDriverMemory = new Label(tab, 0);
        this.props.setLook((Control)lblDriverMemory);
        lblDriverMemory.setLayoutData((Object)this.fd(this.fa((Control)this.txtExecutorMemory, 50), this.fa(0, 15)));
        lblDriverMemory.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.MemoryAllocation.Driver.Label", (String[])new String[0]));
        this.txtDriverMemory = new TextVar((VariableSpace)this.jobMeta, tab, 18436);
        this.props.setLook((Control)this.txtDriverMemory);
        this.txtDriverMemory.setLayoutData((Object)this.fdwidth(200, this.fa((Control)this.txtExecutorMemory, 50), this.fa((Control)lblDriverMemory, 5)));
        Label lblUtilityParameters = new Label(tab, 0);
        this.props.setLook((Control)lblUtilityParameters);
        lblUtilityParameters.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.UtilityParameters.Label", (String[])new String[0]));
        lblUtilityParameters.setLayoutData((Object)this.fd(this.fa(0, 15), this.fa((Control)this.txtExecutorMemory, 10)));
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.NameColumn.Label", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.ValueColumn.Label", (String[])new String[0]), 1)};
        this.tblUtilityParameters = new TableView((VariableSpace)this.jobEntry, tab, 67588, columns, this.jobEntry.getConfigParams().size(), false, null, this.props, false);
        this.props.setLook((Control)this.tblUtilityParameters);
        this.tblUtilityParameters.setLayoutData((Object)this.fd(this.fa(0, 15), this.fa((Control)lblUtilityParameters, 5), this.fa(100, -15), this.fa(100, -15)));
        this.tblUtilityParameters.getTable().addListener(11, (Listener)new ColumnsResizer(0, 50, 50));
    }

    private void addOnFilesTab(Composite tab) {
        tab.setLayout((Layout)new FormLayout());
        this.filesHeader = new Composite(tab, 0);
        this.props.setLook((Control)this.filesHeader);
        this.filesHeader.setLayoutData((Object)this.fd(this.fa(0, 15), this.fa(0, 15), this.fa(100, -15)));
        if ("Python".equals(this.jobEntry.getJobType())) {
            this.addOnFilesTabPython(this.filesHeader);
        } else {
            this.addOnFilesTabJavaScala(this.filesHeader);
        }
        Label lblSupportingDocs = new Label(tab, 0);
        this.props.setLook((Control)lblSupportingDocs);
        lblSupportingDocs.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.SupportingDocuments.Label", (String[])new String[0]));
        lblSupportingDocs.setLayoutData((Object)this.fd(this.fa(0, 15), this.fa((Control)this.filesHeader, 10)));
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.EnvironmentColumn.Label", (String[])new String[0]), 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.PathColumn.Label", (String[])new String[0]), 6)};
        columns[0].setComboValues(new String[]{LOCAL_ENVIRONMENT, STATIC_ENVIRONMENT});
        columns[0].setReadOnly(true);
        columns[1].setUsingVariables(true);
        columns[1].setTextVarButtonSelectionListener((SelectionListener)this.pathSelection);
        TextVarButtonRenderCallback callback = new TextVarButtonRenderCallback(){

            public boolean shouldRenderButton() {
                String envType = JobEntrySparkSubmitDialog.this.tblFilesSupportingDocs.getActiveTableItem().getText(JobEntrySparkSubmitDialog.this.tblFilesSupportingDocs.getActiveTableColumn() - 1);
                return !JobEntrySparkSubmitDialog.STATIC_ENVIRONMENT.equalsIgnoreCase(envType);
            }
        };
        columns[1].setRenderTextVarButtonCallback(callback);
        this.tblFilesSupportingDocs = new TableView((VariableSpace)this.jobEntry, tab, 67588, columns, this.jobEntry.getLibs().size(), false, null, this.props, false);
        this.props.setLook((Control)this.tblFilesSupportingDocs);
        this.tblFilesSupportingDocs.setLayoutData((Object)this.fd(this.fa(0, 15), this.fa((Control)lblSupportingDocs, 5), this.fa(100, -15), this.fa(100, -15)));
        this.tblFilesSupportingDocs.getTable().addListener(11, (Listener)new ColumnsResizer(0, 25, 75));
    }

    private void addOnFilesTabJavaScala(Composite panel) {
        panel.setLayout((Layout)new FormLayout());
        Label lblClass = new Label(panel, 0);
        this.props.setLook((Control)lblClass);
        lblClass.setLayoutData((Object)this.fd(this.fa(0, 0), this.fa(0, 0)));
        lblClass.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Class.Label", (String[])new String[0]));
        this.txtClass = new TextVar((VariableSpace)this.jobMeta, panel, 18436);
        this.props.setLook((Control)this.txtClass);
        this.txtClass.setLayoutData((Object)this.fdwidth(300, this.fa(0, 0), this.fa((Control)lblClass, 5)));
        this.txtClass.setText(Const.nullToEmpty((String)this.jobEntry.getClassName()));
        Label lblApplicationJar = new Label(panel, 0);
        this.props.setLook((Control)lblApplicationJar);
        lblApplicationJar.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Jar.Label", (String[])new String[0]));
        lblApplicationJar.setLayoutData((Object)this.fd(this.fa(0, 0), this.fa((Control)this.txtClass, 10)));
        this.txtFilesApplicationJar = new TextVar((VariableSpace)this.jobMeta, panel, 18436);
        this.props.setLook((Control)this.txtFilesApplicationJar);
        this.txtFilesApplicationJar.setLayoutData((Object)this.fdwidth(300, this.fa(0, 0), this.fa((Control)lblApplicationJar, 5)));
        this.txtFilesApplicationJar.setText(Const.nullToEmpty((String)this.jobEntry.getJar()));
        this.btnFilesApplicationJar = new Button(panel, 8);
        this.props.setLook((Control)this.btnFilesApplicationJar);
        this.btnFilesApplicationJar.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.btnFilesApplicationJar.setLayoutData((Object)this.fd(this.fa((Control)this.txtFilesApplicationJar, 10), this.fa((Control)this.txtFilesApplicationJar, 0, 128), null));
        this.btnFilesApplicationJar.addSelectionListener((SelectionListener)this.btnFilesApplicationJarListener);
    }

    private void addOnFilesTabPython(Composite panel) {
        panel.setLayout((Layout)new FormLayout());
        Label lblPyFile = new Label(panel, 0);
        this.props.setLook((Control)lblPyFile);
        lblPyFile.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.PyFile.Label", (String[])new String[0]));
        lblPyFile.setLayoutData((Object)this.fd(this.fa(0, 0), this.fa(0, 0)));
        this.txtFilesPyFile = new TextVar((VariableSpace)this.jobMeta, panel, 18436);
        this.props.setLook((Control)this.txtFilesPyFile);
        this.txtFilesPyFile.setLayoutData((Object)this.fdwidth(300, this.fa(0, 0), this.fa((Control)lblPyFile, 5)));
        this.txtFilesPyFile.setText(Const.nullToEmpty((String)this.jobEntry.getPyFile()));
        this.btnFilesPyFile = new Button(panel, 8);
        this.props.setLook((Control)this.btnFilesPyFile);
        this.btnFilesPyFile.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.btnFilesPyFile.setLayoutData((Object)this.fd(this.fa((Control)this.txtFilesPyFile, 10), this.fa((Control)this.txtFilesPyFile, 0, 128), null));
        this.btnFilesPyFile.addSelectionListener((SelectionListener)this.btnFilesPyFileListener);
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.backupChanged);
        this.jobEntry = null;
        this.dispose();
    }

    public void getData() {
        this.txtEntryName.setText(Const.nullToEmpty((String)this.jobEntry.getName()));
        this.txtSparkSubmitUtility.setText(Const.nullToEmpty((String)this.jobEntry.getScriptPath()));
        for (String url : MASTER_URLS) {
            this.cmbMasterURL.add(url);
        }
        this.cmbMasterURL.setText(Const.nullToEmpty((String)this.jobEntry.getMaster()));
        this.cmbType.add("Java or Scala");
        this.cmbType.add("Python");
        if ("Python".equals(this.jobEntry.getJobType())) {
            this.cmbType.select(1);
        } else {
            this.cmbType.select(0);
        }
        this.txtArguments.setText(Const.nullToEmpty((String)this.jobEntry.getArgs()));
        this.chkEnableBlocking.setSelection(this.jobEntry.isBlockExecution());
        List<String> params = this.jobEntry.getConfigParams();
        for (int i = 0; i < params.size(); ++i) {
            TableItem ti = this.tblUtilityParameters.table.getItem(i);
            String[] nameValue = params.get(i).split("=", 2);
            ti.setText(1, nameValue[0]);
            ti.setText(2, nameValue[1]);
        }
        this.tblUtilityParameters.setRowNums();
        this.tblUtilityParameters.optWidth(true);
        Map<String, String> docs = this.jobEntry.getLibs();
        int i = 0;
        for (String path : docs.keySet()) {
            TableItem ti = this.tblFilesSupportingDocs.table.getItem(i++);
            ti.setText(1, docs.get(path));
            ti.setText(2, path);
        }
        this.tblFilesSupportingDocs.setRowNums();
        this.tblFilesSupportingDocs.optWidth(true);
        this.txtExecutorMemory.setText(Const.nullToEmpty((String)this.jobEntry.getExecutorMemory()));
        this.txtDriverMemory.setText(Const.nullToEmpty((String)this.jobEntry.getDriverMemory()));
        this.txtEntryName.selectAll();
        this.txtEntryName.setFocus();
    }

    protected void ok() {
        if (Const.isEmpty((String)this.txtEntryName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.txtEntryName.getText());
        this.jobEntry.setScriptPath(this.txtSparkSubmitUtility.getText());
        this.jobEntry.setMaster(this.cmbMasterURL.getText());
        switch (this.jobEntry.getJobType()) {
            case "Java or Scala": {
                this.jobEntry.setJar(this.txtFilesApplicationJar.getText());
                this.jobEntry.setClassName(this.txtClass.getText());
                this.jobEntry.setPyFile(null);
                break;
            }
            case "Python": {
                this.jobEntry.setPyFile(this.txtFilesPyFile.getText());
                this.jobEntry.setJar(null);
                this.jobEntry.setClassName(null);
            }
        }
        this.jobEntry.setArgs(this.txtArguments.getText());
        this.jobEntry.setBlockExecution(this.chkEnableBlocking.getSelection());
        ArrayList<String> configParams = new ArrayList<String>(this.tblUtilityParameters.getItemCount());
        for (int i = 0; i < this.tblUtilityParameters.getItemCount(); ++i) {
            String[] item = this.tblUtilityParameters.getItem(i);
            if (Const.isEmpty((String)item[0]) || Const.isEmpty((String)item[1])) continue;
            configParams.add(item[0].trim() + "=" + item[1].trim());
        }
        this.jobEntry.setConfigParams(configParams);
        LinkedHashMap<String, String> supportingDocuments = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.tblFilesSupportingDocs.getItemCount(); ++i) {
            String[] item = this.tblFilesSupportingDocs.getItem(i);
            if (Const.isEmpty((String)item[0]) || Const.isEmpty((String)item[1])) continue;
            supportingDocuments.put(item[1].trim(), item[0].trim());
        }
        this.jobEntry.setLibs(supportingDocuments);
        this.jobEntry.setDriverMemory(this.txtDriverMemory.getText());
        this.jobEntry.setExecutorMemory(this.txtExecutorMemory.getText());
        this.dispose();
    }

    private FormData fd(FormAttachment ... att) {
        FormData fd = new FormData();
        if (att.length >= 1) {
            fd.left = att[0];
        }
        if (att.length >= 2) {
            fd.top = att[1];
        }
        if (att.length >= 3) {
            fd.right = att[2];
        }
        if (att.length >= 4) {
            fd.bottom = att[3];
        }
        return fd;
    }

    private FormData fdwidth(int width, FormAttachment ... att) {
        FormData fd = this.fd(att);
        fd.width = width;
        return fd;
    }

    private FormAttachment fa(int numerator, int offset) {
        return new FormAttachment(numerator, offset);
    }

    private FormAttachment fa(Control control, int offset) {
        return new FormAttachment(control, offset);
    }

    private FormAttachment fa(Control control, int offset, int alignment) {
        return new FormAttachment(control, offset, alignment);
    }

    public class ColumnsResizer
    implements Listener {
        private int[] weights;

        public ColumnsResizer(int ... weights) {
            this.weights = weights;
        }

        public void handleEvent(Event event) {
            Table table = (Table)event.widget;
            float width = table.getSize().x - 2;
            TableColumn[] columns = table.getColumns();
            int f = 0;
            for (int w : this.weights) {
                f += w;
            }
            for (int i = 0; i < this.weights.length; ++i) {
                int cw = this.weights[i] == 0 ? 0 : Math.round(width / (float)f * (float)this.weights[i]);
                width -= (float)(cw + 1);
                columns[i].setWidth(cw);
                f -= this.weights[i];
            }
        }
    }
}

