/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.awt;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.awt.AWTGraphicsDevice;

public class AWTGraphicsScreen
extends DefaultGraphicsScreen
implements Cloneable {
    public AWTGraphicsScreen(AWTGraphicsDevice aWTGraphicsDevice) {
        super((AbstractGraphicsDevice)aWTGraphicsDevice, AWTGraphicsScreen.findScreenIndex(aWTGraphicsDevice.getGraphicsDevice()));
    }

    public static GraphicsDevice getScreenDevice(int n) {
        if (n < 0) {
            return null;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (n < graphicsDeviceArray.length) {
            return graphicsDeviceArray[n];
        }
        return null;
    }

    public static int findScreenIndex(GraphicsDevice graphicsDevice) {
        if (null == graphicsDevice) {
            return -1;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (graphicsDeviceArray[i] != graphicsDevice) continue;
            return i;
        }
        return -1;
    }

    public static AbstractGraphicsScreen createScreenDevice(GraphicsDevice graphicsDevice) {
        AWTGraphicsDevice aWTGraphicsDevice = (AWTGraphicsDevice)AWTGraphicsDevice.createDevice(graphicsDevice);
        return new AWTGraphicsScreen(aWTGraphicsDevice);
    }

    public static AbstractGraphicsScreen createScreenDevice(int n) {
        GraphicsDevice graphicsDevice = AWTGraphicsScreen.getScreenDevice(n);
        return AWTGraphicsScreen.createScreenDevice(graphicsDevice);
    }

    public static AbstractGraphicsScreen createDefault() {
        return AWTGraphicsScreen.createScreenDevice(-1);
    }

    public Object clone() {
        return super.clone();
    }
}

