/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl.awt;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableHelper;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.ThreadingImpl;
import com.sun.opengl.impl.awt.Java2D;
import com.sun.opengl.impl.awt.Java2DGLContext;
import com.sun.opengl.util.FBObject;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.beans.Beans;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.media.nativewindow.NativeWindow;
import javax.media.opengl.DebugGL2;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import javax.media.opengl.Threading;
import javax.media.opengl.awt.AWTGLAutoDrawable;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JPanel;

public class GLJPanel
extends JPanel
implements AWTGLAutoDrawable {
    private static final boolean DEBUG = Debug.debug((String)"GLJPanel");
    private static final boolean VERBOSE = Debug.verbose();
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private volatile boolean isInitialized;
    private GLCapabilities offscreenCaps;
    private GLProfile glProfile;
    private GLDrawableFactoryImpl factory;
    private GLCapabilitiesChooser chooser;
    private GLContext shareWith;
    private int panelWidth = 0;
    private int panelHeight = 0;
    private boolean handleReshape = false;
    private boolean sendReshape = true;
    private Backend backend;
    private Updater updater = new Updater();
    private static final AccessControlContext localACC = AccessController.getContext();
    private static boolean hardwareAccelerationDisabled = Debug.isPropertyDefined((String)"jogl.gljpanel.nohw", (boolean)true, (AccessControlContext)localACC);
    private static boolean softwareRenderingDisabled = Debug.isPropertyDefined((String)"jogl.gljpanel.nosw", (boolean)true, (AccessControlContext)localACC);
    private boolean oglPipelineEnabled = Java2D.isOGLPipelineActive() && !Debug.isPropertyDefined((String)"jogl.gljpanel.noogl", (boolean)true, (AccessControlContext)localACC);
    private int reshapeX;
    private int reshapeY;
    private int reshapeWidth;
    private int reshapeHeight;
    private int viewportX;
    private int viewportY;
    private Object closingListener = null;
    private Object closingListenerLock = new Object();
    private boolean disposeRegenerate;
    private GLContext disposeContext;
    private GLDrawable disposeDrawable;
    private DisposeAction disposeAction = new DisposeAction();
    private DisposeOnEventDispatchThreadAction disposeOnEventDispatchThreadAction = new DisposeOnEventDispatchThreadAction();
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private PaintImmediatelyAction paintImmediatelyAction = new PaintImmediatelyAction();

    public GLJPanel() {
        this((GLCapabilities)null);
    }

    public GLJPanel(GLCapabilities gLCapabilities) {
        this(gLCapabilities, null, null);
    }

    public GLJPanel(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        this.offscreenCaps = gLCapabilities != null ? (GLCapabilities)gLCapabilities.clone() : new GLCapabilities(null);
        this.offscreenCaps.setDoubleBuffered(false);
        this.glProfile = this.offscreenCaps.getGLProfile();
        this.factory = GLDrawableFactoryImpl.getFactoryImpl((GLProfile)this.glProfile);
        this.chooser = gLCapabilitiesChooser != null ? gLCapabilitiesChooser : new DefaultGLCapabilitiesChooser();
        this.shareWith = gLContext;
    }

    public void display() {
        if (EventQueue.isDispatchThread()) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        } else {
            try {
                EventQueue.invokeAndWait(this.paintImmediatelyAction);
            }
            catch (Exception exception) {
                throw new GLException((Throwable)exception);
            }
        }
    }

    protected void dispose(boolean bl) {
        if (DEBUG) {
            Exception exception = new Exception("dispose(" + bl + ") - start");
            exception.printStackTrace();
        }
        if (this.backend != null) {
            this.disposeRegenerate = bl;
            this.disposeContext = this.backend.getContext();
            this.disposeDrawable = this.backend.getDrawable();
            if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
                if (ThreadingImpl.isAWTMode() && Thread.holdsLock(this.getTreeLock())) {
                    this.drawableHelper.invokeGL(this.disposeDrawable, this.disposeContext, (Runnable)this.disposeAction, null);
                } else {
                    Threading.invokeOnOpenGLThread((Runnable)this.disposeOnEventDispatchThreadAction);
                }
            } else {
                this.drawableHelper.invokeGL(this.disposeDrawable, this.disposeContext, (Runnable)this.disposeAction, null);
            }
            this.backend.setContext(this.disposeContext);
            if (null == this.disposeContext) {
                this.isInitialized = false;
            }
        }
        if (DEBUG) {
            System.err.println("dispose(" + bl + ") - stop");
        }
    }

    public void destroy() {
        this.removeNotify();
    }

    protected void paintComponent(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        if (this.backend == null || !this.isInitialized) {
            this.createAndInitializeBackend();
        }
        if (!this.isInitialized) {
            return;
        }
        if (this.handleReshape) {
            this.handleReshape();
        }
        this.updater.setGraphics(graphics);
        this.backend.doPaintComponent(graphics);
    }

    public void addNotify() {
        super.addNotify();
        if (DEBUG) {
            System.err.println("GLJPanel.addNotify()");
        }
    }

    public void removeNotify() {
        if (DEBUG) {
            Exception exception = new Exception("removeNotify - start");
            exception.printStackTrace();
        }
        this.dispose(false);
        if (this.backend != null) {
            this.backend.destroy();
            this.backend = null;
        }
        this.isInitialized = false;
        super.removeNotify();
        if (DEBUG) {
            System.out.println("removeNotify - end");
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.reshapeX = n;
        this.reshapeY = n2;
        this.reshapeWidth = n3;
        this.reshapeHeight = n4;
        this.handleReshape = true;
    }

    public void setOpaque(boolean bl) {
        if (this.backend != null) {
            this.backend.setOpaque(bl);
        }
        super.setOpaque(bl);
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public GLContext createContext(GLContext gLContext) {
        return this.backend.createContext(gLContext);
    }

    public void setRealized(boolean bl) {
    }

    public void setContext(GLContext gLContext) {
        if (this.backend == null) {
            return;
        }
        this.backend.setContext(gLContext);
    }

    public GLContext getContext() {
        if (this.backend == null) {
            return null;
        }
        return this.backend.getContext();
    }

    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        GLContext gLContext = this.getContext();
        return gLContext == null ? null : gLContext.getGL();
    }

    public GL setGL(GL gL) {
        GLContext gLContext = this.getContext();
        if (gLContext != null) {
            gLContext.setGL(gL);
            return gL;
        }
        return null;
    }

    public void setAutoSwapBufferMode(boolean bl) {
    }

    public boolean getAutoSwapBufferMode() {
        return true;
    }

    public void swapBuffers() {
    }

    public boolean shouldPreserveColorBufferIfTranslucent() {
        return this.oglPipelineEnabled;
    }

    public GLCapabilities getChosenGLCapabilities() {
        return this.backend.getChosenGLCapabilities();
    }

    public final GLProfile getGLProfile() {
        return this.glProfile;
    }

    public NativeWindow getNativeWindow() {
        throw new GLException("FIXME");
    }

    public final GLDrawableFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndInitializeBackend() {
        if (this.panelWidth == 0 || this.panelHeight == 0) {
            if (this.reshapeWidth == 0 || this.reshapeHeight == 0) {
                return;
            }
            this.panelWidth = this.reshapeWidth;
            this.panelHeight = this.reshapeHeight;
        }
        do {
            if (this.backend == null) {
                if (this.oglPipelineEnabled) {
                    this.backend = new J2DOGLBackend();
                } else if (!hardwareAccelerationDisabled && this.factory.canCreateGLPbuffer()) {
                    this.backend = new PbufferBackend();
                } else {
                    if (softwareRenderingDisabled) {
                        throw new GLException("Fallback to software rendering disabled by user");
                    }
                    this.backend = new SoftwareBackend();
                }
            }
            if (this.isInitialized) continue;
            this.backend.initialize();
        } while (this.backend == null);
        if (null == this.closingListener) {
            Object object = this.closingListenerLock;
            synchronized (object) {
                if (null == this.closingListener) {
                    this.closingListener = GLCanvas.addClosingListener(this, new GLCanvas.DestroyMethod(){

                        public void destroyMethod() {
                            GLJPanel.this.destroy();
                        }
                    });
                }
            }
        }
    }

    private void handleReshape() {
        this.panelWidth = this.reshapeWidth;
        this.panelHeight = this.reshapeHeight;
        if (DEBUG) {
            System.err.println("GLJPanel.handleReshape: (w,h) = (" + this.panelWidth + "," + this.panelHeight + ")");
        }
        this.sendReshape = true;
        this.backend.handleReshape();
        this.handleReshape = false;
    }

    public String toString() {
        return "AWT-GLJPanel[ " + (null != this.backend ? this.backend.getDrawable().getClass().getName() : "null-drawable") + ", " + this.drawableHelper + "]";
    }

    private int getNextPowerOf2(int n) {
        if (n == 0) {
            return 2;
        }
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    private int getGLInteger(GL gL, int n) {
        int[] nArray = new int[1];
        gL.glGetIntegerv(n, nArray, 0);
        return nArray[0];
    }

    static {
        if (Java2D.isOGLPipelineActive() && Java2D.isFBOEnabled()) {
            Java2D.getShareContext(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        }
    }

    abstract class AbstractReadbackBackend
    implements Backend {
        protected BufferedImage offscreenImage;
        protected ByteBuffer readBackBytes;
        protected IntBuffer readBackInts;
        protected int readBackWidthInPixels;
        protected int readBackHeightInPixels;
        private int awtFormat;
        private int glFormat;
        private int glType;
        private int[] swapbytes = new int[1];
        private int[] rowlength = new int[1];
        private int[] skiprows = new int[1];
        private int[] skippixels = new int[1];
        private int[] alignment = new int[1];

        AbstractReadbackBackend() {
        }

        public void setOpaque(boolean bl) {
            if (bl != GLJPanel.this.isOpaque() && this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
        }

        public boolean preGL(Graphics graphics) {
            return true;
        }

        public void postGL(Graphics graphics, boolean bl) {
            block16: {
                if (!bl) break block16;
                if (this.offscreenImage == null && GLJPanel.this.panelWidth > 0 && GLJPanel.this.panelHeight > 0) {
                    int n = 0;
                    n = GLJPanel.this.isOpaque() ? 1 : 2;
                    this.offscreenImage = new BufferedImage(GLJPanel.this.panelWidth, GLJPanel.this.panelHeight, n);
                    switch (n) {
                        case 5: {
                            this.glFormat = 32992;
                            this.glType = 5121;
                            this.readBackBytes = ByteBuffer.allocate(this.readBackWidthInPixels * this.readBackHeightInPixels * 3);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.glFormat = 32993;
                            this.glType = this.getGLPixelType();
                            this.readBackInts = IntBuffer.allocate(this.readBackWidthInPixels * this.readBackHeightInPixels);
                            break;
                        }
                        default: {
                            throw new GLException("Unsupported offscreen image type " + n);
                        }
                    }
                }
                if (this.offscreenImage != null) {
                    GL2 gL2 = GLJPanel.this.getGL().getGL2();
                    gL2.glGetIntegerv(3328, this.swapbytes, 0);
                    gL2.glGetIntegerv(3330, this.rowlength, 0);
                    gL2.glGetIntegerv(3331, this.skiprows, 0);
                    gL2.glGetIntegerv(3332, this.skippixels, 0);
                    gL2.glGetIntegerv(3333, this.alignment, 0);
                    gL2.glPixelStorei(3328, 0);
                    gL2.glPixelStorei(3330, this.readBackWidthInPixels);
                    gL2.glPixelStorei(3331, 0);
                    gL2.glPixelStorei(3332, 0);
                    gL2.glPixelStorei(3333, 1);
                    gL2.glReadBuffer(1028);
                    if (this.readBackBytes != null) {
                        gL2.glReadPixels(0, 0, this.readBackWidthInPixels, this.readBackHeightInPixels, this.glFormat, this.glType, (Buffer)this.readBackBytes);
                    } else if (this.readBackInts != null) {
                        gL2.glReadPixels(0, 0, this.readBackWidthInPixels, this.readBackHeightInPixels, this.glFormat, this.glType, (Buffer)this.readBackInts);
                    }
                    gL2.glPixelStorei(3328, this.swapbytes[0]);
                    gL2.glPixelStorei(3330, this.rowlength[0]);
                    gL2.glPixelStorei(3331, this.skiprows[0]);
                    gL2.glPixelStorei(3332, this.skippixels[0]);
                    gL2.glPixelStorei(3333, this.alignment[0]);
                    if (this.readBackBytes != null || this.readBackInts != null) {
                        Object[] objectArray = null;
                        Object[] objectArray2 = null;
                        int n = 0;
                        int n2 = 0;
                        if (this.readBackBytes != null) {
                            objectArray = this.readBackBytes.array();
                            objectArray2 = ((DataBufferByte)this.offscreenImage.getRaster().getDataBuffer()).getData();
                            n = this.readBackWidthInPixels * 3;
                            n2 = this.offscreenImage.getWidth() * 3;
                        } else {
                            objectArray = this.readBackInts.array();
                            objectArray2 = ((DataBufferInt)this.offscreenImage.getRaster().getDataBuffer()).getData();
                            n = this.readBackWidthInPixels;
                            n2 = this.offscreenImage.getWidth();
                        }
                        if (this.flipVertically()) {
                            int n3 = 0;
                            for (int i = (this.offscreenImage.getHeight() - 1) * n2; i >= 0; i -= n2) {
                                System.arraycopy(objectArray, n3, objectArray2, i, n2);
                                n3 += n;
                            }
                        } else {
                            int n4 = 0;
                            int n5 = n2 * this.offscreenImage.getHeight();
                            for (int i = 0; i < n5; i += n2) {
                                System.arraycopy(objectArray, n4, objectArray2, i, n2);
                                n4 += n;
                            }
                        }
                    }
                }
            }
        }

        public void doPaintComponent(Graphics graphics) {
            this.doPaintComponentImpl();
            if (this.offscreenImage != null) {
                graphics.drawImage(this.offscreenImage, 0, 0, this.offscreenImage.getWidth(), this.offscreenImage.getHeight(), GLJPanel.this);
            }
        }

        protected abstract void doPaintComponentImpl();

        protected abstract int getGLPixelType();

        protected abstract boolean flipVertically();
    }

    static interface Backend {
        public void initialize();

        public void destroy();

        public void setOpaque(boolean var1);

        public GLContext createContext(GLContext var1);

        public void setContext(GLContext var1);

        public GLContext getContext();

        public GLDrawable getDrawable();

        public GLCapabilities getChosenGLCapabilities();

        public GLProfile getGLProfile();

        public void handleReshape();

        public boolean preGL(Graphics var1);

        public void postGL(Graphics var1, boolean var2);

        public void doPaintComponent(Graphics var1);
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            GLJPanel.this.updater.display(GLJPanel.this);
        }
    }

    class DisposeAction
    implements Runnable {
        DisposeAction() {
        }

        public void run() {
            GLJPanel.this.updater.dispose(GLJPanel.this);
            if (null != GLJPanel.this.disposeContext) {
                GLJPanel.this.disposeContext.destroy();
                GLJPanel.this.disposeContext = null;
            }
            if (null != GLJPanel.this.disposeDrawable) {
                GLJPanel.this.disposeDrawable.setRealized(false);
            }
            if (GLJPanel.this.disposeRegenerate && null != GLJPanel.this.disposeDrawable) {
                GLJPanel.this.disposeDrawable.setRealized(true);
                GLJPanel.this.disposeContext = (GLContext)((GLContextImpl)GLJPanel.this.disposeDrawable.createContext(GLJPanel.this.shareWith));
                GLJPanel.this.disposeContext.setSynchronized(true);
            }
        }
    }

    class DisposeOnEventDispatchThreadAction
    implements Runnable {
        DisposeOnEventDispatchThreadAction() {
        }

        public void run() {
            GLJPanel.this.drawableHelper.invokeGL(GLJPanel.this.disposeDrawable, GLJPanel.this.disposeContext, (Runnable)GLJPanel.this.disposeAction, null);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLJPanel.this.updater.init(GLJPanel.this);
        }
    }

    class J2DOGLBackend
    implements Backend {
        private Object j2dSurface;
        private Graphics cached2DGraphics;
        private GLContext j2dContext;
        private GLDrawable joglDrawable;
        private GLContext joglContext;
        private int[] drawBuffer = new int[1];
        private int[] readBuffer = new int[1];
        private int[] frameBuffer = new int[1];
        private boolean checkedForFBObjectWorkarounds;
        private boolean fbObjectWorkarounds;
        private int[] frameBufferDepthBuffer;
        private int[] frameBufferTexture;
        private boolean createNewDepthBuffer;
        private boolean checkedGLVendor;
        private boolean vendorIsATI;
        private GraphicsConfiguration workaroundConfig;

        J2DOGLBackend() {
        }

        public void initialize() {
            GLJPanel.this.isInitialized = true;
        }

        public void destroy() {
            Java2D.invokeWithOGLContextCurrent(null, new Runnable(){

                public void run() {
                    if (J2DOGLBackend.this.joglContext != null) {
                        J2DOGLBackend.this.joglContext.destroy();
                        J2DOGLBackend.this.joglContext = null;
                    }
                    J2DOGLBackend.this.joglDrawable = null;
                    if (J2DOGLBackend.this.j2dContext != null) {
                        J2DOGLBackend.this.j2dContext.destroy();
                        J2DOGLBackend.this.j2dContext = null;
                    }
                }
            });
        }

        public void setOpaque(boolean bl) {
        }

        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Not yet implemented");
        }

        public void setContext(GLContext gLContext) {
            this.joglContext = gLContext;
        }

        public GLContext getContext() {
            return this.joglContext;
        }

        public GLDrawable getDrawable() {
            return this.joglDrawable;
        }

        public GLCapabilities getChosenGLCapabilities() {
            return new GLCapabilities(null);
        }

        public GLProfile getGLProfile() {
            return GLProfile.getDefault();
        }

        public void handleReshape() {
        }

        public boolean preGL(Graphics graphics) {
            GL2 gL2 = this.joglContext.getGL().getGL2();
            gL2.glEnable(3089);
            Rectangle rectangle = Java2D.getOGLScissorBox(graphics);
            if (rectangle == null) {
                if (DEBUG && VERBOSE) {
                    System.err.println("Java2D.getOGLScissorBox() returned null");
                }
                return false;
            }
            if (DEBUG && VERBOSE) {
                System.err.println("GLJPanel: gl.glScissor(" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ")");
            }
            gL2.glScissor(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Rectangle rectangle2 = Java2D.getOGLViewport(graphics, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
            if (GLJPanel.this.viewportX != rectangle2.x || GLJPanel.this.viewportY != rectangle2.y) {
                GLJPanel.this.sendReshape = true;
                if (DEBUG) {
                    System.err.println("Sending reshape because viewport changed");
                    System.err.println("  viewportX (" + GLJPanel.this.viewportX + ") ?= oglViewport.x (" + rectangle2.x + ")");
                    System.err.println("  viewportY (" + GLJPanel.this.viewportY + ") ?= oglViewport.y (" + rectangle2.y + ")");
                }
            }
            GLJPanel.this.viewportX = rectangle2.x;
            GLJPanel.this.viewportY = rectangle2.y;
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                int n;
                int n2 = Java2D.getOGLTextureType(graphics);
                if (!this.checkedForFBObjectWorkarounds) {
                    this.checkedForFBObjectWorkarounds = true;
                    gL2.glBindTexture(n2, 0);
                    gL2.glBindFramebuffer(36160, this.frameBuffer[0]);
                    n = gL2.glCheckFramebufferStatus(36160);
                    if (n != 36053) {
                        this.fbObjectWorkarounds = true;
                        this.createNewDepthBuffer = true;
                        if (DEBUG || VERBOSE) {
                            System.err.println("GLJPanel: ERR GL_FRAMEBUFFER_BINDING: Discovered Invalid J2D FBO(" + this.frameBuffer[0] + "): " + FBObject.getStatusString((int)n) + ", frame_buffer_object workarounds to be necessary");
                        }
                    } else {
                        this.frameBufferTexture = null;
                        if (DEBUG || VERBOSE) {
                            System.err.println("GLJPanel: OK GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0]);
                        }
                    }
                }
                if (this.fbObjectWorkarounds && this.createNewDepthBuffer) {
                    if (this.frameBufferDepthBuffer == null) {
                        this.frameBufferDepthBuffer = new int[1];
                    }
                    if (this.frameBufferDepthBuffer[0] != 0) {
                        gL2.glDeleteRenderbuffers(1, this.frameBufferDepthBuffer, 0);
                        this.frameBufferDepthBuffer[0] = 0;
                    }
                    gL2.glBindTexture(n2, this.frameBufferTexture[0]);
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    gL2.glGetTexLevelParameteriv(n2, 0, 4096, nArray, 0);
                    gL2.glGetTexLevelParameteriv(n2, 0, 4097, nArray2, 0);
                    gL2.glGenRenderbuffers(1, this.frameBufferDepthBuffer, 0);
                    if (DEBUG) {
                        System.err.println("GLJPanel: Generated frameBufferDepthBuffer " + this.frameBufferDepthBuffer[0] + " with width " + nArray[0] + ", height " + nArray2[0]);
                    }
                    gL2.glBindRenderbuffer(36161, this.frameBufferDepthBuffer[0]);
                    gL2.glRenderbufferStorage(36161, 33190, nArray[0], nArray2[0]);
                    gL2.glBindRenderbuffer(36161, 0);
                    this.createNewDepthBuffer = false;
                }
                gL2.glBindTexture(n2, 0);
                gL2.glBindFramebuffer(36160, this.frameBuffer[0]);
                if (this.fbObjectWorkarounds) {
                    gL2.glFramebufferTexture2D(36160, 36064, n2, this.frameBufferTexture[0], 0);
                    if (DEBUG && VERBOSE) {
                        System.err.println("GLJPanel: frameBufferDepthBuffer: " + this.frameBufferDepthBuffer[0]);
                    }
                    gL2.glFramebufferRenderbuffer(36160, 36096, 36161, this.frameBufferDepthBuffer[0]);
                }
                if (DEBUG && (n = gL2.glCheckFramebufferStatus(36160)) != 36053) {
                    throw new GLException("Error: framebuffer was incomplete: status = 0x" + Integer.toHexString(n));
                }
            } else {
                if (DEBUG && VERBOSE) {
                    System.err.println("GLJPanel: Setting up drawBuffer " + this.drawBuffer[0] + " and readBuffer " + this.readBuffer[0]);
                }
                gL2.glDrawBuffer(this.drawBuffer[0]);
                gL2.glReadBuffer(this.readBuffer[0]);
            }
            return true;
        }

        public void postGL(Graphics graphics, boolean bl) {
            GL gL = GLJPanel.this.getGL();
            gL.glFinish();
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                gL.glBindFramebuffer(36160, 0);
            }
        }

        public void doPaintComponent(final Graphics graphics) {
            if (Java2D.isFBOEnabled()) {
                if (this.workaroundConfig == null) {
                    this.workaroundConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                }
                Java2D.invokeWithOGLSharedContextCurrent(this.workaroundConfig, new Runnable(){

                    public void run() {
                    }
                });
            }
            Java2D.invokeWithOGLContextCurrent(graphics, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object;
                    if (DEBUG && VERBOSE) {
                        System.err.println("-- In invokeWithOGLContextCurrent");
                    }
                    if (J2DOGLBackend.this.j2dContext == null) {
                        J2DOGLBackend.this.j2dContext = GLJPanel.this.factory.createExternalGLContext();
                        if (DEBUG || VERBOSE) {
                            System.err.println("-- Created External Context: " + J2DOGLBackend.this.j2dContext);
                        }
                        if (DEBUG) {
                            J2DOGLBackend.this.j2dContext.setGL((GL)new DebugGL2(J2DOGLBackend.this.j2dContext.getGL().getGL2()));
                        }
                        J2DOGLBackend.this.j2dContext.makeCurrent();
                        object = J2DOGLBackend.this.j2dContext.getGL();
                        if (GLJPanel.this.getGLInteger((GL)object, 3410) < GLJPanel.this.offscreenCaps.getRedBits() || GLJPanel.this.getGLInteger((GL)object, 3411) < GLJPanel.this.offscreenCaps.getGreenBits() || GLJPanel.this.getGLInteger((GL)object, 3412) < GLJPanel.this.offscreenCaps.getBlueBits() || GLJPanel.this.getGLInteger((GL)object, 3416) < GLJPanel.this.offscreenCaps.getAccumRedBits() || GLJPanel.this.getGLInteger((GL)object, 3417) < GLJPanel.this.offscreenCaps.getAccumGreenBits() || GLJPanel.this.getGLInteger((GL)object, 3418) < GLJPanel.this.offscreenCaps.getAccumBlueBits() || GLJPanel.this.getGLInteger((GL)object, 3419) < GLJPanel.this.offscreenCaps.getAccumAlphaBits() || GLJPanel.this.getGLInteger((GL)object, 3415) < GLJPanel.this.offscreenCaps.getStencilBits()) {
                            if (DEBUG) {
                                System.err.println("GLJPanel: Falling back to pbuffer-based support because Java2D context insufficient");
                                System.err.println("                    Available              Required");
                                System.err.println("GL_RED_BITS         " + GLJPanel.this.getGLInteger((GL)object, 3410) + "              " + GLJPanel.this.offscreenCaps.getRedBits());
                                System.err.println("GL_GREEN_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3411) + "              " + GLJPanel.this.offscreenCaps.getGreenBits());
                                System.err.println("GL_BLUE_BITS        " + GLJPanel.this.getGLInteger((GL)object, 3412) + "              " + GLJPanel.this.offscreenCaps.getBlueBits());
                                System.err.println("GL_ALPHA_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3413) + "              " + GLJPanel.this.offscreenCaps.getAlphaBits());
                                System.err.println("GL_ACCUM_RED_BITS   " + GLJPanel.this.getGLInteger((GL)object, 3416) + "              " + GLJPanel.this.offscreenCaps.getAccumRedBits());
                                System.err.println("GL_ACCUM_GREEN_BITS " + GLJPanel.this.getGLInteger((GL)object, 3417) + "              " + GLJPanel.this.offscreenCaps.getAccumGreenBits());
                                System.err.println("GL_ACCUM_BLUE_BITS  " + GLJPanel.this.getGLInteger((GL)object, 3418) + "              " + GLJPanel.this.offscreenCaps.getAccumBlueBits());
                                System.err.println("GL_ACCUM_ALPHA_BITS " + GLJPanel.this.getGLInteger((GL)object, 3419) + "              " + GLJPanel.this.offscreenCaps.getAccumAlphaBits());
                                System.err.println("GL_DEPTH_BITS       " + GLJPanel.this.getGLInteger((GL)object, 3414) + "              " + GLJPanel.this.offscreenCaps.getDepthBits());
                                System.err.println("GL_STENCIL_BITS     " + GLJPanel.this.getGLInteger((GL)object, 3415) + "              " + GLJPanel.this.offscreenCaps.getStencilBits());
                            }
                            GLJPanel.this.isInitialized = false;
                            GLJPanel.this.backend = null;
                            GLJPanel.this.oglPipelineEnabled = false;
                            GLJPanel.this.handleReshape = true;
                            J2DOGLBackend.this.j2dContext.release();
                            J2DOGLBackend.this.j2dContext.destroy();
                            J2DOGLBackend.this.j2dContext = null;
                            return;
                        }
                        J2DOGLBackend.this.j2dContext.release();
                    }
                    J2DOGLBackend.this.j2dContext.makeCurrent();
                    try {
                        J2DOGLBackend.this.captureJ2DState(J2DOGLBackend.this.j2dContext.getGL(), graphics);
                        object = Java2D.getOGLSurfaceIdentifier(graphics);
                        if (object != null) {
                            if (J2DOGLBackend.this.j2dSurface != object) {
                                if (J2DOGLBackend.this.joglContext != null) {
                                    J2DOGLBackend.this.joglContext.destroy();
                                    J2DOGLBackend.this.joglContext = null;
                                    J2DOGLBackend.this.joglDrawable = null;
                                    GLJPanel.this.sendReshape = true;
                                    if (DEBUG || VERBOSE) {
                                        System.err.println("Sending reshape because surface changed");
                                        System.err.println("New surface = " + object);
                                    }
                                }
                                J2DOGLBackend.this.j2dSurface = object;
                                if (DEBUG || VERBOSE) {
                                    System.err.print("-- Surface type: ");
                                    int n = Java2D.getOGLSurfaceType(graphics);
                                    if (n == Java2D.UNDEFINED) {
                                        System.err.println("UNDEFINED");
                                    } else if (n == Java2D.WINDOW) {
                                        System.err.println("WINDOW");
                                    } else if (n == Java2D.PBUFFER) {
                                        System.err.println("PBUFFER");
                                    } else if (n == Java2D.TEXTURE) {
                                        System.err.println("TEXTURE");
                                    } else if (n == Java2D.FLIP_BACKBUFFER) {
                                        System.err.println("FLIP_BACKBUFFER");
                                    } else if (n == Java2D.FBOBJECT) {
                                        System.err.println("FBOBJECT");
                                    } else {
                                        System.err.println("(Unknown surface type " + n + ")");
                                    }
                                }
                            }
                            if (J2DOGLBackend.this.joglContext == null) {
                                if (GLJPanel.this.factory.canCreateExternalGLDrawable()) {
                                    J2DOGLBackend.this.joglDrawable = GLJPanel.this.factory.createExternalGLDrawable();
                                    J2DOGLBackend.this.joglContext = J2DOGLBackend.this.joglDrawable.createContext(J2DOGLBackend.this.j2dContext);
                                    if (DEBUG || VERBOSE) {
                                        System.err.println("-- Created External Drawable: " + J2DOGLBackend.this.joglDrawable);
                                        System.err.println("-- Created Context: " + J2DOGLBackend.this.joglContext);
                                    }
                                } else if (GLJPanel.this.factory.canCreateContextOnJava2DSurface()) {
                                    J2DOGLBackend.this.joglContext = GLJPanel.this.factory.createContextOnJava2DSurface((Object)graphics, J2DOGLBackend.this.j2dContext);
                                    if (DEBUG || VERBOSE) {
                                        System.err.println("-- Created Context: " + J2DOGLBackend.this.joglContext);
                                    }
                                }
                                if (DEBUG) {
                                    J2DOGLBackend.this.joglContext.setGL((GL)new DebugGL2(J2DOGLBackend.this.joglContext.getGL().getGL2()));
                                }
                                if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT && J2DOGLBackend.this.fbObjectWorkarounds) {
                                    J2DOGLBackend.this.createNewDepthBuffer = true;
                                }
                            }
                            if (J2DOGLBackend.this.joglContext instanceof Java2DGLContext) {
                                ((Java2DGLContext)J2DOGLBackend.this.joglContext).setGraphics(graphics);
                            }
                            GLJPanel.this.drawableHelper.invokeGL(J2DOGLBackend.this.joglDrawable, J2DOGLBackend.this.joglContext, (Runnable)GLJPanel.this.displayAction, (Runnable)GLJPanel.this.initAction);
                        }
                    }
                    finally {
                        J2DOGLBackend.this.j2dContext.release();
                    }
                }
            });
        }

        private void captureJ2DState(GL gL, Graphics graphics) {
            gL.glGetIntegerv(3073, this.drawBuffer, 0);
            gL.glGetIntegerv(3074, this.readBuffer, 0);
            if (Java2D.isFBOEnabled() && Java2D.getOGLSurfaceType(graphics) == Java2D.FBOBJECT) {
                gL.glGetIntegerv(36006, this.frameBuffer, 0);
                if (!gL.glIsFramebuffer(this.frameBuffer[0])) {
                    this.checkedForFBObjectWorkarounds = true;
                    this.fbObjectWorkarounds = true;
                    this.createNewDepthBuffer = true;
                    if (DEBUG || VERBOSE) {
                        System.err.println("GLJPanel: Fetched ERR GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0] + " - NOT A FBO" + ", frame_buffer_object workarounds to be necessary");
                    }
                } else if (DEBUG) {
                    System.err.println("GLJPanel: Fetched OK GL_FRAMEBUFFER_BINDING: " + this.frameBuffer[0]);
                }
                if (this.fbObjectWorkarounds || !this.checkedForFBObjectWorkarounds) {
                    if (this.frameBufferTexture == null) {
                        this.frameBufferTexture = new int[1];
                    }
                    gL.glGetFramebufferAttachmentParameteriv(36160, 36064, 36049, this.frameBufferTexture, 0);
                    if (DEBUG && VERBOSE) {
                        System.err.println("GLJPanel: FBO COLOR_ATTACHMENT0: " + this.frameBufferTexture[0]);
                    }
                }
                if (!this.checkedGLVendor) {
                    this.checkedGLVendor = true;
                    String string = gL.glGetString(7936);
                    if (string != null && string.startsWith("ATI")) {
                        this.vendorIsATI = true;
                    }
                }
                if (this.vendorIsATI) {
                    gL.glBindFramebuffer(36160, 0);
                }
            }
        }
    }

    class PaintImmediatelyAction
    implements Runnable {
        PaintImmediatelyAction() {
        }

        public void run() {
            GLJPanel.this.paintImmediately(0, 0, GLJPanel.this.getWidth(), GLJPanel.this.getHeight());
        }
    }

    class PbufferBackend
    extends AbstractReadbackBackend {
        private GLPbuffer pbuffer;
        private int pbufferWidth = 256;
        private int pbufferHeight = 256;

        PbufferBackend() {
        }

        public void initialize() {
            if (this.pbuffer != null) {
                throw new InternalError("Creating pbuffer twice without destroying it (memory leak / correctness bug)");
            }
            try {
                this.pbuffer = GLJPanel.this.factory.createGLPbuffer(GLJPanel.this.offscreenCaps, null, this.pbufferWidth, this.pbufferHeight, GLJPanel.this.shareWith);
                this.pbuffer.addGLEventListener((GLEventListener)GLJPanel.this.updater);
                GLJPanel.this.isInitialized = true;
            }
            catch (GLException gLException) {
                if (DEBUG) {
                    gLException.printStackTrace();
                    System.err.println("GLJPanel: Falling back on software rendering because of problems creating pbuffer");
                }
                hardwareAccelerationDisabled = true;
                GLJPanel.this.backend = null;
                GLJPanel.this.isInitialized = false;
                GLJPanel.this.createAndInitializeBackend();
            }
        }

        public void destroy() {
            if (this.pbuffer != null) {
                this.pbuffer.destroy();
                this.pbuffer = null;
            }
        }

        public GLContext createContext(GLContext gLContext) {
            return this.pbuffer.createContext(gLContext);
        }

        public void setContext(GLContext gLContext) {
            if (this.pbuffer == null && Beans.isDesignTime()) {
                return;
            }
            this.pbuffer.setContext(gLContext);
        }

        public GLContext getContext() {
            if (this.pbuffer == null && Beans.isDesignTime()) {
                return null;
            }
            return this.pbuffer.getContext();
        }

        public GLDrawable getDrawable() {
            return this.pbuffer;
        }

        public GLCapabilities getChosenGLCapabilities() {
            if (this.pbuffer == null) {
                return null;
            }
            return this.pbuffer.getChosenGLCapabilities();
        }

        public GLProfile getGLProfile() {
            if (this.pbuffer == null) {
                return null;
            }
            return this.pbuffer.getGLProfile();
        }

        public void handleReshape() {
            float f = 2.5f;
            if (GLJPanel.this.panelWidth > this.pbufferWidth || GLJPanel.this.panelHeight > this.pbufferHeight || (float)GLJPanel.this.panelWidth < (float)this.pbufferWidth / f || (float)GLJPanel.this.panelHeight < (float)this.pbufferHeight / f) {
                if (DEBUG) {
                    System.err.println("Resizing pbuffer from (" + this.pbufferWidth + ", " + this.pbufferHeight + ") " + " to fit (" + GLJPanel.this.panelWidth + ", " + GLJPanel.this.panelHeight + ")");
                }
                if (this.pbuffer != null) {
                    try {
                        this.pbuffer.destroy();
                    }
                    catch (GLException gLException) {
                        hardwareAccelerationDisabled = true;
                        GLJPanel.this.backend = null;
                        GLJPanel.this.isInitialized = false;
                        this.readBackWidthInPixels = Math.max(1, GLJPanel.this.panelWidth);
                        this.readBackHeightInPixels = Math.max(1, GLJPanel.this.panelHeight);
                        if (DEBUG) {
                            System.err.println("WARNING: falling back to software rendering due to bugs in OpenGL drivers");
                            gLException.printStackTrace();
                        }
                        GLJPanel.this.createAndInitializeBackend();
                        return;
                    }
                }
                this.pbuffer = null;
                GLJPanel.this.isInitialized = false;
                this.pbufferWidth = GLJPanel.this.getNextPowerOf2(GLJPanel.this.panelWidth);
                this.pbufferHeight = GLJPanel.this.getNextPowerOf2(GLJPanel.this.panelHeight);
                if (DEBUG && !hardwareAccelerationDisabled) {
                    System.err.println("New pbuffer size is (" + this.pbufferWidth + ", " + this.pbufferHeight + ")");
                }
                this.initialize();
            }
            this.readBackWidthInPixels = this.pbufferWidth;
            this.readBackHeightInPixels = GLJPanel.this.panelHeight;
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
        }

        protected void doPaintComponentImpl() {
            this.pbuffer.display();
        }

        protected int getGLPixelType() {
            return 33639;
        }

        protected boolean flipVertically() {
            return true;
        }
    }

    class SoftwareBackend
    extends AbstractReadbackBackend {
        private GLDrawableImpl offscreenDrawable;
        private GLContextImpl offscreenContext;

        SoftwareBackend() {
        }

        public void initialize() {
            this.offscreenDrawable = (GLDrawableImpl)GLJPanel.this.factory.createOffscreenDrawable(GLJPanel.this.offscreenCaps, GLJPanel.this.chooser, Math.max(1, GLJPanel.this.panelWidth), Math.max(1, GLJPanel.this.panelHeight));
            this.offscreenContext = (GLContextImpl)this.offscreenDrawable.createContext(GLJPanel.this.shareWith);
            this.offscreenContext.setSynchronized(true);
            GLJPanel.this.isInitialized = true;
        }

        public void destroy() {
            if (this.offscreenContext != null) {
                this.offscreenContext.destroy();
                this.offscreenContext = null;
            }
            if (this.offscreenDrawable != null) {
                this.offscreenDrawable.destroy();
                this.offscreenDrawable = null;
            }
        }

        public GLContext createContext(GLContext gLContext) {
            return this.offscreenDrawable.createContext(gLContext);
        }

        public void setContext(GLContext gLContext) {
            this.offscreenContext = (GLContextImpl)gLContext;
        }

        public GLContext getContext() {
            return this.offscreenContext;
        }

        public GLDrawable getDrawable() {
            return this.offscreenDrawable;
        }

        public GLCapabilities getChosenGLCapabilities() {
            if (this.offscreenDrawable == null) {
                return null;
            }
            return this.offscreenDrawable.getChosenGLCapabilities();
        }

        public GLProfile getGLProfile() {
            if (this.offscreenDrawable == null) {
                return null;
            }
            return this.offscreenDrawable.getGLProfile();
        }

        public void handleReshape() {
            this.destroy();
            this.initialize();
            this.readBackWidthInPixels = Math.max(1, GLJPanel.this.panelWidth);
            this.readBackHeightInPixels = Math.max(1, GLJPanel.this.panelHeight);
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
        }

        protected void doPaintComponentImpl() {
            GLJPanel.this.drawableHelper.invokeGL((GLDrawable)this.offscreenDrawable, (GLContext)this.offscreenContext, (Runnable)GLJPanel.this.displayAction, (Runnable)GLJPanel.this.initAction);
        }

        protected int getGLPixelType() {
            return this.offscreenContext.getOffscreenContextPixelDataType();
        }

        protected boolean flipVertically() {
            return this.offscreenContext.offscreenImageNeedsVerticalFlip();
        }
    }

    class Updater
    implements GLEventListener {
        private Graphics g;

        Updater() {
        }

        public void setGraphics(Graphics graphics) {
            this.g = graphics;
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            if (!GLJPanel.this.backend.preGL(this.g)) {
                return;
            }
            GLJPanel.this.drawableHelper.init((GLAutoDrawable)GLJPanel.this);
            GLJPanel.this.backend.postGL(this.g, false);
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GLJPanel.this.drawableHelper.dispose((GLAutoDrawable)GLJPanel.this);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            if (!GLJPanel.this.backend.preGL(this.g)) {
                return;
            }
            if (GLJPanel.this.sendReshape) {
                if (DEBUG || VERBOSE) {
                    System.err.println("display: glViewport(" + GLJPanel.this.viewportX + "," + GLJPanel.this.viewportY + " " + GLJPanel.this.panelWidth + "x" + GLJPanel.this.panelHeight + ")");
                }
                GLJPanel.this.getGL().getGL2().glViewport(GLJPanel.this.viewportX, GLJPanel.this.viewportY, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                GLJPanel.this.drawableHelper.reshape((GLAutoDrawable)GLJPanel.this, GLJPanel.this.viewportX, GLJPanel.this.viewportY, GLJPanel.this.panelWidth, GLJPanel.this.panelHeight);
                GLJPanel.this.sendReshape = false;
            }
            GLJPanel.this.drawableHelper.display((GLAutoDrawable)GLJPanel.this);
            GLJPanel.this.backend.postGL(this.g, true);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

