/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractStackholdingLocation;
import bibliothek.gui.dock.common.location.CSplitLocation;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;

public class CRectangleLocation
extends AbstractStackholdingLocation {
    private CSplitLocation parent;
    private double x;
    private double y;
    private double width;
    private double height;

    public CRectangleLocation(CSplitLocation parent, double x, double y, double width, double height) {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public String findRoot() {
        return this.parent.findRoot();
    }

    public CLocation getParent() {
        return this.parent;
    }

    public ExtendedMode findMode() {
        return ExtendedMode.NORMALIZED;
    }

    public DockableProperty findProperty(DockableProperty successor) {
        SplitDockProperty split = new SplitDockProperty(this.x, this.y, this.width, this.height);
        split.setSuccessor(successor);
        if (this.parent != null) {
            return this.parent.findProperty(split);
        }
        return split;
    }

    @Deprecated
    public CLocation aside() {
        return this.stack(1);
    }

    public String toString() {
        return String.valueOf(this.parent) + " [normal " + this.x + " " + this.y + " " + this.width + " " + this.height + "]";
    }
}

