/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppkabaddi.anzeige;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sportdata.setppkabaddi.anzeige.components.ProtestComponent;
import org.sportdata.setppkabaddi.anzeige.constants.MainConstants;
import org.sportdata.setppkabaddi.anzeige.interfaces.ITimer;
import org.sportdata.setppkabaddi.anzeige.ressource.AnzeigeResource;
import org.sportdata.setppkabaddi.anzeige.utils.GrafikDeviceUtils;
import org.sportdata.setppkabaddi.anzeige.utils.License;
import org.sportdata.setppkabaddi.anzeige.version.Version;

public class ProtestClockPanel
extends JFrame
implements ActionListener,
ITimer {
    private static final long serialVersionUID = -1003801023381257450L;
    private JPanel a;
    private ProtestComponent b;
    private JButton c;
    private JLabel d;
    private JButton e;
    private JButton f;
    private int g;
    private JComboBox<String> h;
    private JLabel i;

    public ProtestClockPanel(ProtestComponent clock, int colormode) {
        this.b = clock;
        this.g = colormode;
        String colortitle = "";
        colortitle = colormode == 1 ? "HOME" : "GUEST";
        this.setTitle(colortitle + " Protest - " + Version.getCopyright() + " (" + License.getLicense() + ")");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        if (colormode == 1) {
            this.setBounds((screenSize.width - 300) / 2, (screenSize.height - 520) / 2, 300, 200);
        } else {
            this.setBounds((screenSize.width - 300) / 2, (screenSize.height - 130) / 2, 300, 200);
        }
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initComponent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ProtestClockPanel.this.stopClock();
                ProtestClockPanel.this.a();
            }
        });
        clock.setTimerlabel(this);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.c.requestFocus();
    }

    public void initComponent() {
        this.a = new JPanel();
        this.a.setLayout(new GridLayout(4, 1));
        this.c = new JButton(AnzeigeResource.getResourceString("general.stop"));
        this.c.addActionListener(this);
        this.e = new JButton("");
        this.e.addActionListener(this);
        this.e.setIcon(new ImageIcon("images/tick.png"));
        this.f = new JButton("");
        this.f.addActionListener(this);
        this.f.setIcon(new ImageIcon("images/cancel.png"));
        JLabel ltext = new JLabel("Protest " + AnzeigeResource.getResourceString("general.timer"));
        JPanel pbuttons = new JPanel();
        pbuttons.add(ltext);
        pbuttons.add(this.c);
        pbuttons.add(this.e);
        pbuttons.add(this.f);
        this.d = new JLabel("");
        this.d.setFont(new Font("Dialog", 1, 20));
        if (this.g == 1) {
            this.d.setForeground(MainConstants.AKA_COLOR);
        } else {
            this.d.setForeground(MainConstants.AO_COLOR);
        }
        JPanel ptime = new JPanel();
        ptime.add(this.d);
        this.h = new JComboBox();
        this.h.addItem("");
        this.h.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                ProtestClockPanel.this.b.setValueText(ProtestClockPanel.this.h.getSelectedItem().toString());
            }
        });
        this.i = new JLabel();
        this.i.setHorizontalAlignment(0);
        this.a.add(ptime);
        this.a.add(pbuttons);
        this.a.add(this.i);
        this.add(this.a);
    }

    public void stopClock() {
        this.b.stopClock();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object source = arg0.getSource();
        if (source.equals(this.c)) {
            this.stopClock();
        }
        if (source.equals(this.e)) {
            this.stopClock();
            this.i.setIcon(new ImageIcon("images/protest-pos32.png"));
            if (this.g == 1) {
                this.b.fireAkaPosEvent();
            } else {
                this.b.fireAoPosEvent();
            }
        }
        if (source.equals(this.f)) {
            this.stopClock();
            this.i.setIcon(new ImageIcon("images/protest-neg32.png"));
            if (this.g == 1) {
                this.b.fireAkaNegEvent();
            } else {
                this.b.fireAoNegEvent();
            }
        }
    }

    @Override
    public void updateTimerLabel(String timestring) {
        this.d.setText(timestring);
        this.d.repaint();
    }

    public int getColormode() {
        return this.g;
    }

    public void setColormode(int colormode) {
        this.g = colormode;
    }

    private void a() {
        this.b.closeWindow();
        this.setVisible(false);
        this.dispose();
    }

    public void firePosButton() {
        this.e.doClick();
    }

    public void fireNegButton() {
        this.f.doClick();
    }

    public void setFullScreen() {
        this.b.setExtendedState(6);
    }

    public void setNormalSize() {
        this.b.setExtendedState(0);
    }
}

