/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppkabaddi.anzeige.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.sportdata.setppkabaddi.anzeige.AnzeigeController;
import org.sportdata.setppkabaddi.anzeige.components.Segment7;
import org.sportdata.setppkabaddi.anzeige.constants.MainConstants;
import org.sportdata.setppkabaddi.anzeige.interfaces.IAnzeigeEventListener;
import org.sportdata.setppkabaddi.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppkabaddi.anzeige.sound.AePlayWave;

public class RaidClockComponent
extends JPanel
implements Runnable,
IAnzeigeEventListener {
    private int j = 3;
    private ExecutorService k = Executors.newSingleThreadExecutor();
    private static final long serialVersionUID = -1295753154920288726L;
    DecimalFormat a = new DecimalFormat("0");
    private volatile boolean l;
    long b = 100L;
    private Color m = MainConstants.RAID_TIME_COLOR;
    private long n;
    private long o = this.n = 30000L;
    Segment7 c;
    Segment7 d;
    Segment7 e;
    Segment7 f;
    Segment7 g;
    JLabel h;
    private AnzeigeController p;
    private boolean q;
    private int r = 20;
    private int s = 10;
    private ArrayList<Integer> t = new ArrayList();
    AePlayWave i;

    public RaidClockComponent(Color color, int mode, AnzeigeController acontrol, boolean logging) {
        this.j = mode;
        this.p = acontrol;
        this.q = logging;
        this.checkBackground(true);
        this.setOpaque(true);
        this.setBackground(color);
        this.initComponent();
        this.registerPanel();
        this.setTimeValue();
        this.repaintClock();
    }

    public RaidClockComponent(Color color, int mode, AnzeigeController acontrol, boolean logging, int factor_sec, int factor_ms) {
        this.j = mode;
        this.p = acontrol;
        this.q = logging;
        this.s = factor_ms;
        this.r = factor_sec;
        this.checkBackground(true);
        this.setOpaque(true);
        this.setBackground(color);
        this.initComponent();
        this.registerPanel();
        this.setTimeValue();
        this.repaintClock();
    }

    public void checkBackground(boolean isidle) {
        if (isidle && AnzeigePropertiesHelper.getPpcoloridleothercolor().equals("true")) {
            this.a();
        } else {
            this.m = !AnzeigePropertiesHelper.getBackground().equals("black") ? MainConstants.RAID_TIME_COLOR : MainConstants.RAID_TIME_COLOR;
        }
    }

    private void a() {
        this.m = !AnzeigePropertiesHelper.getBackground().equals("black") ? Color.GRAY : Color.LIGHT_GRAY;
    }

    public void setColor() {
        this.c.setColornofocus(this.m);
        this.d.setColornofocus(this.m);
        this.e.setColornofocus(this.m);
        this.f.setColornofocus(this.m);
        this.h.setForeground(this.m);
        this.g.setColornofocus(this.m);
    }

    @Override
    public void registerPanel() {
        this.p.getListenersImp(this.j).add(this);
    }

    public void initComponent() {
        this.c = new Segment7(0, this.m, this.m, false, false, false, false, this.j, this.r);
        this.d = new Segment7(0, this.m, this.m, false, false, false, false, this.j, this.r);
        this.e = new Segment7(0, this.m, this.m, false, false, false, false, this.j, this.r);
        this.f = new Segment7(0, this.m, this.m, false, false, false, false, this.j, this.r);
        this.g = new Segment7(0, this.m, this.m, false, false, false, false, this.j, this.r);
        this.g.setAddstr(".");
        this.h = new JLabel(":");
        this.h.setHorizontalAlignment(0);
        this.h.setVerticalAlignment(0);
        this.h.setFont(MainConstants.DISPLAY_FONT_AKAAO_TEXT[this.j]);
        this.h.setForeground(this.m);
        this.add(this.e);
        this.add(this.f);
        this.add(this.g);
        this.g.getLtime().setFont(new Font("Dialog", 1, MainConstants.DISPLAY_SEGMENT_MAX_FACTOR[this.j] * this.s));
        this.g.getLtime().setVerticalAlignment(3);
        this.e.getLtime().setVerticalAlignment(3);
        this.f.getLtime().setVerticalAlignment(3);
        TitledBorder tb = new TitledBorder("RAID TIMER"){

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                super.getBorderInsets(c, insets);
                insets.top = RaidClockComponent.this.s / 2;
                return insets;
            }
        };
        tb.setTitleFont(new Font("Dialog", 1, MainConstants.DISPLAY_SEGMENT_MAX_FACTOR[this.j] * this.s / 2));
        tb.setTitleJustification(2);
        tb.setTitlePosition(2);
        tb.setTitleColor(Color.LIGHT_GRAY);
        this.setBorder(tb);
    }

    public void setTime(long seconds) {
        this.o = this.n = seconds;
        this.p.setRaidLasttime(this.o);
    }

    public void reset() {
        this.o = this.n;
        this.setTimeValue();
        this.repaintClock();
    }

    @Override
    public void run() {
        this.l = true;
        this.o = this.p.getRaidLasttime();
        this.checkBackground(false);
        this.setColor();
        this.repaintClock();
        if (this.o == this.n && this.q && this.q) {
            if (this.i != null) {
                this.i.setStop(true);
            }
            try {
                this.i = new AePlayWave("sounds/kabaddi-20sec-audio.wav");
                this.i.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (this.l && this.o > 0L) {
            long systemtime = System.nanoTime();
            try {
                Thread.sleep(this.b);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long systemtimenew = System.nanoTime();
            if (!this.l) continue;
            long lastsecondsact = this.o + 0L;
            this.o -= (systemtimenew - systemtime) / 1000000L;
            if (this.o < 0L) {
                this.o = 0L;
            }
            this.setTimeValue();
            this.repaintClock();
            long cfr_ignored_0 = lastsecondsact / 100L;
            long cfr_ignored_1 = this.o / 100L;
            if (lastsecondsact / 1000L != this.o / 1000L && this.q) {
                this.k.submit(() -> this.p.notifyListeners(214, "" + this.getSecoundsact()));
            }
            if (lastsecondsact < 11000L || this.o >= 11000L || !this.q) continue;
            if (this.i != null) {
                this.i.setStop(true);
            }
            this.p.notifyListeners(217, "" + this.getSecoundsact());
        }
        if (this.i != null) {
            this.i.setStop(true);
        }
        if (this.q) {
            this.p.setRaidLasttime(this.o);
        }
        if (this.o == 0L && this.q) {
            this.p.notifyListeners(219, "" + this.o / 1000L);
        }
        if (this.q) {
            this.p.notifyListeners(218, "" + this.getSecoundsact());
        }
        this.syncTimeDelayed();
        this.checkBackground(true);
        this.setColor();
        this.repaintClock();
    }

    public void stopClock() {
        this.l = false;
    }

    public void setTimeValue() {
        int secondcount = (int)(this.o / 1000L);
        int min2val = secondcount / 600 % 10;
        int minval = secondcount / 60;
        int sek1val = (secondcount - minval * 60) / 10;
        int sek2val = secondcount - minval * 60 - sek1val * 10;
        int sek3val = (int)((this.o - (long)(secondcount * 1000)) / 100L);
        this.d.setValue(min2val);
        this.c.setValue(minval);
        this.e.setValue(sek1val);
        this.f.setValue(sek2val);
        this.g.setValue(sek3val);
    }

    public void repaintClock() {
        this.d.repaint();
        this.c.repaint();
        this.e.repaint();
        this.f.repaint();
        this.g.repaint();
    }

    public int getSecoundsact() {
        if (this.o % 1000L == 0L) {
            return (int)this.o / 1000;
        }
        return (int)(this.o / 1000L + 1L);
    }

    @Override
    public void update(int event, String message) {
        if (event == 205) {
            this.getRaids().add(this.t.size());
            if (this.q) {
                this.p.notifyListeners(208, "RAID TIMER Seconds left:" + this.getSecoundsact());
            }
        }
        if (event == 206 && this.q) {
            this.p.notifyListeners(209, "RAID TIMER Seconds left:" + this.getSecoundsact());
        }
        if (event == 207) {
            this.o = 30000L;
            this.setTime(this.o);
            this.reset();
            if (this.q) {
                this.p.notifyListeners(210, "Seconds left:" + this.getSecoundsact());
            }
        }
        if (event == 44) {
            this.stopClock();
            this.reset();
            this.t.clear();
        }
        if (event == 140) {
            this.stopClock();
            this.reset();
        }
    }

    public boolean isRunningTrue() {
        return this.l;
    }

    public long getSecoundsactNormal() {
        return this.o;
    }

    public String getFormatedDateStringShort() {
        long min = TimeUnit.MILLISECONDS.toMinutes(this.getSecoundsactNormal()) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(this.getSecoundsactNormal()) % 60L;
        String toRet = String.format("%01d:%02d", min, sec);
        return toRet;
    }

    public String getFormatedDateStringShortLong() {
        long min = TimeUnit.MILLISECONDS.toMinutes(this.getSecoundsactNormal()) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(this.getSecoundsactNormal()) % 60L;
        int secondcount = (int)(this.o / 1000L);
        int sek3val = (int)((this.o - (long)(secondcount * 1000)) / 100L);
        String toRet = String.format("%02d:%02d.%01d", min, sec, sek3val);
        if (min < 10L) {
            toRet = String.format("%01d:%02d.%01d", min, sec, sek3val);
        }
        return toRet;
    }

    public static String getFormatedDateStringShort(int seconds) {
        long min = TimeUnit.MILLISECONDS.toMinutes(seconds * 1000) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(seconds * 1000) % 60L;
        String toRet = String.format("%01d:%02d", min, sec);
        return toRet;
    }

    public static String getFormatedDateStringShortMMSS(int seconds) {
        long min = TimeUnit.MILLISECONDS.toMinutes(seconds * 1000) % 60L;
        long sec = TimeUnit.MILLISECONDS.toSeconds(seconds * 1000) % 60L;
        String toRet = String.format("%02d:%02d", min, sec);
        return toRet;
    }

    public void syncTimeDelayed() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (!RaidClockComponent.this.isRunningTrue()) {
                    RaidClockComponent.this.o = RaidClockComponent.this.p.getRaidLasttime();
                    RaidClockComponent.this.setTimeValue();
                    RaidClockComponent.this.checkBackground(true);
                    RaidClockComponent.this.setColor();
                    RaidClockComponent.this.repaintClock();
                    System.out.println("Raid Clock synced " + RaidClockComponent.this.o + " -> " + RaidClockComponent.this.getFormatedDateStringShortLong());
                }
            }
        };
        Timer timer = new Timer("Timer");
        long delay = 500L;
        timer.schedule(task, delay);
    }

    public ArrayList<Integer> getRaids() {
        return this.t;
    }

    public void setRaids(ArrayList<Integer> raids) {
        this.t = raids;
    }
}

