/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppkabaddi.anzeige.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.jdesktop.swingx.JXImagePanel;
import org.sportdata.setppkabaddi.anzeige.AnzeigeController;
import org.sportdata.setppkabaddi.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppkabaddi.anzeige.components.RaidClockComponent;
import org.sportdata.setppkabaddi.anzeige.constants.MainConstants;
import org.sportdata.setppkabaddi.anzeige.interfaces.IAnzeigeEventListener;
import org.sportdata.setppkabaddi.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppkabaddi.anzeige.utils.GrafikDeviceUtils;

public class RaidClockComponentBig
extends JFrame
implements MouseListener,
Runnable,
IAnzeigeEventListener {
    private static final long serialVersionUID = 1846280461585575889L;
    public static Color color = MainConstants.BACK_COLOR;
    int a = 3;
    RaidClockComponent b;
    private boolean d;
    private AnzeigeController e;
    private Thread f = new Thread();
    private String g;
    JXImagePanel c = new JXImagePanel();

    public RaidClockComponentBig(AnzeigeController acontrol, int mode, String title, boolean logging) {
        this.a = mode;
        this.e = acontrol;
        this.d = logging;
        this.g = title;
        this.checkBackground();
        this.setTitle(title);
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        this.setBounds((screenSize.width - MainConstants.DISPLAY_WITH[mode]) / 2, (screenSize.height - MainConstants.DISPLAY_HEIGHT[mode]) / 2, MainConstants.DISPLAY_WITH[mode], MainConstants.DISPLAY_HEIGHT[mode]);
        GrafikDeviceUtils.setExternalDeviceBounds(this);
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.setBackground(color);
        this.setDefaultCloseOperation(0);
        this.getContentPane().addMouseListener(this);
        this.initComponents();
        this.setUndecorated(true);
        this.setVisible(true);
        this.registerPanel();
        this.checkDisplayGraphicDevice2();
    }

    public void checkBackground() {
        color = !AnzeigePropertiesHelper.getBackground().equals("black") ? MainConstants.BACK_COLOR_WHITE : MainConstants.BACK_COLOR;
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        this.b = new RaidClockComponent(color, this.a, this.e, this.d, 70, 40);
        this.add((Component)this.b, "Center");
        this.add((Component)this.c, "South");
        this.c.setOpaque(true);
        this.c.setBackground(color);
        this.c.setStyle(JXImagePanel.Style.SCALED_KEEP_ASPECT_RATIO);
        this.setLogo();
    }

    @Override
    public void registerPanel() {
        this.e.getListenersImp(this.a).add(this);
    }

    public void runRaidClock() {
        if (!this.f.isAlive()) {
            this.f = new Thread((Runnable)this.b, "RaidClock");
            this.f.start();
        } else if (!this.b.isRunningTrue()) {
            while (this.f.isAlive()) {
            }
            this.f = new Thread((Runnable)this.b, "RaidClock");
            this.f.start();
        }
    }

    public void stopRaidClock() {
        this.b.stopClock();
    }

    public void setLogo() {
        this.c.setPreferredSize(new Dimension(0, MainConstants.DISPLAY_FONT_MATCHES_ROUND[this.a].getSize()));
        if (!AnzeigeMaster.getInstance().isIsembedded()) {
            this.c.setVisible(true);
            try {
                byte[] decodedBytes = Base64.getDecoder().decode("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");
                BufferedImage img = null;
                try {
                    img = ImageIO.read(new ByteArrayInputStream(decodedBytes));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                MediaTracker mt2 = new MediaTracker(this);
                mt2.addImage(img, 0);
                try {
                    mt2.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.c.setImage((Image)img);
                this.c.setStyle(JXImagePanel.Style.SCALED_KEEP_ASPECT_RATIO);
            }
            catch (Exception e) {
                this.c.setImage(null);
                this.c.setVisible(false);
            }
        } else if (!AnzeigePropertiesHelper.getPplogo().equals("")) {
            try {
                this.c.setVisible(true);
                Image img = this.getToolkit().getImage(AnzeigePropertiesHelper.getPplogo());
                MediaTracker mt = new MediaTracker(this);
                mt.addImage(img, 0);
                try {
                    mt.waitForAll();
                }
                catch (InterruptedException mt2) {
                    // empty catch block
                }
                this.c.setImage(img);
                this.c.setStyle(JXImagePanel.Style.SCALED_KEEP_ASPECT_RATIO);
            }
            catch (Exception e) {
                this.c.setImage(null);
                this.c.setVisible(false);
            }
        } else {
            this.c.setVisible(true);
            try {
                byte[] decodedBytes = Base64.getDecoder().decode("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");
                BufferedImage img = null;
                try {
                    img = ImageIO.read(new ByteArrayInputStream(decodedBytes));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                MediaTracker mt = new MediaTracker(this);
                mt.addImage(img, 0);
                try {
                    mt.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.c.setImage((Image)img);
                this.c.setStyle(JXImagePanel.Style.SCALED_KEEP_ASPECT_RATIO);
            }
            catch (Exception e) {
                this.c.setImage(null);
                this.c.setVisible(false);
            }
        }
    }

    @Override
    public void update(int event, String message) {
        if (event == 205) {
            this.runRaidClock();
        }
        if (event == 206) {
            this.stopRaidClock();
        }
        if (event == 132) {
            this.setLogo();
        }
    }

    @Override
    public void run() {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (this.isUndecorated()) {
            this.setVisible(false);
            this.dispose();
            this.setUndecorated(false);
            this.setVisible(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void updateDisplayGraphicDevice2() {
        boolean founddevice = false;
        founddevice = GrafikDeviceUtils.setExternalDeviceBounds(this, AnzeigePropertiesHelper.getSetppExtgraphicdeviceMainpointpanel2());
        if (!founddevice) {
            GrafikDeviceUtils.setExternalDeviceBounds(this);
        }
    }

    public void checkDisplayGraphicDevice2() {
        boolean founddevice = false;
        if (!AnzeigePropertiesHelper.getSetppExtgraphicdeviceMainpointpanel2().trim().equals("")) {
            founddevice = GrafikDeviceUtils.setExternalDeviceBounds(this, AnzeigePropertiesHelper.getSetppExtgraphicdeviceMainpointpanel2());
        }
        if (founddevice) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }
}

