/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.swing;

import javax.swing.JPanel;
import net.java.truelicense.core.LicenseConsumerManager;
import net.java.truelicense.core.LicenseManagementException;
import net.java.truelicense.core.util.Objects;
import net.java.truelicense.swing.LicenseWizard;
import net.java.truelicense.ui.LicenseWizardMessage;
import net.java.truelicense.ui.LicenseWizardState;
import net.java.truelicense.ui.wizard.WizardView;

abstract class LicensePanel
extends JPanel
implements WizardView<LicenseWizardState> {
    private final LicenseWizard wizard;

    LicensePanel(LicenseWizard licenseWizard) {
        this.wizard = (LicenseWizard)Objects.requireNonNull((Object)licenseWizard);
    }

    final LicenseWizard wizard() {
        return this.wizard;
    }

    LicenseConsumerManager manager() {
        return this.wizard().manager();
    }

    final String subject() {
        return this.manager().subject();
    }

    final String format(LicenseWizardMessage licenseWizardMessage) {
        return licenseWizardMessage.format(new Object[]{this.subject()}).toString();
    }

    public LicenseWizardState backState() {
        return LicenseWizardState.welcome;
    }

    public LicenseWizardState nextState() {
        try {
            this.manager().verify();
            return LicenseWizardState.display;
        }
        catch (LicenseManagementException licenseManagementException) {
            return LicenseWizardState.install;
        }
    }

    final boolean licenseInstalled() {
        try {
            this.manager().view();
            return true;
        }
        catch (LicenseManagementException licenseManagementException) {
            return false;
        }
    }

    public void onBeforeStateSwitch() {
    }

    public void onAfterStateSwitch() {
    }
}

