/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridCellEditor;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridVirtualFlow;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import impl.org.controlsfx.spreadsheet.HorizontalPicker;
import impl.org.controlsfx.spreadsheet.RectangleSelection;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.SpreadsheetViewSelectionModel;
import impl.org.controlsfx.spreadsheet.VerticalHeader;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridViewSkin
extends TableViewSkin<ObservableList<SpreadsheetCell>> {
    public static final double DEFAULT_CELL_HEIGHT;
    private static final double DATE_CELL_MIN_WIDTH;
    final Map<GridRow, Set<CellView>> deportedCells = new HashMap<GridRow, Set<CellView>>();
    ObservableMap<Integer, Double> rowHeightMap = FXCollections.observableHashMap();
    private GridCellEditor gridCellEditor;
    protected final SpreadsheetHandle handle;
    protected SpreadsheetView spreadsheetView;
    protected VerticalHeader verticalHeader;
    protected HorizontalPicker horizontalPickers;
    private ObservableSet<Integer> currentlyFixedRow = FXCollections.observableSet(new HashSet());
    private final ObservableList<Integer> selectedRows = FXCollections.observableArrayList();
    private final ObservableList<Integer> selectedColumns = FXCollections.observableArrayList();
    private double fixedRowHeight = 0.0;
    BitSet hBarValue;
    BitSet rowToLayout;
    RectangleSelection rectangleSelection;
    double fixedColumnWidth;
    private final InvalidationListener vbarValueListener = new InvalidationListener(){

        public void invalidated(Observable valueModel) {
            GridViewSkin.this.verticalScroll();
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> c) {
            GridViewSkin.this.hBarValue.clear();
            while (c.next()) {
                if (c.wasPermutated()) {
                    for (Integer fixedRow : c.getList()) {
                        GridViewSkin.this.rowToLayout.set((int)fixedRow, true);
                    }
                    continue;
                }
                block2: for (Integer unfixedRow : c.getRemoved()) {
                    GridViewSkin.this.rowToLayout.set((int)unfixedRow, false);
                    if (GridViewSkin.this.spreadsheetView.getGrid().getRows().size() <= unfixedRow) continue;
                    List myRow = (List)GridViewSkin.this.spreadsheetView.getGrid().getRows().get(unfixedRow.intValue());
                    for (SpreadsheetCell cell : myRow) {
                        if (cell.getRowSpan() <= 1 && cell.getColumnSpan() <= 1) continue;
                        GridViewSkin.this.rowToLayout.set((int)unfixedRow, true);
                        continue block2;
                    }
                }
                for (Integer fixedRow : c.getAddedSubList()) {
                    GridViewSkin.this.rowToLayout.set((int)fixedRow, true);
                }
            }
            GridViewSkin.this.getFlow().layoutTotal();
        }
    };
    private final SetChangeListener<? super Integer> currentlyFixedRowListener = new SetChangeListener<Integer>(){

        public void onChanged(SetChangeListener.Change<? extends Integer> arg0) {
            GridViewSkin.this.computeFixedRowHeight();
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> c) {
            GridViewSkin.this.hBarValue.clear();
            GridViewSkin.this.getFlow().layoutTotal();
        }
    };

    public GridViewSkin(final SpreadsheetHandle handle) {
        super((TableView)handle.getGridView());
        this.handle = handle;
        this.spreadsheetView = handle.getView();
        this.gridCellEditor = new GridCellEditor(handle);
        SpreadsheetGridView tableView = handle.getGridView();
        tableView.setRowFactory((Callback)new Callback<TableView<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>>(){

            public TableRow<ObservableList<SpreadsheetCell>> call(TableView<ObservableList<SpreadsheetCell>> p) {
                return new GridRow(handle);
            }
        });
        tableView.getStyleClass().add((Object)"cell-spreadsheet");
        this.getCurrentlyFixedRow().addListener(this.currentlyFixedRowListener);
        this.spreadsheetView.getFixedRows().addListener(this.fixedRowsListener);
        this.spreadsheetView.getFixedColumns().addListener(this.fixedColumnsListener);
        this.init();
        handle.getView().gridProperty().addListener((ChangeListener)new ChangeListener<Grid>(){

            public void changed(ObservableValue<? extends Grid> ov, Grid t, Grid t1) {
                GridViewSkin.this.rowToLayout = GridViewSkin.this.initRowToLayoutBitSet();
            }
        });
        this.hBarValue = new BitSet(handle.getView().getGrid().getRowCount());
        this.rowToLayout = this.initRowToLayoutBitSet();
        this.computeFixedRowHeight();
    }

    public double getRowHeight(int row) {
        Double rowHeight = (Double)this.rowHeightMap.get((Object)row);
        return rowHeight == null ? this.handle.getView().getGrid().getRowHeight(row) : rowHeight.doubleValue();
    }

    public double getFixedRowHeight() {
        return this.fixedRowHeight;
    }

    public ObservableList<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public ObservableList<Integer> getSelectedColumns() {
        return this.selectedColumns;
    }

    public GridCellEditor getSpreadsheetCellEditorImpl() {
        return this.gridCellEditor;
    }

    public GridRow getRowIndexed(int index) {
        for (GridRow obj : this.getFlow().getCells()) {
            if (obj.getIndex() != index) continue;
            return obj;
        }
        return null;
    }

    public GridRow getRow(int index) {
        return (GridRow)((Object)this.getFlow().getCells().get(index));
    }

    public final boolean containsRow(int index) {
        for (Object obj : this.getFlow().getCells()) {
            if (((GridRow)((Object)obj)).getIndex() != index) continue;
            return true;
        }
        return false;
    }

    public int getCellsSize() {
        return this.getFlow().getCells().size();
    }

    public VirtualScrollBar getHBar() {
        return this.getFlow().getHorizontalBar();
    }

    public VirtualScrollBar getVBar() {
        return this.getFlow().getVerticalBar();
    }

    public void resizeRowsToFitContent() {
        Node n;
        if (((TableView)this.getSkinnable()).getColumns().isEmpty()) {
            return;
        }
        TableColumn col = (TableColumn)((TableView)this.getSkinnable()).getColumns().get(0);
        List items = (List)this.itemsProperty().get();
        if (items == null || items.isEmpty()) {
            return;
        }
        Callback cellFactory = col.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        CellView cell = (CellView)((Object)cellFactory.call((Object)col));
        if (cell == null) {
            return;
        }
        cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
        double padding = 10.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedTopInset() + r.snappedBottomInset();
        }
        int maxRows = this.handle.getView().getGrid().getRowCount();
        for (int row = 0; row < maxRows; ++row) {
            double maxHeight = 0.0;
            for (TableColumn column : ((TableView)this.getSkinnable()).getColumns()) {
                cell.updateTableColumn(column);
                cell.updateTableView(this.handle.getGridView());
                cell.updateIndex(row);
                if ((cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
                this.getChildren().add((Object)cell);
                cell.setWrapText(true);
                cell.impl_processCSS(false);
                maxHeight = Math.max(maxHeight, cell.prefHeight(col.getWidth()));
                this.getChildren().remove((Object)cell);
            }
            this.rowHeightMap.put((Object)row, (Object)(maxHeight + padding));
        }
    }

    public void resizeRowsToMaximum() {
        this.resizeRowsToFitContent();
        double maxHeight = 0.0;
        Iterator iterator = this.rowHeightMap.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            maxHeight = Math.max(maxHeight, (Double)this.rowHeightMap.get((Object)key));
        }
        this.rowHeightMap.clear();
        int maxRows = this.handle.getView().getGrid().getRowCount();
        for (int row = 0; row < maxRows; ++row) {
            this.rowHeightMap.put((Object)row, (Object)maxHeight);
        }
    }

    public void resizeRowsToDefault() {
        this.rowHeightMap.clear();
        for (GridRow row : this.getFlow().getCells()) {
            double newHeight = row.computePrefHeight(-1.0);
            if (row.getPrefHeight() == newHeight) continue;
            row.setPrefHeight(newHeight);
            row.requestLayout();
        }
        this.getFlow().layoutChildren();
    }

    public void resizeColumnToFitContent(TableColumn<ObservableList<SpreadsheetCell>, ?> tc, int maxRows) {
        Node n;
        TableColumn<ObservableList<SpreadsheetCell>, ?> col = tc;
        List items = (List)this.itemsProperty().get();
        if (items == null || items.isEmpty()) {
            return;
        }
        Callback cellFactory = col.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        TableCell cell = (TableCell)cellFactory.call(col);
        if (cell == null) {
            return;
        }
        int indexColumn = this.handle.getGridView().getColumns().indexOf(tc);
        cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
        double padding = 10.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedLeftInset() + r.snappedRightInset();
        }
        ObservableList<ObservableList<SpreadsheetCell>> gridRows = this.spreadsheetView.getGrid().getRows();
        int rows = maxRows == -1 ? items.size() : Math.min(items.size(), maxRows);
        double maxWidth = 0.0;
        boolean datePresent = false;
        for (int row = 0; row < rows; ++row) {
            cell.updateTableColumn(col);
            cell.updateTableView((TableView)this.handle.getGridView());
            cell.updateIndex(row);
            if ((cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
            this.getChildren().add((Object)cell);
            if (((SpreadsheetCell)cell.getItem()).getItem() instanceof LocalDate) {
                datePresent = true;
            }
            cell.impl_processCSS(false);
            double width = cell.prefWidth(-1.0);
            SpreadsheetCell spc = (SpreadsheetCell)((ObservableList)gridRows.get(row)).get(indexColumn);
            if (spc.getColumnSpan() > 1 && spc.getColumn() == indexColumn) {
                for (int i = 1; i < spc.getColumnSpan(); ++i) {
                    width -= ((SpreadsheetColumn)this.spreadsheetView.getColumns().get(indexColumn + i)).getWidth();
                }
            }
            maxWidth = Math.max(maxWidth, width);
            this.getChildren().remove((Object)cell);
        }
        cell.updateIndex(-1);
        double widthMax = maxWidth + padding;
        if (this.handle.getGridView().getColumnResizePolicy() == TableView.CONSTRAINED_RESIZE_POLICY) {
            widthMax = Math.max(widthMax, col.getWidth());
        }
        if (datePresent && widthMax < DATE_CELL_MIN_WIDTH) {
            widthMax = DATE_CELL_MIN_WIDTH;
        }
        if (col.isResizable()) {
            col.setPrefWidth(widthMax);
        }
    }

    protected final void init() {
        this.rectangleSelection = new RectangleSelection(this, (SpreadsheetViewSelectionModel)this.spreadsheetView.getSelectionModel());
        this.getFlow().getVerticalBar().valueProperty().addListener(this.vbarValueListener);
        this.verticalHeader = new VerticalHeader(this.handle);
        this.getChildren().add((Object)this.verticalHeader);
        ((HorizontalHeader)this.getTableHeaderRow()).init();
        this.verticalHeader.init(this, (HorizontalHeader)this.getTableHeaderRow());
        this.horizontalPickers = new HorizontalPicker((HorizontalHeader)this.getTableHeaderRow(), this.spreadsheetView);
        this.getChildren().add((Object)this.horizontalPickers);
        this.getFlow().init(this.spreadsheetView);
    }

    protected final ObservableSet<Integer> getCurrentlyFixedRow() {
        return this.currentlyFixedRow;
    }

    void resize(TableColumnBase<?, ?> tc) {
        this.resizeColumnToFitContent((TableColumn)this.getColumns().get(this.getColumns().indexOf(tc)), -1);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double horizontalPickerHeight;
        if (this.spreadsheetView == null) {
            return;
        }
        double verticalHeaderWidth = this.verticalHeader.computeHeaderWidth();
        double d = horizontalPickerHeight = this.spreadsheetView.getColumnPickers().isEmpty() ? 0.0 : 16.0;
        if (this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) {
            x += verticalHeaderWidth;
            w -= verticalHeaderWidth;
        }
        super.layoutChildren(x, y += horizontalPickerHeight, w, h - horizontalPickerHeight);
        double baselineOffset = ((TableView)this.getSkinnable()).getLayoutBounds().getHeight() / 2.0;
        double tableHeaderRowHeight = 0.0;
        if (!this.spreadsheetView.getColumnPickers().isEmpty()) {
            this.layoutInArea((Node)this.horizontalPickers, x, y - 16.0, w, tableHeaderRowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
        }
        if (this.spreadsheetView.showColumnHeaderProperty().get()) {
            tableHeaderRowHeight = this.getTableHeaderRow().prefHeight(-1.0);
            this.layoutInArea((Node)this.getTableHeaderRow(), x, y, w, tableHeaderRowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
            y += tableHeaderRowHeight;
        }
        if (this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) {
            this.layoutInArea((Node)this.verticalHeader, x - verticalHeaderWidth, y - tableHeaderRowHeight, w, h, baselineOffset, HPos.CENTER, VPos.CENTER);
        }
    }

    protected void onFocusPreviousCell() {
        TableView.TableViewFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int row = fm.getFocusedIndex();
        if (!this.getFlow().getCells().isEmpty() && ((IndexedCell)this.getFlow().getCells().get(this.spreadsheetView.getFixedRows().size())).getIndex() > row && !this.spreadsheetView.getFixedRows().contains((Object)row)) {
            this.flow.scrollTo(row);
        } else {
            this.flow.show(row);
        }
        this.scrollHorizontally();
    }

    protected void onFocusNextCell() {
        TableView.TableViewFocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        int row = fm.getFocusedIndex();
        if (!this.getFlow().getCells().isEmpty() && ((IndexedCell)this.getFlow().getCells().get(this.spreadsheetView.getFixedRows().size())).getIndex() > row && !this.spreadsheetView.getFixedRows().contains((Object)row)) {
            this.flow.scrollTo(row);
        } else {
            this.flow.show(row);
        }
        this.scrollHorizontally();
    }

    protected void onSelectPreviousCell() {
        super.onSelectPreviousCell();
        this.scrollHorizontally();
    }

    protected void onSelectNextCell() {
        super.onSelectNextCell();
        this.scrollHorizontally();
    }

    protected VirtualFlow<TableRow<ObservableList<SpreadsheetCell>>> createVirtualFlow() {
        return new GridVirtualFlow<TableRow<ObservableList<SpreadsheetCell>>>(this);
    }

    protected TableHeaderRow createTableHeaderRow() {
        return new HorizontalHeader(this);
    }

    BooleanProperty getTableMenuButtonVisibleProperty() {
        return this.tableMenuButtonVisibleProperty();
    }

    protected void scrollHorizontally(TableColumn<ObservableList<SpreadsheetCell>, ?> col) {
        double newPos;
        TableColumnBase c;
        if (col == null || !col.isVisible()) {
            return;
        }
        double start = 0.0;
        Iterator iterator = this.getVisibleLeafColumns().iterator();
        while (iterator.hasNext() && !(c = (TableColumnBase)iterator.next()).equals(col)) {
            start += c.getWidth();
        }
        double fixedColumnWidth = this.getFixedColumnWidth();
        double end = start + col.getWidth();
        double headerWidth = ((TableView)this.getSkinnable()).getWidth() - this.snappedLeftInset() - this.snappedRightInset();
        double pos = this.getFlow().getHorizontalBar().getValue();
        double max = this.getFlow().getHorizontalBar().getMax();
        if (start < pos + fixedColumnWidth && start >= 0.0 && start >= fixedColumnWidth) {
            newPos = start - fixedColumnWidth < 0.0 ? start : start - fixedColumnWidth;
        } else {
            double delta = start < 0.0 || end > headerWidth ? start - pos - fixedColumnWidth : 0.0;
            newPos = pos + delta > max ? max : pos + delta;
        }
        this.getFlow().getHorizontalBar().setValue(newPos);
    }

    private void verticalScroll() {
        this.verticalHeader.requestLayout();
    }

    GridVirtualFlow<?> getFlow() {
        return (GridVirtualFlow)this.flow;
    }

    private BitSet initRowToLayoutBitSet() {
        Grid grid = this.handle.getView().getGrid();
        BitSet bitSet = new BitSet(grid.getRowCount());
        block0: for (int row = 0; row < grid.getRowCount(); ++row) {
            if (this.spreadsheetView.getFixedRows().contains((Object)row)) {
                bitSet.set(row);
                continue;
            }
            List myRow = (List)grid.getRows().get(row);
            for (SpreadsheetCell cell : myRow) {
                if (cell.getRowSpan() <= 1) continue;
                bitSet.set(row);
                continue block0;
            }
        }
        return bitSet;
    }

    private void computeFixedRowHeight() {
        this.fixedRowHeight = 0.0;
        Iterator iterator = this.getCurrentlyFixedRow().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.fixedRowHeight += this.getRowHeight(i);
        }
    }

    private double getFixedColumnWidth() {
        double fixedColumnWidth = 0.0;
        if (!this.spreadsheetView.getFixedColumns().isEmpty()) {
            int max = this.spreadsheetView.getFixedColumns().size();
            for (int i = 0; i < max; ++i) {
                TableColumn c = this.getVisibleLeafColumn(i);
                fixedColumnWidth += c.getWidth();
            }
        }
        return fixedColumnWidth;
    }

    static {
        StyleManager.getInstance().addUserAgentStylesheet(SpreadsheetView.class.getResource("spreadsheet.css").toExternalForm());
        DATE_CELL_MIN_WIDTH = 200.0 - Screen.getPrimary().getDpi();
        double cell_size = 24.0;
        try {
            Class<CellSkinBase> clazz = CellSkinBase.class;
            Field f = clazz.getDeclaredField("DEFAULT_CELL_SIZE");
            f.setAccessible(true);
            cell_size = f.getDouble(null);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        DEFAULT_CELL_HEIGHT = cell_size;
    }
}

