/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools.rectangle.change;

import impl.org.controlsfx.tools.rectangle.Rectangles2D;
import impl.org.controlsfx.tools.rectangle.change.AbstractRatioRespectingChangeStrategy;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

abstract class AbstractFixedPointChangeStrategy
extends AbstractRatioRespectingChangeStrategy {
    private Point2D fixedCorner;

    protected AbstractFixedPointChangeStrategy(boolean ratioFixed, double ratio) {
        super(ratioFixed, ratio);
    }

    protected abstract Point2D getFixedCorner();

    private final Rectangle2D createFromCorners(Point2D point) {
        if (this.isRatioFixed()) {
            return Rectangles2D.forDiagonalCornersAndRatio(this.fixedCorner, point, this.getRatio());
        }
        return Rectangles2D.forDiagonalCorners(this.fixedCorner, point);
    }

    @Override
    protected final Rectangle2D doBegin(Point2D point) {
        this.fixedCorner = this.getFixedCorner();
        return this.createFromCorners(point);
    }

    @Override
    protected Rectangle2D doContinue(Point2D point) {
        return this.createFromCorners(point);
    }

    @Override
    protected final Rectangle2D doEnd(Point2D point) {
        Rectangle2D newRectangle = this.createFromCorners(point);
        this.fixedCorner = null;
        return newRectangle;
    }
}

