/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eula;

import com.sun.javafx.eula.EulaLicense;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class EulaDialog {
    private static final ResourceBundle locale = ResourceBundle.getBundle("com.sun.javafx.eula.Resources");
    private final JDialog root;
    private final JPanel main;
    private boolean eulaAccepted = false;
    private static Point point = new Point();
    static final String SYSTEM_FONT_NAME = EulaDialog.isMacOS() ? "Helvetica" : "MS SansSerif";
    private JButton accept_btn;

    private static boolean isMacOS() {
        Boolean accepted = Boolean.FALSE;
        try {
            accepted = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String os = System.getProperty("os.name").toLowerCase();
                    if (os.startsWith("mac")) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return accepted;
    }

    void setEulaAccepted(boolean accepted) {
        this.eulaAccepted = accepted;
    }

    static JPanel getBackgroundPanel() {
        return new JPanel(new BorderLayout()){
            URL imageURL = Thread.currentThread().getContextClassLoader().getResource("com/sun/javafx/eula/eulabox_bkdg.png");
            ImageIcon image = new ImageIcon(this.imageURL);

            public void paintComponent(Graphics g) {
                Dimension d = this.getSize();
                for (int x = 0; x < d.width; x += this.image.getIconWidth()) {
                    for (int y = 0; y < d.height; y += this.image.getIconHeight()) {
                        g.drawImage(this.image.getImage(), x, y, null, null);
                    }
                }
            }
        };
    }

    EulaDialog() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.main = EulaDialog.getBackgroundPanel();
        this.root = new JDialog();
        EmptyBorder margin = new EmptyBorder(15, 120, 20, 25);
        this.main.setBorder(margin);
        this.main.setPreferredSize(new Dimension(509, 300));
        this.main.add((Component)EulaDialog.init_title_Panel(), "North");
        this.main.add((Component)this.init_control_area(), "Center");
        this.main.add((Component)this.init_button_Panel(), "South");
        this.main.setFocusable(false);
        this.root.setUndecorated(true);
        this.root.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                point.x = e.getX();
                point.y = e.getY();
            }
        });
        this.root.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = EulaDialog.this.root.getLocation();
                EulaDialog.this.root.setLocation(p.x + e.getX() - point.x, p.y + e.getY() - point.y);
            }
        });
        this.root.getContentPane().add((Component)this.main, "Center");
        this.root.setModal(true);
        this.root.setDefaultCloseOperation(2);
        this.root.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EulaDialog.this.root.setVisible(false);
                EulaDialog.this.disposeDialog();
            }
        });
        this.root.pack();
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dd = this.root.getSize();
        this.root.setLocation((sd.width - dd.width) / 2, (sd.height - dd.height) / 2);
        this.accept_btn.requestFocus();
        this.root.setVisible(true);
    }

    private JPanel init_button_Panel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        JButton cancel_btn = new JButton(locale.getString("CancelBtn"));
        cancel_btn.setMnemonic(67);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                EulaDialog.this.root.setVisible(false);
                EulaDialog.this.disposeDialog();
            }
        };
        cancel_btn.addActionListener(cancelAction);
        this.accept_btn = new JButton(locale.getString("AcceptBtn"));
        this.accept_btn.setMnemonic(65);
        this.accept_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EulaDialog.this.setEulaAccepted(true);
                EulaDialog.this.root.setVisible(false);
                EulaDialog.this.disposeDialog();
            }
        });
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(Box.createHorizontalGlue());
        if (EulaDialog.isMacOS()) {
            buttonPanel.add(cancel_btn);
            buttonPanel.add(Box.createHorizontalStrut(10));
            buttonPanel.add(this.accept_btn);
        } else {
            buttonPanel.add(this.accept_btn);
            buttonPanel.add(Box.createHorizontalStrut(10));
            buttonPanel.add(cancel_btn);
        }
        this.accept_btn.setAlignmentX(0.5f);
        buttonPanel.add(Box.createVerticalStrut(10));
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.root.getRootPane().getInputMap(2).put(esc, "cancel");
        this.root.getRootPane().getActionMap().put("cancel", cancelAction);
        return buttonPanel;
    }

    static JPanel init_title_Panel() {
        JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0));
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(locale.getString("EulaTitle"));
        Font f = new Font(SYSTEM_FONT_NAME, 1, 13);
        titleLabel.setFont(f);
        titleLabel.setFocusable(false);
        titlePanel.add(titleLabel);
        titlePanel.setFocusable(false);
        return titlePanel;
    }

    private JComponent init_control_area() {
        JPanel lower_left = new JPanel(new BorderLayout());
        lower_left.setOpaque(false);
        JEditorPane emptyLabel = new JEditorPane();
        EmptyBorder fxLabelBorder = new EmptyBorder(10, 0, 0, 0);
        emptyLabel.setBorder(fxLabelBorder);
        emptyLabel.setContentType("text/html");
        emptyLabel.setEditable(false);
        emptyLabel.setOpaque(false);
        emptyLabel.setText(locale.getString("EulaMessage"));
        if (emptyLabel.getDocument() instanceof HTMLDocument) {
            HTMLDocument document = (HTMLDocument)emptyLabel.getDocument();
            document.getStyleSheet().addRule("a { color:black; }");
        }
        final ResourceBundle locale = ResourceBundle.getBundle("com.sun.javafx.eula.Resources");
        emptyLabel.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String eventString = event.getURL().toString();
                    if ("1.6.0".compareTo(System.getProperty("java.version")) <= 0) {
                        if (eventString.equals("http://java.com/license") || eventString.equals("http://java.com/javafx")) {
                            EulaDialog.this.browse(eventString);
                        }
                    } else if (eventString.equals("http://java.com/license")) {
                        new EulaLicense(EulaDialog.this.root, locale);
                    }
                }
            }
        });
        AbstractAction enterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                if ("1.6.0".compareTo(System.getProperty("java.version")) <= 0) {
                    EulaDialog.this.browse("http://java.com/license");
                } else {
                    new EulaLicense(EulaDialog.this.root, locale);
                }
            }
        };
        emptyLabel.setPreferredSize(new Dimension(330, 210));
        emptyLabel.setHighlighter(null);
        emptyLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                point.x = e.getX();
                point.y = e.getY();
            }
        });
        emptyLabel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = EulaDialog.this.root.getLocation();
                EulaDialog.this.root.setLocation(p.x + e.getX() - point.x, p.y + e.getY() - point.y);
            }
        });
        emptyLabel.setFocusable(false);
        lower_left.add((Component)emptyLabel, "North");
        lower_left.setFocusable(true);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        lower_left.getInputMap(2).put(enter, "enter");
        lower_left.getActionMap().put("enter", enterAction);
        return lower_left;
    }

    private void browse(String urlString) {
        Class<?> desktopClass = null;
        try {
            desktopClass = Class.forName("java.awt.Desktop");
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        Method idsMeth = null;
        try {
            idsMeth = desktopClass.getMethod("isDesktopSupported", null);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        try {
            if (!((Boolean)idsMeth.invoke(null, new Object[0])).booleanValue()) {
                return;
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        Method gdMeth = null;
        try {
            gdMeth = desktopClass.getMethod("getDesktop", null);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        Object desktopObj = null;
        try {
            desktopObj = gdMeth.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        if (desktopObj == null) {
            return;
        }
        Method browseMeth = null;
        try {
            browseMeth = desktopObj.getClass().getMethod("browse", URI.class);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        try {
            URI uri = new URI(urlString);
            Object[] arglist2 = new Object[]{uri};
            browseMeth.invoke(desktopObj, arglist2);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private boolean getEulaAccepted() {
        return this.eulaAccepted;
    }

    private void disposeDialog() {
        this.root.dispose();
    }

    public static boolean askUserAcceptEULA() {
        final boolean[] eulaResult = new boolean[1];
        Runnable runner = new Runnable(){

            public void run() {
                EulaDialog eula = new EulaDialog();
                eulaResult[0] = eula.getEulaAccepted();
                eula.disposeDialog();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (Exception e) {
                eulaResult[0] = false;
            }
        }
        return eulaResult[0];
    }

    public static void main(String[] args) {
        System.out.println("EULA result: " + EulaDialog.askUserAcceptEULA());
    }
}

