/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eula;

import com.sun.javafx.eula.EulaDialog;
import com.sun.javafx.eula.Ping;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.runtime.eula.Eula;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.jnlp.DownloadService;
import javax.jnlp.ServiceManager;

public class EulaImpl
implements Eula {
    private static final String EULA_ACCEPTED_FILENAME = ".javafx_eula_accepted";
    private static Boolean isCommandLine = null;

    static String getHomeDirectory() {
        String os = System.getProperty("os.name").toLowerCase();
        StringBuffer filepath = new StringBuffer(System.getProperty("user.home"));
        if (os.indexOf("vista") != -1) {
            filepath.append(File.separator);
            filepath.append("appdata");
            filepath.append(File.separator);
            filepath.append("locallow");
        } else if (os.startsWith("mac")) {
            filepath.append(File.separator);
            filepath.append("Library");
            filepath.append(File.separator);
            filepath.append("Preferences");
        }
        filepath.append(File.separator);
        return filepath.toString();
    }

    private static boolean isCommandLine() {
        if (isCommandLine == null) {
            isCommandLine = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SystemProperties.getProperty((String)"javafx.runtime.isApplet") != null) {
                        return Boolean.FALSE;
                    }
                    try {
                        Class.forName("javax.jnlp.BasicService");
                        return Boolean.FALSE;
                    }
                    catch (ClassNotFoundException cnfe) {
                        return Boolean.TRUE;
                    }
                }
            });
        }
        return isCommandLine;
    }

    private static String getEULAAcceptedFilePath() {
        StringBuffer filepath = new StringBuffer(EulaImpl.getHomeDirectory());
        filepath.append(EULA_ACCEPTED_FILENAME);
        return filepath.toString();
    }

    private static boolean isEULAAlreadyAccepted() {
        Boolean accepted = Boolean.FALSE;
        try {
            accepted = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new File(EulaImpl.getEULAAcceptedFilePath()).exists();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return accepted;
    }

    private static void createEULAAcceptedFile() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    new File(EulaImpl.getEULAAcceptedFilePath()).createNewFile();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static int askUserAcceptEULA() {
        boolean eulaRet = EulaDialog.askUserAcceptEULA();
        return eulaRet ? 1 : 0;
    }

    public void accept() {
        EulaImpl.createEULAAcceptedFile();
    }

    public boolean show() {
        if (EulaImpl.isEULAAlreadyAccepted()) {
            Ping.send();
            return true;
        }
        int retInt = EulaImpl.askUserAcceptEULA();
        if (retInt == 1 || retInt == 2) {
            EulaImpl.createEULAAcceptedFile();
            Ping.send();
            return true;
        }
        Boolean isJNLPAppletLauncherRunning = Boolean.FALSE;
        try {
            isJNLPAppletLauncherRunning = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if ("true".equals(System.getProperty("sun.jnlp.applet.launcher"))) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            // empty catch block
        }
        if (isJNLPAppletLauncherRunning.booleanValue()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        EulaImpl.removeLibraries();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {}
        } else if (!EulaImpl.isCommandLine()) {
            try {
                DownloadService ds = (DownloadService)ServiceManager.lookup((String)"javax.jnlp.DownloadService");
                Properties removeList = EulaImpl.loadPropertiesFile();
                boolean done = false;
                if (removeList != null) {
                    int i = 0;
                    while (!done) {
                        String extURL = removeList.getProperty("remove." + i + ".extUrl");
                        String extVersion = removeList.getProperty("remove." + i + ".extVersion");
                        String part = removeList.getProperty("remove." + i + ".part");
                        if (extURL != null) {
                            ++i;
                            ds.removeExtensionPart(new URL(extURL), extVersion, part);
                            continue;
                        }
                        done = true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void removeLibraries() {
        String mname = "removeLibrary";
        Class[] args = new Class[]{String.class};
        try {
            Class<?> klass = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
            Method method = klass.getMethod("removeLibrary", args);
            try {
                method.invoke(null, "jmc");
                method.invoke(null, "on2_decoder");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                method.invoke(null, "jogl");
                method.invoke(null, "jogl_awt");
                method.invoke(null, "jogl_cg");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                method.invoke(null, "gluegen-rt");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                method.invoke(null, "Decora-SSE");
                method.invoke(null, "Decora-D3D");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFile() {
        Properties props = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        try {
            is = cl.getResourceAsStream("com/sun/javafx/eula/removelist.properties");
            props.load(is);
            Properties properties = props;
            return properties;
        }
        catch (IOException ioe) {
            Properties properties = null;
            return properties;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

