/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmc;

import com.sun.media.jmc.MediaProvider;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.control.VideoRenderControl;
import com.sun.media.jmc.event.MediaSizeListener;
import com.sun.media.jmc.event.SizeChangedEvent;
import com.sun.media.jmc.event.VideoRendererEvent;
import com.sun.media.jmc.event.VideoRendererListener;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ListIterator;

public abstract class MediaFrameHandler
implements VideoRendererListener,
MediaSizeListener {
    private final ArrayList<WeakReference<FrameConsumer>> consumers = new ArrayList(1);
    private final MediaProvider provider;
    private VideoRenderControl videoRenderControl;
    private double timeStamp = 0.0;
    private int frameWidth;
    private int frameHeight;
    private volatile boolean textureUpdateNeeded = true;
    private final VideoDataBuffer vdb = new VideoDataBuffer(null, 0, 0, 0, null);
    private VideoDataBuffer.Format format;
    private volatile boolean firstFrameRendered = false;
    private volatile boolean firstFrameDelivered = false;

    protected MediaFrameHandler(MediaProvider provider) {
        this.provider = provider;
    }

    public void addConsumer(FrameConsumer consumer) {
        this.init();
        VideoDataBuffer.Format[] formats = consumer.getPreferredFormats();
        if (this.format == null) {
            this.format = formats[0];
        } else {
            boolean foundCompatible = false;
            for (VideoDataBuffer.Format f : formats) {
                if (f != this.format) continue;
                foundCompatible = true;
                break;
            }
            if (!foundCompatible) {
                System.err.println("Warning: consumer " + consumer + " does not understand this provider's format: " + (Object)((Object)this.format));
            }
        }
        this.consumers.add(new WeakReference<FrameConsumer>(consumer));
    }

    public void removeConsumer(FrameConsumer consumer) {
        ListIterator<WeakReference<FrameConsumer>> it = this.consumers.listIterator();
        while (it.hasNext()) {
            FrameConsumer c = (FrameConsumer)it.next().get();
            if (c != null && c != consumer) continue;
            it.remove();
        }
        if (this.consumers.size() == 0) {
            this.reset();
        }
    }

    protected abstract void releaseGraphicsData();

    protected abstract boolean updateGraphicsData(Object var1, int var2, int var3, VideoDataBuffer.Format var4, Buffer var5);

    protected abstract Object getGraphicsData(Object var1);

    public final Object getLatestFrame(Object screenRef) {
        if (this.textureUpdateNeeded) {
            this.latestFrameLocked();
            this.frameWidth = this.vdb.getWidth();
            this.frameHeight = this.vdb.getHeight();
            this.textureUpdateNeeded = !this.updateGraphicsData(screenRef, this.frameWidth, this.frameHeight, this.vdb.getFormat(), this.vdb.getBuffer());
            this.latestFrameReleased();
        }
        return this.getGraphicsData(screenRef);
    }

    private void latestFrameReleased() {
        if (null != this.vdb.getBuffer()) {
            this.videoRenderControl.releaseData(this.vdb);
        }
    }

    private void latestFrameLocked() {
        if (this.firstFrameDelivered && !this.firstFrameRendered) {
            this.firstFrameRendered = true;
        }
        if (this.videoRenderControl != null) {
            this.videoRenderControl.getData(this.vdb);
        } else {
            this.vdb.setBuffer(null);
        }
    }

    private void init() {
        VideoRenderControl newVRC = MediaFrameHandler.getVRC(this.provider);
        if (this.videoRenderControl != newVRC) {
            this.reset();
            this.videoRenderControl = newVRC;
            if (this.videoRenderControl != null) {
                this.videoRenderControl.addVideoRendererListener(this);
                this.frameWidth = this.videoRenderControl.getFrameWidth();
                this.frameHeight = this.videoRenderControl.getFrameHeight();
                this.provider.addMediaSizeListener(this);
            }
        }
    }

    private void reset() {
        this.releaseGraphicsData();
        this.frameWidth = 0;
        this.frameHeight = 0;
        if (this.videoRenderControl != null) {
            this.videoRenderControl.removeVideoRendererListener(this);
            this.videoRenderControl = null;
        }
        this.provider.removeMediaSizeListener(this);
    }

    public final boolean isFrameVFlipped() {
        return this.vdb.isVFlipped();
    }

    public final boolean isFrameHFlipped() {
        return this.vdb.isHFlipped();
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public void videoFrameUpdated(VideoRendererEvent vre) {
        if (!this.firstFrameDelivered) {
            this.firstFrameDelivered = true;
        }
        if (this.timeStamp != vre.getTimestamp()) {
            this.textureUpdateNeeded = true;
            this.timeStamp = vre.getTimestamp();
            ListIterator<WeakReference<FrameConsumer>> it = this.consumers.listIterator();
            while (it.hasNext()) {
                FrameConsumer c = (FrameConsumer)it.next().get();
                if (c != null) {
                    c.notifyFrameArrived();
                    continue;
                }
                it.remove();
            }
        }
    }

    public void mediaSizeChanged(SizeChangedEvent event) {
        this.frameWidth = event.getWidth();
        this.frameHeight = event.getHeight();
    }

    private static VideoRenderControl getVRC(final MediaProvider provider) {
        return AccessController.doPrivileged(new PrivilegedAction<VideoRenderControl>(){

            @Override
            public VideoRenderControl run() {
                return provider.getControl(VideoRenderControl.class);
            }
        });
    }

    public static interface FrameConsumer {
        public VideoDataBuffer.Format[] getPreferredFormats();

        public void notifyFrameArrived();
    }
}

