/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.OperationUnsupportedException;
import com.sun.media.jmc.control.VideoControl;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.event.BufferDownloadedProgressChangedEvent;
import com.sun.media.jmc.event.DurationChangedEvent;
import com.sun.media.jmc.event.MediaEvent;
import com.sun.media.jmc.event.MediaStateEvent;
import com.sun.media.jmc.event.MediaTimeEvent;
import com.sun.media.jmc.event.SizeChangedEvent;
import com.sun.media.jmc.event.VideoRendererEvent;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import sun.awt.AppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlayerPeer
implements PlayerPeer {
    protected boolean platformCoordinatesYFlipped = false;
    private double startTime = Double.NEGATIVE_INFINITY;
    private double stopTime = Double.POSITIVE_INFINITY;
    private boolean autoRepeat = false;
    private boolean needPosterFrame = false;
    protected boolean earlyTaskLoop = false;
    private PlayerPeer.MediaState mediaState = PlayerPeer.MediaState.invalid;
    protected final ImagePumpState currentImagePump = new ImagePumpState();
    protected final NativePlayerPeerProperties currentProps = new NativePlayerPeerProperties();
    public static final int eventMediaAvailable = 100;
    public static final int eventPrerollComplete = 101;
    public static final int eventSizeChanged = 102;
    public static final int eventStarted = 103;
    public static final int eventEndOfMedia = 104;
    public static final int eventDurationChanged = 111;
    public static final int eventMediaError = 112;
    public static final int eventStopped = 114;
    public static final int eventRepeat = 115;
    public static final int eventStopTime = 117;
    public static final int eventMediaFormatChanged = 119;
    public static final int eventMediaStream = 121;
    public static final int eventStartTimeChanged = 122;
    public static final int eventStopTimeChanged = 123;
    public static final int eventMediaTimeStamp = 124;
    public static final int eventVideoRendered = 126;
    public static final int eventVolumeChanged = 127;
    public static final int eventBufferProgress = 128;
    private static final int kFrameRate = 30;
    private static final int kAudioFrameRate = 50;
    protected static final int eventUpdated = 6;
    protected static final int eventTimed = 7;
    protected static final int eventChanged = 8;
    protected URI uri = null;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    static ScheduledThreadPoolExecutor executor;
    protected BlockingQueue<MediaEvent> eventQueue;
    protected BlockingQueue<MediaEvent> earlyEventQueue = new LinkedBlockingQueue<MediaEvent>();
    private float savedVolume;
    private float savedBalance;
    private float savedFader;
    private static int sUniqueID;
    private int uniqueID = sUniqueID++;
    double savedRateForPause = 0.0;
    boolean pausedRecently = false;
    private final TaskThread taskThread = new TaskThread(this, 30.0f);
    protected boolean newFrameAvailable = false;
    private List<Double> notificationTimes = new ArrayList<Double>();
    private double lastCheckedTime;
    boolean pendingStart = false;

    protected abstract void plugin_setSource(URI var1);

    protected abstract void plugin_provideCleanContext();

    protected abstract void plugin_start();

    protected abstract void plugin_stop();

    protected abstract void plugin_pause();

    protected abstract void plugin_setMediaTime(double var1);

    protected abstract double plugin_getMediaTime();

    protected abstract void plugin_setStartTime(double var1);

    protected abstract void plugin_setStopTime(double var1);

    protected abstract void plugin_setRate(double var1);

    protected abstract void plugin_setVolume(float var1);

    protected abstract void plugin_setBalance(float var1);

    protected abstract void plugin_setFader(float var1);

    protected abstract void plugin_getMovieProperties();

    protected abstract boolean plugin_endOfMedia();

    protected abstract boolean plugin_newFrame();

    protected abstract void plugin_prerollMovie();

    protected abstract void plugin_transferFrame(int[] var1, int var2, int var3);

    protected abstract void plugin_transferFrame(VideoDataBuffer var1);

    protected AbstractPlayerPeer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void syncMovieProperties(NativePlayerPeerProperties newProperties) {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            if (this.currentProps.imageWidth != newProperties.imageWidth || this.currentProps.imageHeight != newProperties.imageHeight) {
                this.currentProps.imageHorizontalFlipped = newProperties.imageWidth < 0;
                this.currentProps.imageWidth = Math.abs(newProperties.imageWidth);
                this.currentProps.imageVerticalFlipped = newProperties.imageHeight < 0 ^ this.platformCoordinatesYFlipped;
                this.currentProps.imageHeight = Math.abs(newProperties.imageHeight);
                this.computeNewImageBuffer();
                this.sendEvent(new SizeChangedEvent(newProperties.mediaTime, "Size Changed", this, newProperties.imageWidth, newProperties.imageHeight));
            }
            if (this.currentProps.duration != newProperties.duration) {
                this.currentProps.duration = newProperties.duration;
                this.sendEvent(new DurationChangedEvent(newProperties.mediaTime, "Duration changed", this, newProperties.duration));
            }
            if (this.currentProps.rate != newProperties.rate) {
                this.currentProps.rate = newProperties.rate;
            }
            if (this.currentProps.bufferProgressTime != newProperties.bufferProgressTime) {
                this.currentProps.bufferProgressTime = newProperties.bufferProgressTime;
                this.sendEvent(new BufferDownloadedProgressChangedEvent(newProperties.mediaTime, "Buffer Downloaded", this, this.currentProps.bufferProgressTime));
            }
            this.currentProps.mediaTime = newProperties.mediaTime;
            this.currentProps.volume = newProperties.volume;
            this.currentProps.balance = newProperties.balance;
            this.currentProps.fader = newProperties.fader;
            this.setCaps(this.currentProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScheduledThreadPoolExecutor getExecutor() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            AppContext appContext = AccessController.doPrivileged(new PrivilegedAction<AppContext>(){

                @Override
                public AppContext run() {
                    return AppContext.getAppContext();
                }
            });
            if (appContext != null && appContext.isDisposed()) {
                return null;
            }
            if (appContext != null) {
                executor = (ScheduledThreadPoolExecutor)appContext.get(AbstractPlayerPeer.class);
                if (executor == null) {
                    executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
                        private final ThreadFactory delegate = Executors.defaultThreadFactory();
                        private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

                            public void uncaughtException(Thread t, Throwable e) {
                            }
                        };

                        public Thread newThread(Runnable r) {
                            Thread thread = this.delegate.newThread(r);
                            thread.setDaemon(true);
                            thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
                            return thread;
                        }
                    });
                    appContext.put(AbstractPlayerPeer.class, executor);
                    executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
                    final ScheduledThreadPoolExecutor fstpe = executor;
                    appContext.addPropertyChangeListener("disposed", new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent pce) {
                            WeakReference<ScheduledThreadPoolExecutor> stpeRef;
                            ScheduledThreadPoolExecutor stpe;
                            boolean disposed = (Boolean)pce.getNewValue();
                            if (disposed && (stpe = (ScheduledThreadPoolExecutor)(stpeRef = new WeakReference<ScheduledThreadPoolExecutor>(fstpe)).get()) != null) {
                                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                    @Override
                                    public Void run() {
                                        stpe.shutdown();
                                        return null;
                                    }
                                });
                            }
                        }
                    });
                }
            } else {
                executor = new ScheduledThreadPoolExecutor(1);
                executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            }
        }
        return executor;
    }

    @Override
    public final synchronized void setSource(URI theURI) throws MediaException {
        if (null == theURI) {
            this.stopTaskLoop();
            this.uri = null;
            this.plugin_setSource(null);
            return;
        }
        theURI.normalize();
        if (theURI.equals(this.uri)) {
            this.plugin_pause();
            this.beforeNewSource();
            this.setMediaTime(this.startTime);
            this.setMediaState(PlayerPeer.MediaState.prerolling);
            this.plugin_prerollMovie();
            this.afterNewSource();
            this.setMediaState(PlayerPeer.MediaState.paused);
            this.plugin_getMovieProperties();
            this.sendMovieEvent(114, this.getMediaTime());
            this.pendingStart = false;
        } else {
            this.uri = theURI;
            this.setSource_Imp();
        }
    }

    @Override
    public abstract MediaPeer getMediaPeer();

    @Override
    public final synchronized void dispose() {
        this.uri = null;
        this.plugin_provideCleanContext();
    }

    @Override
    public final void start() {
        this.getExecutor().execute(new Execute_StartMedia());
    }

    @Override
    public final void stop() {
        this.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AbstractPlayerPeer abstractPlayerPeer = AbstractPlayerPeer.this;
                synchronized (abstractPlayerPeer) {
                    if (AbstractPlayerPeer.this.getMediaState() != PlayerPeer.MediaState.mediaAvailable) {
                        AbstractPlayerPeer.this.stopTaskLoop();
                        AbstractPlayerPeer.this.pendingStart = false;
                        AbstractPlayerPeer.this.plugin_stop();
                        AbstractPlayerPeer.this.plugin_getMovieProperties();
                        NativePlayerPeerProperties nativePlayerPeerProperties = AbstractPlayerPeer.this.currentProps;
                        synchronized (nativePlayerPeerProperties) {
                            AbstractPlayerPeer.this.sendMovieEvent(114, AbstractPlayerPeer.this.currentProps.mediaTime);
                        }
                        AbstractPlayerPeer.this.sendMovieEvent(114, AbstractPlayerPeer.this.getMediaTime());
                        AbstractPlayerPeer.this.setMediaState(PlayerPeer.MediaState.mediaAvailable);
                    }
                }
            }
        });
    }

    @Override
    public final void pause() {
        this.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AbstractPlayerPeer abstractPlayerPeer = AbstractPlayerPeer.this;
                synchronized (abstractPlayerPeer) {
                    AbstractPlayerPeer.this.pendingStart = false;
                    AbstractPlayerPeer.this.private_pause();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setMediaTime(double time) throws OperationUnsupportedException {
        double duration;
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            duration = this.currentProps.duration;
        }
        if (time < 0.0 || time < this.startTime || time > this.stopTime) {
            if (time < this.startTime) {
                time = this.startTime;
            } else if (time > this.stopTime) {
                time = this.stopTime;
            }
            if (time < 0.0) {
                time = 0.0;
            } else if (time > duration) {
                time = duration;
            }
        }
        this.getExecutor().execute(new Execute_SetMediaTime(time));
    }

    @Override
    public final double getMediaTime() {
        return this.currentProps.mediaTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setStartTime(double time) throws MediaException {
        double duration;
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            duration = this.currentProps.duration;
        }
        if (time < 0.0 || time > duration || time >= this.stopTime) {
            if (time < 0.0) {
                time = 0.0;
            } else if (time > duration || time >= this.stopTime) {
                time = this.startTime;
            }
        }
        this.startTime = time;
        this.plugin_setStartTime(this.startTime);
    }

    @Override
    public final double getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setStopTime(double time) throws MediaException {
        double duration;
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            duration = this.currentProps.duration;
        }
        if (time == -1.0) {
            time = Double.POSITIVE_INFINITY;
        } else if (time < 0.0 || time > duration || time <= this.startTime) {
            if (time > duration) {
                time = duration;
            } else if (time < 0.0 || time <= this.startTime) {
                time = this.stopTime;
            }
        }
        this.stopTime = time;
        this.plugin_setStopTime(this.stopTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFrameData(VideoDataBuffer data) {
        ImagePumpState imagePumpState = this.currentImagePump;
        synchronized (imagePumpState) {
            this.plugin_transferFrame(data);
            data.setHFlipped(this.currentImagePump.imageHorizontalFlipped);
            data.setVFlipped(this.currentImagePump.imageVerticalFlipped);
        }
    }

    @Override
    public void releaseFrameData(VideoDataBuffer data) {
    }

    @Override
    public final double getStopTime() {
        return this.stopTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getDuration() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.duration;
        }
    }

    @Override
    public final void setRate(double newRate) {
        this.getExecutor().execute(new Execute_SetRate(newRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final double getRate() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.rate;
        }
    }

    @Override
    public final void setVolume(float vol) {
        this.getExecutor().execute(new Execute_SetVolume(vol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final float getVolume() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.volume;
        }
    }

    @Override
    public final void setBalance(float newBalance) {
        this.getExecutor().execute(new Execute_SetBalance(newBalance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final float getBalance() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.balance;
        }
    }

    @Override
    public final void setFader(float newFader) {
        this.getExecutor().execute(new Execute_SetFader(newFader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final float getFader() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.fader;
        }
    }

    @Override
    public final void setEventQueue(BlockingQueue<MediaEvent> queue) {
        this.eventQueue = queue;
        if (null != this.eventQueue) {
            this.earlyEventQueue.drainTo(this.eventQueue);
        }
    }

    @Override
    public final void setNotificationTimes(List<Double> list) {
        if (!list.isEmpty()) {
            throw new OperationUnsupportedException();
        }
    }

    @Override
    public final void setAutoRepeat(boolean autoRepeat) {
        this.autoRepeat = autoRepeat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResizeBehavior(VideoControl.ResizeBehavior behavior) {
        boolean sendUpdate = false;
        ImagePumpState imagePumpState = this.currentImagePump;
        synchronized (imagePumpState) {
            if (this.currentImagePump.scaleMode != behavior) {
                this.currentImagePump.scaleMode = behavior;
                sendUpdate = true;
            }
        }
        if (sendUpdate) {
            this.sendMovieEventInt(8, Double.NEGATIVE_INFINITY, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<PlayerPeer.Capabilities> getCapabilities() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.caps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameWidth() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.imageWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameHeight() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.imageHeight;
        }
    }

    protected synchronized void setSource_Imp() throws MediaException {
        this.plugin_provideCleanContext();
        this.beforeNewSource();
        this.plugin_setSource(this.uri);
        this.plugin_getMovieProperties();
        this.afterNewSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeNewSource() {
        this.savedRateForPause = 1.0;
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            this.savedVolume = this.currentProps.volume;
            this.savedBalance = this.currentProps.balance;
            this.savedFader = this.currentProps.fader;
        }
        this.initializePlayerProperties();
        this.setMediaState(PlayerPeer.MediaState.binding);
    }

    private void afterNewSource() {
        if (this.earlyTaskLoop) {
            this.startTaskLoop();
        }
        this.setVolume(this.savedVolume);
        this.setBalance(this.savedBalance);
        this.setFader(this.savedFader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePlayerProperties() {
        NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            this.currentProps.imageWidth = 0;
            this.currentProps.imageHeight = 0;
            this.currentProps.duration = Double.POSITIVE_INFINITY;
            this.currentProps.rate = 1.0;
            this.currentProps.bufferProgressTime = Double.POSITIVE_INFINITY;
            this.currentProps.mediaTime = 0.0;
            this.setCaps(this.currentProps);
        }
        this.notificationTimes = new ArrayList<Double>();
        this.startTime = Double.NEGATIVE_INFINITY;
        this.stopTime = Double.POSITIVE_INFINITY;
        this.autoRepeat = false;
    }

    protected void setCaps(NativePlayerPeerProperties nppProps) {
        nppProps.caps = EnumSet.noneOf(PlayerPeer.Capabilities.class);
        nppProps.caps.add(PlayerPeer.Capabilities.isLightweight);
        nppProps.caps.add(PlayerPeer.Capabilities.supportsRate);
        nppProps.caps.add(PlayerPeer.Capabilities.supportsVolume);
        nppProps.caps.add(PlayerPeer.Capabilities.supportsSeeking);
        nppProps.caps.add(PlayerPeer.Capabilities.supportsBalance);
    }

    protected void sendEvent(MediaEvent event) {
        if (this.eventQueue != null) {
            this.eventQueue.offer(event);
        } else {
            this.earlyEventQueue.offer(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPluginEvent(int inEventID) {
        switch (inEventID) {
            case 100: {
                this.setMediaState(PlayerPeer.MediaState.prerolling);
                NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
                synchronized (nativePlayerPeerProperties) {
                    this.currentProps.bufferProgressTime = 0.0;
                }
                this.plugin_getMovieProperties();
                this.plugin_prerollMovie();
                this.plugin_getMovieProperties();
                break;
            }
            case 101: {
                this.setMediaState(PlayerPeer.MediaState.paused);
                this.plugin_getMovieProperties();
                if (!this.pendingStart) break;
                this.pendingStart = false;
                this.getExecutor().execute(new Execute_StartMedia());
                break;
            }
        }
    }

    private PlayerPeer.MediaState getMediaState() {
        return this.mediaState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMediaState(PlayerPeer.MediaState inState) {
        this.mediaState = inState;
        if (inState == PlayerPeer.MediaState.paused) {
            NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
            synchronized (nativePlayerPeerProperties) {
                this.savedRateForPause = this.currentProps.rate;
            }
        }
    }

    private void private_pause() {
        if (this.getMediaState() == PlayerPeer.MediaState.playing) {
            this.plugin_pause();
            this.plugin_getMovieProperties();
            this.pausedRecently = true;
            this.sendMovieEvent(114, this.getMediaTime());
            this.setMediaState(PlayerPeer.MediaState.paused);
        }
    }

    protected void sendMovieEvent(int eventID, double time) {
        switch (eventID) {
            case 104: {
                this.sendEvent(new MediaStateEvent(time, "EOM", this, MediaStateEvent.MediaState.END_OF_MEDIA));
                break;
            }
            case 114: {
                this.sendEvent(new MediaStateEvent(time, "stopped", this, MediaStateEvent.MediaState.STOPPED));
                break;
            }
            case 115: {
                this.sendEvent(new MediaStateEvent(time, "repeat", this, MediaStateEvent.MediaState.REPEAT));
                break;
            }
            case 103: {
                this.sendEvent(new MediaStateEvent(time, "started", this, MediaStateEvent.MediaState.STARTED));
                break;
            }
        }
    }

    protected void sendMovieEventInt(int eventID, double time, int value) {
        switch (eventID) {
            case 6: {
                this.sendEvent(new VideoRendererEvent(time, "updated", this, value));
                break;
            }
            case 8: {
                this.sendEvent(new VideoRendererEvent(time, "changed", this, value));
                break;
            }
        }
    }

    protected void sendMovieEventDouble(int eventID, double time, double value) {
        switch (eventID) {
            case 7: {
                this.sendEvent(new MediaTimeEvent(time, "timestamp", this, MediaTimeEvent.MediaPositionType.MEDIA_TIMESTAMP, value));
                break;
            }
        }
    }

    private void startTaskLoop() {
        this.taskThread.startTask();
    }

    private void stopTaskLoop() {
        this.taskThread.stopTask();
    }

    protected void destroyTaskLoop() {
        this.stopTaskLoop();
    }

    private void checkNotificationTimes() {
        if (this.notificationTimes != null) {
            double time = this.getMediaTime();
            for (Double notificationTime : this.notificationTimes) {
                double val = notificationTime;
                if (!(this.lastCheckedTime < val) || !(time >= val)) continue;
                this.sendMovieEventDouble(7, time, val);
            }
            this.lastCheckedTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void computeNewImageBuffer() {
        boolean hFlip;
        boolean vFlip;
        int w = 0;
        int h = 0;
        Object object = this.currentProps;
        synchronized (object) {
            w = this.currentProps.imageWidth;
            h = this.currentProps.imageHeight;
            vFlip = this.currentProps.imageVerticalFlipped;
            hFlip = this.currentProps.imageHorizontalFlipped;
        }
        if (w <= 0 || w >= 10000 || h <= 0 || h >= 10000) {
            return;
        }
        object = this.currentImagePump;
        synchronized (object) {
            if (w == this.currentImagePump.imageWidth && h == this.currentImagePump.imageHeight) {
                return;
            }
            this.currentImagePump.imageWidth = w;
            this.currentImagePump.imageHeight = h;
            this.currentImagePump.imageVerticalFlipped = vFlip;
            this.currentImagePump.imageHorizontalFlipped = hFlip;
        }
    }

    static {
        sUniqueID = 0;
    }

    private class Execute_SetBalance
    implements Runnable {
        private float localBalance;

        public Execute_SetBalance(float inNewBalance) {
            this.localBalance = inNewBalance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractPlayerPeer abstractPlayerPeer = AbstractPlayerPeer.this;
            synchronized (abstractPlayerPeer) {
                AbstractPlayerPeer.this.plugin_setBalance(this.localBalance);
                AbstractPlayerPeer.this.plugin_getMovieProperties();
            }
        }
    }

    private class Execute_SetFader
    implements Runnable {
        private final float mNewFader;

        public Execute_SetFader(float inNewFader) {
            this.mNewFader = inNewFader;
        }

        public void run() {
            AbstractPlayerPeer.this.plugin_setFader(this.mNewFader);
            AbstractPlayerPeer.this.plugin_getMovieProperties();
        }
    }

    private class Execute_SetMediaTime
    implements Runnable {
        double time;

        public Execute_SetMediaTime(double inTime) {
            this.time = inTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractPlayerPeer abstractPlayerPeer = AbstractPlayerPeer.this;
            synchronized (abstractPlayerPeer) {
                if (this.time < AbstractPlayerPeer.this.startTime || this.time > AbstractPlayerPeer.this.stopTime) {
                    this.time = AbstractPlayerPeer.this.startTime;
                }
                AbstractPlayerPeer.this.plugin_setMediaTime(this.time);
                AbstractPlayerPeer.this.plugin_getMovieProperties();
            }
        }
    }

    private class Execute_SetRate
    implements Runnable {
        private final double mNewRate;

        public Execute_SetRate(double inNewRate) {
            this.mNewRate = inNewRate;
        }

        public void run() {
            AbstractPlayerPeer.this.plugin_setRate(this.mNewRate);
            AbstractPlayerPeer.this.plugin_getMovieProperties();
        }
    }

    private class Execute_SetVolume
    implements Runnable {
        float volumeLocal;

        public Execute_SetVolume(float inVol) {
            this.volumeLocal = inVol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractPlayerPeer abstractPlayerPeer = AbstractPlayerPeer.this;
            synchronized (abstractPlayerPeer) {
                AbstractPlayerPeer.this.plugin_setVolume(this.volumeLocal);
                AbstractPlayerPeer.this.plugin_getMovieProperties();
            }
        }
    }

    private class Execute_StartMedia
    implements Runnable {
        private Execute_StartMedia() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractPlayerPeer abstractPlayerPeer = AbstractPlayerPeer.this;
            synchronized (abstractPlayerPeer) {
                if (AbstractPlayerPeer.this.getMediaState() == PlayerPeer.MediaState.paused) {
                    AbstractPlayerPeer.this.plugin_start();
                    AbstractPlayerPeer.this.plugin_getMovieProperties();
                    AbstractPlayerPeer.this.sendMovieEvent(103, AbstractPlayerPeer.this.getMediaTime());
                    AbstractPlayerPeer.this.setMediaState(PlayerPeer.MediaState.playing);
                    AbstractPlayerPeer.this.startTaskLoop();
                } else {
                    AbstractPlayerPeer.this.pendingStart = true;
                }
            }
        }
    }

    protected final class Execute_mediaEvent
    implements Runnable {
        private final int mEventID;

        public Execute_mediaEvent(int inEventID) {
            this.mEventID = inEventID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractPlayerPeer abstractPlayerPeer = AbstractPlayerPeer.this;
            synchronized (abstractPlayerPeer) {
                if (this.mEventID != 102) {
                    AbstractPlayerPeer.this.sendMovieEvent(this.mEventID, AbstractPlayerPeer.this.getMediaTime());
                }
                AbstractPlayerPeer.this.processPluginEvent(this.mEventID);
            }
        }
    }

    private class ImagePumpState {
        public VideoControl.ResizeBehavior scaleMode = VideoControl.ResizeBehavior.Preserve;
        public int[] pixels = null;
        public int imageWidth;
        public int imageHeight;
        public boolean imageHorizontalFlipped = false;
        public boolean imageVerticalFlipped = false;

        private ImagePumpState() {
        }
    }

    public class NativePlayerPeerProperties {
        public int imageWidth;
        public int imageHeight;
        public boolean imageHorizontalFlipped = false;
        public boolean imageVerticalFlipped = false;
        public double duration = Double.POSITIVE_INFINITY;
        public double rate = 1.0;
        public double bufferProgressTime = Double.POSITIVE_INFINITY;
        public double mediaTime = 0.0;
        public float volume = 1.0f;
        public float balance = 0.0f;
        public float fader = 0.0f;
        public Set<PlayerPeer.Capabilities> caps = Collections.unmodifiableSet(EnumSet.noneOf(PlayerPeer.Capabilities.class));
    }

    private class TaskThread
    implements Runnable {
        int loopIter = 0;
        boolean scheduled = false;
        ScheduledFuture future;

        public TaskThread(Object creator, float fps) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            double duration;
            double mediaTime;
            boolean gotFrame = false;
            AbstractPlayerPeer abstractPlayerPeer = AbstractPlayerPeer.this;
            synchronized (abstractPlayerPeer) {
                gotFrame = AbstractPlayerPeer.this.plugin_newFrame();
                AbstractPlayerPeer.this.plugin_getMovieProperties();
                Object object = AbstractPlayerPeer.this.currentProps;
                synchronized (object) {
                    mediaTime = AbstractPlayerPeer.this.currentProps.mediaTime = AbstractPlayerPeer.this.plugin_getMediaTime();
                    duration = AbstractPlayerPeer.this.currentProps.duration;
                }
                if (gotFrame) {
                    AbstractPlayerPeer.this.needPosterFrame = false;
                    object = AbstractPlayerPeer.this.currentImagePump;
                    synchronized (object) {
                        AbstractPlayerPeer.this.newFrameAvailable = true;
                        AbstractPlayerPeer.this.sendMovieEventInt(6, mediaTime, (int)mediaTime * 10000000);
                    }
                }
            }
            if (duration > 0.0 && duration != Double.NEGATIVE_INFINITY && duration != Double.POSITIVE_INFINITY) {
                double tempBufferProgress;
                NativePlayerPeerProperties nativePlayerPeerProperties = AbstractPlayerPeer.this.currentProps;
                synchronized (nativePlayerPeerProperties) {
                    tempBufferProgress = AbstractPlayerPeer.this.currentProps.bufferProgressTime;
                }
                if (mediaTime > duration - 0.001 || mediaTime > AbstractPlayerPeer.this.stopTime - 0.001) {
                    if (AbstractPlayerPeer.this.autoRepeat) {
                        AbstractPlayerPeer.this.sendMovieEvent(115, mediaTime);
                        AbstractPlayerPeer.this.setMediaTime(AbstractPlayerPeer.this.startTime);
                    } else {
                        AbstractPlayerPeer.this.sendMovieEvent(104, mediaTime);
                        AbstractPlayerPeer.this.sendMovieEvent(114, mediaTime);
                        this.stopTask();
                    }
                }
                if (AbstractPlayerPeer.this.stopTime > tempBufferProgress && duration > tempBufferProgress && AbstractPlayerPeer.this.mediaState == PlayerPeer.MediaState.playing && mediaTime > tempBufferProgress - 0.5) {
                    AbstractPlayerPeer.this.private_pause();
                }
            }
        }

        public void startTask() {
            if (!this.scheduled) {
                this.scheduled = true;
                this.future = AbstractPlayerPeer.this.getExecutor().scheduleAtFixedRate(this, 0L, 30L, TimeUnit.MILLISECONDS);
            }
        }

        public void stopTask() {
            if (this.scheduled) {
                this.scheduled = false;
                this.future.cancel(false);
                AbstractPlayerPeer.this.getExecutor().remove((Runnable)((Object)this.future));
                AbstractPlayerPeer.this.getExecutor().purge();
            }
        }

        public void destroyTask() {
            this.stopTask();
        }
    }
}

