/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.control.VideoControl;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.event.MediaEvent;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import javax.media.CannotRealizeException;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.SizeChangeEvent;
import javax.media.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMFPlayerPeer
implements PlayerPeer,
ControllerListener {
    double rate = 1.0;
    Player jmfPlayer;
    boolean looping = true;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    Container parentContainer = null;
    Boolean isStarted = true;
    BlockingQueue<MediaEvent> myQueue;
    float volume = 0.5f;
    Boolean isMute;
    private Set<PlayerPeer.Capabilities> caps = EnumSet.allOf(PlayerPeer.Capabilities.class);

    public JMFPlayerPeer(URI uri) throws IOException, MediaException {
        try {
            this.jmfPlayer = Manager.createRealizedPlayer((URL)uri.toURL());
        }
        catch (IOException e) {
            System.out.println("Got (JMF) IOE" + e);
            throw e;
        }
        catch (NoPlayerException e) {
            System.out.println("Got (JMF) NoPlayer Exception" + (Object)((Object)e));
            throw new MediaUnsupportedException("JMF thrown NoPlayerException", e);
        }
        catch (CannotRealizeException e) {
            System.out.println("Got (JMF) CnRE" + (Object)((Object)e));
            throw new MediaException("Cannot realize", e);
        }
        this.jmfPlayer.addControllerListener((ControllerListener)this);
    }

    @Override
    public int getFrameWidth() {
        return 0;
    }

    @Override
    public int getFrameHeight() {
        return 0;
    }

    public void XsetVideoDestination(Component dest) {
        if (!(dest instanceof Container)) {
            throw new MediaException("Video Destination is not a container");
        }
        this.parentContainer = (Container)dest;
        this.parentContainer.setLayout(new BorderLayout());
        Component vc = this.jmfPlayer.getVisualComponent();
        this.parentContainer.add(vc, "Center");
        Component cpc = this.jmfPlayer.getControlPanelComponent();
        this.parentContainer.add(cpc, "South");
        this.parentContainer.validate();
        Dimension vcD = vc.getPreferredSize();
        System.out.println("vcd=" + vcD);
        Dimension cpcD = cpc.getPreferredSize();
        System.out.println("cpcD=" + cpcD);
        this.parentContainer.setSize(Math.max(vcD.width, cpcD.width), vcD.height + cpcD.height);
    }

    @Override
    public void pause() {
    }

    @Override
    public MediaPeer getMediaPeer() {
        return null;
    }

    @Override
    public void start() {
        this.jmfPlayer.start();
        this.isStarted = true;
    }

    @Override
    public void setSource(URI uri) throws MediaException {
        Player newJmfPlayer;
        try {
            newJmfPlayer = Manager.createRealizedPlayer((URL)uri.toURL());
        }
        catch (Exception e) {
            throw new MediaException("Cannot Create Player for URI:" + uri, e);
        }
        System.out.println("NewPlayer...");
        if (this.jmfPlayer != null) {
            this.jmfPlayer.stop();
            this.jmfPlayer.removeControllerListener((ControllerListener)this);
            this.jmfPlayer.close();
        }
        this.jmfPlayer = newJmfPlayer;
        this.jmfPlayer.addControllerListener((ControllerListener)this);
        if (this.isStarted.booleanValue()) {
            this.jmfPlayer.start();
        }
    }

    @Override
    public double getDuration() {
        Time jmfTime = this.jmfPlayer.getDuration();
        if (jmfTime == Time.TIME_UNKNOWN) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)jmfTime.getNanoseconds() / 1.0E8;
    }

    @Override
    public void setStartTime(double time) {
    }

    @Override
    public double getStartTime() {
        return 0.0;
    }

    @Override
    public void setStopTime(double time) {
    }

    @Override
    public double getStopTime() {
        return 0.0;
    }

    @Override
    public void setMediaTime(double time) {
        Time mt = new Time(time);
        this.jmfPlayer.setMediaTime(mt);
    }

    @Override
    public double getMediaTime() {
        Time jmfTime = this.jmfPlayer.getMediaTime();
        return jmfTime.getSeconds();
    }

    @Override
    public void setRate(double rate) {
        boolean wasStarted;
        if (this.jmfPlayer.getState() == 600) {
            wasStarted = true;
            this.jmfPlayer.stop();
        } else {
            wasStarted = false;
        }
        this.rate = rate;
        float retRate = this.jmfPlayer.setRate((float)rate);
        System.out.println("JMF Set Rate to " + rate + "got " + retRate);
        if (wasStarted) {
            this.jmfPlayer.start();
        }
    }

    @Override
    public void setAutoRepeat(boolean looping) {
        this.looping = looping;
    }

    @Override
    public void setResizeBehavior(VideoControl.ResizeBehavior behavior) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            this.jmfPlayer.setMediaTime(new Time(0L));
            if (this.looping) {
                this.jmfPlayer.start();
            }
        } else if (evt instanceof SizeChangeEvent) {
            // empty if block
        }
    }

    public float play(float rate) {
        if ((double)rate == 0.0) {
            this.jmfPlayer.stop();
            return 0.0f;
        }
        this.setRate(rate);
        this.jmfPlayer.setRate(rate);
        this.jmfPlayer.start();
        return 1.0f;
    }

    public boolean setMute(boolean mute) {
        GainControl gainControl = this.jmfPlayer.getGainControl();
        if (gainControl != null) {
            gainControl.setMute(mute);
            this.isMute = gainControl.getMute();
        } else {
            this.isMute = mute;
        }
        return this.isMute;
    }

    public boolean getMute() {
        GainControl gainControl = this.jmfPlayer.getGainControl();
        if (gainControl != null) {
            this.isMute = gainControl.getMute();
        }
        return this.isMute;
    }

    @Override
    public void setVolume(float volume) {
        this.volume = volume;
        GainControl gainControl = this.jmfPlayer.getGainControl();
        if (gainControl != null) {
            gainControl.setLevel(volume);
            volume = gainControl.getLevel();
        }
    }

    @Override
    public float getVolume() {
        GainControl gainControl = this.jmfPlayer.getGainControl();
        if (gainControl != null) {
            this.volume = gainControl.getLevel();
        }
        return this.volume;
    }

    @Override
    public void setBalance(float balance) {
    }

    @Override
    public float getBalance() {
        return 0.0f;
    }

    @Override
    public void setFader(float fader) {
    }

    @Override
    public float getFader() {
        return 0.0f;
    }

    @Override
    public void stop() {
        this.isStarted = false;
        this.jmfPlayer.stop();
    }

    @Override
    public double getRate() {
        return this.jmfPlayer.getRate();
    }

    @Override
    public void setEventQueue(BlockingQueue<MediaEvent> queue) {
        this.myQueue = queue;
    }

    @Override
    public void setNotificationTimes(List<Double> list) {
    }

    @Override
    public Set<PlayerPeer.Capabilities> getCapabilities() {
        return this.caps;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void getFrameData(VideoDataBuffer data) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public void releaseFrameData(VideoDataBuffer data) {
    }
}

