/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Logger {
    protected String logPrefix;
    protected boolean error = false;
    protected boolean warning = false;
    protected boolean info = false;
    protected boolean debug = false;
    StringBuilder sb = new StringBuilder();

    public Logger(TraceLevel traceLevel, String logPrefix) {
        this.logPrefix = logPrefix == null ? "" : logPrefix;
        switch (traceLevel) {
            case Debug: {
                this.debug = true;
            }
            case Info: {
                this.info = true;
            }
            case Warning: {
                this.warning = true;
            }
            case Error: {
                this.error = true;
            }
        }
    }

    public Logger(String flagName, String logPrefix) {
        this(Logger.getTraceLevel(flagName), logPrefix);
    }

    private static TraceLevel getTraceLevel(final String flagName) {
        String flagValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(flagName, "");
            }
        });
        if (flagValue.compareToIgnoreCase("error") == 0) {
            return TraceLevel.Error;
        }
        if (flagValue.compareToIgnoreCase("warning") == 0) {
            return TraceLevel.Warning;
        }
        if (flagValue.compareToIgnoreCase("info") == 0) {
            return TraceLevel.Info;
        }
        if (flagValue.compareToIgnoreCase("debug") == 0) {
            return TraceLevel.Debug;
        }
        return TraceLevel.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(TraceLevel traceLevel, PrintStream out, String s) {
        String str;
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            this.sb.append(this.logPrefix);
            this.sb.append(" (");
            this.sb.append(traceLevel.toString());
            this.sb.append("):");
            this.sb.append(s);
            str = this.sb.toString();
            this.sb.setLength(0);
        }
        out.println(str);
    }

    private void log(TraceLevel traceLevel, PrintStream out, String s, Throwable ex) {
        if (s == null) {
            s = "exception thrown: ";
        }
        this.log(traceLevel, out, s);
        ex.printStackTrace(out);
    }

    public void err(String s) {
        if (this.error) {
            this.log(TraceLevel.Error, System.out, s);
        }
    }

    public void err(String s, Throwable ex) {
        if (this.error) {
            this.log(TraceLevel.Error, System.out, s, ex);
        }
    }

    public void warn(String s) {
        if (this.warning) {
            this.log(TraceLevel.Warning, System.out, s);
        }
    }

    public void warn(String s, Throwable ex) {
        if (this.warning) {
            this.log(TraceLevel.Warning, System.out, s, ex);
        }
    }

    public void info(String s) {
        if (this.info) {
            this.log(TraceLevel.Info, System.out, s);
        }
    }

    public void info(String s, Throwable ex) {
        if (this.info) {
            this.log(TraceLevel.Info, System.out, s, ex);
        }
    }

    public void debug(String s) {
        if (this.debug) {
            this.log(TraceLevel.Debug, System.out, s);
        }
    }

    public void debug(String s, Throwable ex) {
        if (this.debug) {
            this.log(TraceLevel.Debug, System.out, s, ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TraceLevel {
        None,
        Error,
        Warning,
        Info,
        Debug;

    }
}

