/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import java.io.PrintStream;
import java.util.Formatter;

public class MediaLog {
    LogEntry[] logEntries;
    int readPosition = 0;
    int writePosition = 0;
    int numEntries = 0;
    long nanoOffset = 0L;
    boolean logging = false;
    int requestedSize = 5000;
    private static MediaLog sysLog = null;

    public MediaLog() {
        this(5000);
    }

    public MediaLog(int numEntries) {
        this.requestedSize = numEntries;
    }

    public static synchronized MediaLog getSysLog() {
        if (sysLog == null) {
            sysLog = new MediaLog(32000);
        }
        return sysLog;
    }

    public synchronized void reset() {
        this.numEntries = 0;
        this.readPosition = 0;
        this.writePosition = 0;
    }

    public synchronized void start() {
        if (this.logEntries == null) {
            this.logEntries = new LogEntry[this.requestedSize];
            for (int i = 0; i < this.requestedSize; ++i) {
                this.logEntries[i] = new LogEntry();
            }
        }
        this.logging = true;
        this.logEvent(0L, "Log Started");
    }

    public synchronized void pause() {
        this.logEvent(0L, "Log Paused");
        this.logging = false;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void logEvent(double mediaTime, String what) {
        this.logEvent((long)(mediaTime * 1.0E9), what);
    }

    public synchronized void logEvent(long mediaTime, String what) {
        if (!this.logging || this.logEntries == null || this.logEntries.length == 0) {
            return;
        }
        if (this.numEntries < this.logEntries.length) {
            ++this.numEntries;
        } else {
            this.readPosition = this.readPosition++ % this.logEntries.length;
        }
        this.logEntries[this.writePosition].currentTime = System.nanoTime() + this.nanoOffset;
        this.logEntries[this.writePosition].mediaTime = mediaTime;
        this.logEntries[this.writePosition].what = what;
        this.writePosition = (this.writePosition + 1) % this.logEntries.length;
    }

    public synchronized void sychronizeToMediaTime(double mediaTime) {
        this.synchronizeToMediaTime((long)(mediaTime * 1.0E9));
    }

    public synchronized void synchronizeToMediaTime(long mediaTime) {
        this.logEvent(mediaTime, "Setting Wall Time");
        this.nanoOffset = mediaTime - System.nanoTime();
        this.logEvent(mediaTime, "Set Wall Time");
    }

    public void printLog() {
        this.printLog(System.out);
    }

    String toString(long nanos) {
        int min = (int)(nanos / 60000000000L);
        int sec = (int)(nanos / 1000000000L) % 60;
        int micros = (int)(nanos / 1000L % 1000000L);
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("%02d:%02d,%06d", min, sec, micros);
        return sb.toString();
    }

    public void printLog(PrintStream os) {
        int nEntries = this.numEntries;
        int index = this.readPosition;
        if (this.logEntries == null) {
            os.println("Log not started");
        } else {
            os.println("Wall Time | Media Time | Event " + this.numEntries);
            for (int i = 0; i < nEntries; ++i) {
                os.println(this.toString(this.logEntries[index].currentTime) + "  " + this.toString(this.logEntries[index].mediaTime) + "   " + this.logEntries[index].what);
                index = (index + 1) % this.logEntries.length;
            }
        }
    }

    class LogEntry {
        long currentTime;
        long mediaTime;
        String what;

        LogEntry() {
        }
    }
}

