/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmcimpl.FileCacheImageInputStreamEx;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import sun.net.www.protocol.file.FileURLConnection;

public class MediaNetworkProvider {
    public URL url;
    public URLConnection connection;
    static String FilePrefix1 = "file:/";
    static String FilePrefix2 = "file://";
    static String FilePrefix3 = "file:///";
    static String FilePrefix4 = "file:////";
    ImageInputStreamImpl data;

    public static void activate() {
        MediaNetworkProvider.onload(ImageInputStreamImpl.class);
    }

    protected static native void onload(Object var0);

    protected void init(URL _url, String stRequestMethod) throws IOException {
        this.url = _url;
        this.connection = this.url.openConnection();
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).setRequestMethod(stRequestMethod);
        }
    }

    public MediaNetworkProvider(URL _url, String stRequestMethod) throws IOException {
        this.init(_url, stRequestMethod);
    }

    public MediaNetworkProvider(String stURL, String stRequestMethod) throws MalformedURLException, IOException {
        String ALetterProtocolTest;
        String decURL = URLDecoder.decode(stURL, "UTF-8");
        if (!decURL.startsWith(FilePrefix4) && decURL.startsWith(FilePrefix3)) {
            decURL = decURL.substring(8).replace("|", ":");
        }
        if ((ALetterProtocolTest = decURL.substring(1)).startsWith(":/") || ALetterProtocolTest.startsWith(":\\")) {
            decURL = FilePrefix1 + decURL;
        }
        this.init(new URL(decURL), stRequestMethod);
    }

    public boolean isFileMoniker() {
        return "file".equals(this.url.getProtocol());
    }

    public boolean isHttpMoniker() {
        return "http".equals(this.url.getProtocol()) || "ftp".equals(this.url.getProtocol()) || "jar".equals(this.url.getProtocol());
    }

    public boolean isSessionRequired() {
        return this.isHttpMoniker();
    }

    public String getRequestHeaders() {
        String headers = "";
        if (null != this.connection) {
            Map<String, List<String>> map = this.connection.getRequestProperties();
            for (String key : map.keySet()) {
                headers = headers + key + ": " + map.get(key) + "\r\n";
            }
        }
        return headers;
    }

    public void addRequestHeaders(String addHeaders) {
        if (null != addHeaders && this.connection instanceof HttpURLConnection) {
            String[] lines;
            for (String l : lines = addHeaders.split("\r\n")) {
                String[] n2v = l.split(": ");
                if (n2v[0].startsWith("Range")) {
                    this.connection.setUseCaches(false);
                }
                ((HttpURLConnection)this.connection).setRequestProperty(n2v[0], n2v[1]);
            }
        }
    }

    public void connect() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).connect();
        }
    }

    public String getHostName() {
        return this.url.getHost();
    }

    public void disconnect() {
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).disconnect();
        }
    }

    public int getResponseCode() throws IOException {
        return this.connection instanceof HttpURLConnection ? ((HttpURLConnection)this.connection).getResponseCode() : 200;
    }

    public String getResponse() {
        String response = "";
        if (this.connection instanceof HttpURLConnection) {
            String key;
            HttpURLConnection hc = (HttpURLConnection)this.connection;
            response = hc.getHeaderField(0);
            int n = 1;
            while (null != (key = hc.getHeaderFieldKey(n))) {
                response = response + "\r\n" + key + ": " + hc.getHeaderField(n);
                ++n;
            }
        }
        return response;
    }

    public String getRedirectedURL() {
        return null == this.connection ? this.url.toString() : this.connection.getURL().toExternalForm();
    }

    public String getContentType() {
        return null == this.connection ? "" : this.connection.getContentType();
    }

    public boolean isURLCached() {
        return this.connection instanceof HttpURLConnection ? ((FileCacheImageInputStreamEx)this.data).isURLCached() : this.connection instanceof FileURLConnection;
    }

    public String getCacheFileURL() throws IllegalAccessException, URISyntaxException {
        return this.connection instanceof HttpURLConnection ? ((FileCacheImageInputStreamEx)this.data).getCacheFile().getPath() : (this.connection instanceof FileURLConnection ? new File(this.url.toURI()).getAbsolutePath() : "");
    }

    public long getContentSize() {
        String len;
        if (null != this.connection && null != (len = this.connection.getHeaderField("Content-Length"))) {
            return Long.parseLong(len);
        }
        return -1L;
    }

    public ImageInputStreamImpl getContentStream() throws FileNotFoundException, IOException, URISyntaxException {
        if (this.isSessionRequired()) {
            IOException e = AccessController.doPrivileged(new PrivilegedAction<IOException>(){

                @Override
                public IOException run() {
                    try {
                        MediaNetworkProvider.this.data = new FileCacheImageInputStreamEx(MediaNetworkProvider.this.connection);
                        return null;
                    }
                    catch (IOException e) {
                        return e;
                    }
                }
            });
            if (e != null) {
                throw e;
            }
        } else {
            this.data = new FileImageInputStream(new File(this.url.toURI()));
        }
        return this.data;
    }

    public Object seekClone(long offest) throws IOException {
        String stRequestMethod = null;
        if (this.connection instanceof HttpURLConnection) {
            stRequestMethod = ((HttpURLConnection)this.connection).getRequestMethod();
        } else if (this.connection instanceof JarURLConnection) {
            stRequestMethod = "GET";
        } else {
            throw new IllegalStateException("connectino is neither HttpURLConnection nor JarURLConnection");
        }
        MediaNetworkProvider copy = new MediaNetworkProvider(this.url, stRequestMethod);
        String stHeader = this.getRequestHeaders();
        if (stHeader.length() != 0) {
            stHeader = stHeader + "\r\n";
        }
        copy.addRequestHeaders(stHeader + "Range: bytes=" + offest + "-");
        return copy;
    }
}

