/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet loaded = new HashSet();
    private static boolean usingJNLPAppletLauncher;
    private static Method jnlpLoadLibraryMethod;

    public static synchronized void loadLibrary(String libname) {
        if (!loaded.contains(libname)) {
            NativeLibLoader.loadLibraryInternal(libname);
            loaded.add(libname);
        }
    }

    private static void loadLibraryInternal(String libraryName) {
        if (usingJNLPAppletLauncher && !libraryName.equals("jawt")) {
            try {
                if (jnlpLoadLibraryMethod == null) {
                    Class<?> jnlpAppletLauncherClass = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    jnlpLoadLibraryMethod = jnlpAppletLauncherClass.getDeclaredMethod("loadLibrary", String.class);
                }
                jnlpLoadLibraryMethod.invoke(null, libraryName);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(e);
            }
        } else {
            System.loadLibrary(libraryName);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String sunAppletLauncher = System.getProperty("sun.jnlp.applet.launcher");
                usingJNLPAppletLauncher = Boolean.valueOf(sunAppletLauncher);
                return null;
            }
        });
    }
}

