/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnavailableException;
import com.sun.media.jmc.MediaUnsupportedException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.spi.MediaPeerProvider;
import com.sun.media.jmcimpl.spi.PlayerPeerProvider;
import com.sun.media.jmcimpl.spi.ProviderRegistry;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerManager {
    private static ProviderRegistry<PlayerPeerProvider> peerProviders = new ProviderRegistry<PlayerPeerProvider>(PlayerPeerProvider.class);
    private static ProviderRegistry<MediaPeerProvider> mediaProviders = new ProviderRegistry<MediaPeerProvider>(MediaPeerProvider.class);

    private PeerManager() {
    }

    private static void throwMediaException(URI uri, MediaException ex) throws MediaException {
        if (ex != null) {
            throw ex;
        }
        final URI theURI = uri;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    theURI.toURL().openStream();
                }
                catch (IOException e) {
                    throw new MediaUnavailableException("Media unavailable: " + theURI, e);
                }
                throw new MediaUnsupportedException("Unsupported media: " + theURI);
            }
        });
    }

    public static PlayerPeer getPlayerPeer(URI uri) throws MediaException {
        return PeerManager.getPlayerPeer(uri, false, null);
    }

    public static PlayerPeer getPlayerPeer(URI uri, boolean lightweightOnly, VideoDataBuffer.Format[] formats) throws MediaException {
        PlayerPeerProvider[] providers = peerProviders.getProviderArray();
        PlayerPeerProvider.PlaybackMode[] peerModes = new PlayerPeerProvider.PlaybackMode[providers.length];
        MediaException thrownException = null;
        for (int i = 0; i < providers.length; ++i) {
            peerModes[i] = providers[i].canPlay(uri, formats);
            if (peerModes[i] != PlayerPeerProvider.PlaybackMode.Lightweight) continue;
            try {
                PlayerPeer peer = providers[i].createPlayerPeer(uri, formats);
                return peer;
            }
            catch (MediaException ex) {
                if (thrownException != null) continue;
                thrownException = ex;
            }
        }
        PlayerPeerProvider.PlaybackMode playMode = PlayerPeerProvider.PlaybackMode.Unknown;
        while (true) {
            for (int i = 0; i < providers.length; ++i) {
                if (peerModes[i] != playMode) continue;
                try {
                    PlayerPeer peer = providers[i].createPlayerPeer(uri, formats);
                    if (!lightweightOnly || peer.getCapabilities().contains((Object)PlayerPeer.Capabilities.isLightweight)) {
                        return peer;
                    }
                    peer.dispose();
                    continue;
                }
                catch (MediaException ex) {
                    if (thrownException != null) continue;
                    thrownException = ex;
                }
            }
            if (playMode != PlayerPeerProvider.PlaybackMode.Unknown || lightweightOnly) break;
            playMode = PlayerPeerProvider.PlaybackMode.Heavyweight;
        }
        PeerManager.throwMediaException(uri, thrownException);
        return null;
    }

    public static List<ContainerType> getSupportedContainerTypes() {
        LinkedList<ContainerType> list = new LinkedList<ContainerType>();
        Iterator<PlayerPeerProvider> providers = peerProviders.getProviders();
        while (providers.hasNext()) {
            PlayerPeerProvider provider = providers.next();
            ContainerType[] types = provider.getContainerTypes();
            if (types == null) continue;
            for (int i = 0; i < types.length; ++i) {
                if (list.indexOf(types[i]) != -1) continue;
                list.add(types[i]);
            }
        }
        return list;
    }

    public static boolean isPeerClassForURI(URI uri, Class<? extends PlayerPeer> pClass, VideoDataBuffer.Format[] formats) {
        PlayerPeerProvider[] providers = peerProviders.getProviderArray();
        for (int i = 0; i < providers.length; ++i) {
            if (providers[i].getPlayerPeerClass() != pClass) continue;
            return providers[i].canPlay(uri, formats) != PlayerPeerProvider.PlaybackMode.None;
        }
        System.err.println("Orphan Peer:" + pClass);
        return false;
    }

    public static MediaPeer getMediaPeer(URI uri, VideoDataBuffer.Format[] formats) throws MediaException {
        Iterator<MediaPeerProvider> mediaPeerProviders = mediaProviders.getProviders();
        MediaException thrownException = null;
        while (mediaPeerProviders.hasNext()) {
            MediaPeerProvider provider = mediaPeerProviders.next();
            if (!provider.canDecode(uri, formats)) continue;
            try {
                MediaPeer mediaPeer = provider.createMediaPeer(uri, formats);
                return mediaPeer;
            }
            catch (MediaException ex) {
                if (thrownException != null) continue;
                thrownException = ex;
            }
        }
        PeerManager.throwMediaException(uri, thrownException);
        return null;
    }
}

