/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.corevideo;

import com.sun.media.jmc.control.VideoDataBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class CoreVideoBuffer
extends VideoDataBuffer {
    ByteBuffer nativeBuffer;
    IntBuffer nativeIntWrapper;
    boolean useIntWrapper = false;
    long nativeFramePtr = 0L;
    public static final int CVPixelFormatType_422YpCbCr8 = 846624121;
    public static final int CVPixelFormatType_32ARGB = 32;
    public static final int CVPixelFormatType_32BGRA = 1111970369;
    public static final int CVPixelFormatType_420YpCbCr8Planar = 2033463856;

    public CoreVideoBuffer(long framePtr) {
        super(null, 0, 0, 0, VideoDataBuffer.Format.XRGB);
        this.nativeFramePtr = framePtr;
        this.nativeBuffer = this.cvbGetByteBuffer(this.nativeFramePtr);
        this.nativeBuffer.rewind();
        this.nativeIntWrapper = this.nativeBuffer.asIntBuffer();
        int format = this.cvbGetCVPixelFormat(this.nativeFramePtr);
        switch (format) {
            case 846624121: 
            case 2033463856: {
                break;
            }
            default: {
                System.err.println("Unknown/unsupported CoreVideo pixel format, assuming XRGB: " + Integer.toHexString(format));
            }
            case 32: 
            case 1111970369: {
                this.useIntWrapper = true;
            }
        }
    }

    private native void cvbDispose(long var1);

    private native boolean cvbIsLocked(long var1);

    private native void cvbLock(long var1);

    private native void cvbUnlock(long var1);

    private native int cvbGetWidth(long var1);

    private native int cvbGetHeight(long var1);

    private native int cvbGetRowBytes(long var1);

    private native int cvbGetCVPixelFormat(long var1);

    private native ByteBuffer cvbGetByteBuffer(long var1);

    public boolean isLocked() {
        return this.cvbIsLocked(this.nativeFramePtr);
    }

    public void lock() {
        this.cvbLock(this.nativeFramePtr);
    }

    public void unlock() {
        this.cvbUnlock(this.nativeFramePtr);
    }

    public void dispose() {
        if (this.nativeFramePtr != 0L) {
            this.cvbDispose(this.nativeFramePtr);
        }
        this.nativeBuffer = null;
        this.nativeIntWrapper = null;
        this.nativeFramePtr = 0L;
    }

    public void setBuffer(Buffer buf) {
    }

    public Buffer getBuffer() {
        if (this.useIntWrapper) {
            return this.nativeIntWrapper;
        }
        return this.nativeBuffer;
    }

    public void setWidth(int w) {
    }

    public int getWidth() {
        return this.cvbGetWidth(this.nativeFramePtr);
    }

    public void setHeight(int h) {
    }

    public int getHeight() {
        return this.cvbGetHeight(this.nativeFramePtr);
    }

    public void setLineStride(int s) {
    }

    public int getLineStride() {
        return this.cvbGetRowBytes(this.nativeFramePtr);
    }

    public void setFormat(VideoDataBuffer.Format f) {
    }

    public VideoDataBuffer.Format getFormat() {
        int pixelFormat = this.cvbGetCVPixelFormat(this.nativeFramePtr);
        switch (pixelFormat) {
            case 846624121: {
                return VideoDataBuffer.Format.APPLE_422;
            }
            case 32: {
                return VideoDataBuffer.Format.XRGB;
            }
            case 1111970369: {
                return VideoDataBuffer.Format.XRGB;
            }
            case 2033463856: {
                return VideoDataBuffer.Format.YV12;
            }
        }
        System.err.println("Unknown/Unsupported pixel format: " + Integer.toHexString(pixelFormat));
        return VideoDataBuffer.Format.XRGB;
    }

    public String toString() {
        return new String("[CoreVideoBuffer@" + this.nativeFramePtr + ",width=" + this.cvbGetWidth(this.nativeFramePtr) + ",height=" + this.cvbGetHeight(this.nativeFramePtr) + ",format=" + Integer.toHexString(this.cvbGetCVPixelFormat(this.nativeFramePtr)) + ",rowBytes=" + this.cvbGetRowBytes(this.nativeFramePtr) + "]");
    }
}

