/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.corevideo;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.OperationUnsupportedException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.event.SizeChangedEvent;
import com.sun.media.jmcimpl.AbstractPlayerPeer;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.corevideo.CoreVideoBuffer;
import com.sun.media.jmcimpl.plugins.corevideo.CoreVideoMedia;
import java.net.URI;
import java.nio.Buffer;
import java.util.IdentityHashMap;
import java.util.Iterator;

class CoreVideoPlayer
extends AbstractPlayerPeer
implements PlayerPeer {
    private float fader = 0.0f;
    private CoreVideoMedia mediaPeer = null;
    private boolean deferRateChange = true;
    private VideoDataBuffer.Format[] supportedPixelFormats;
    private final IdentityHashMap videoBufferList = new IdentityHashMap(64);
    private final IdentityHashMap staleBufferList = new IdentityHashMap(8);
    private CoreVideoBuffer nextVideoFrame = null;
    private int lastWidth = 0;
    private int lastHeight = 0;
    float g_fader = 0.0f;
    double g_lastRateSet = 1.0;

    public CoreVideoPlayer(VideoDataBuffer.Format[] formats) throws MediaException {
        this.earlyTaskLoop = true;
        this.deferRateChange = true;
        this.mediaPeer = null;
        if (null == formats) {
            formats = new VideoDataBuffer.Format[]{VideoDataBuffer.Format.XRGB};
        }
        this.supportedPixelFormats = formats;
    }

    public CoreVideoPlayer(CoreVideoMedia thePeer, VideoDataBuffer.Format[] formats) throws MediaException {
        this(formats);
        this.setMedia(thePeer);
    }

    public synchronized MediaPeer getMediaPeer() {
        return this.mediaPeer;
    }

    public VideoDataBuffer.Format[] getPixelFormats() {
        return this.supportedPixelFormats;
    }

    public void finalize() {
        this.dispose();
    }

    protected synchronized double plugin_getMediaTime() {
        if (null != this.mediaPeer) {
            return this.mediaPeer.getMediaTime();
        }
        return Double.NEGATIVE_INFINITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean plugin_newFrame() {
        if (null != this.mediaPeer) {
            IdentityHashMap identityHashMap = this.videoBufferList;
            synchronized (identityHashMap) {
                if (null == this.nextVideoFrame) {
                    this.nextVideoFrame = this.mediaPeer.getNextFrame();
                    if (null != this.nextVideoFrame && (this.lastWidth != this.nextVideoFrame.getWidth() || this.lastHeight != this.nextVideoFrame.getHeight())) {
                        this.lastWidth = this.nextVideoFrame.getWidth();
                        this.lastHeight = this.nextVideoFrame.getHeight();
                        this.sendEvent(new SizeChangedEvent(this.mediaPeer.getMediaTime(), "Size Changed", this, this.lastWidth, this.lastHeight));
                    }
                }
            }
            return null != this.nextVideoFrame;
        }
        throw new OperationUnsupportedException("bad movie : " + this.uri);
    }

    protected synchronized void plugin_pause() {
        if (null != this.mediaPeer) {
            this.deferRateChange = true;
            this.mediaPeer.stop();
            this.ClearVideoBufferList();
        }
    }

    protected synchronized void plugin_start() {
        if (null != this.mediaPeer) {
            this.deferRateChange = false;
            this.native_SetRate(this.g_lastRateSet);
            this.mediaPeer.play();
            this.ClearVideoBufferList();
        }
    }

    protected synchronized void plugin_stop() {
        if (null != this.mediaPeer) {
            this.deferRateChange = true;
            this.mediaPeer.stop();
            this.ClearVideoBufferList();
        }
    }

    protected synchronized void plugin_provideCleanContext() {
        this.ReleaseResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ReleaseResources() {
        if (null != this.mediaPeer) {
            AbstractPlayerPeer.ImagePumpState imagePumpState = this.currentImagePump;
            synchronized (imagePumpState) {
                this.mediaPeer.stop();
                this.mediaPeer.close();
                this.mediaPeer = null;
                this.ClearVideoBufferList();
            }
        }
    }

    private void native_SetRate(double newRate) {
        if (null != this.mediaPeer) {
            this.mediaPeer.setRate(newRate);
        }
    }

    protected synchronized void plugin_prerollMovie() {
        if (null != this.mediaPeer) {
            this.processPluginEvent(101);
        }
    }

    protected synchronized void plugin_setBalance(float newBalance) {
        if (null != this.mediaPeer) {
            this.mediaPeer.setBalance(newBalance);
        }
    }

    protected synchronized void plugin_setFader(float newFader) {
        this.g_fader = newFader;
    }

    protected synchronized void plugin_setRate(double newRate) {
        this.g_lastRateSet = newRate;
        if (!this.deferRateChange) {
            this.native_SetRate(newRate);
        }
    }

    private synchronized void setMedia(CoreVideoMedia newPeer) {
        if (newPeer == this.mediaPeer) {
            return;
        }
        if (null != this.mediaPeer) {
            this.ReleaseResources();
        }
        this.mediaPeer = newPeer;
        if (null != this.mediaPeer) {
            this.processPluginEvent(100);
        }
    }

    protected synchronized void plugin_setSource(URI uri) {
        if (null == uri) {
            this.ReleaseResources();
            return;
        }
        this.setMedia(new CoreVideoMedia(uri, this));
    }

    protected synchronized void plugin_setMediaTime(double time) {
        if (null != this.mediaPeer) {
            this.mediaPeer.setMediaTime(time);
        }
    }

    protected synchronized void plugin_setStopTime(double time) {
    }

    protected synchronized void plugin_setStartTime(double time) {
    }

    protected boolean plugin_endOfMedia() {
        return false;
    }

    protected synchronized void plugin_getMovieProperties() {
        if (null != this.mediaPeer) {
            this.mediaPeer.updateMovieProperties();
            this.syncMovieProperties();
        }
    }

    private double getProgressTime() {
        double time = Double.NEGATIVE_INFINITY;
        if (null != this.mediaPeer) {
            time = this.mediaPeer.getAvailableDuration();
        }
        return time;
    }

    protected final void syncMovieProperties() {
        AbstractPlayerPeer.NativePlayerPeerProperties newProperties = new AbstractPlayerPeer.NativePlayerPeerProperties();
        newProperties.imageWidth = this.mediaPeer.getMovieWidth();
        newProperties.imageHeight = this.mediaPeer.getMovieHeight();
        newProperties.duration = this.mediaPeer.getDuration();
        newProperties.rate = this.mediaPeer.getRate();
        newProperties.bufferProgressTime = this.getProgressTime();
        newProperties.mediaTime = this.mediaPeer.getMediaTime();
        newProperties.volume = this.mediaPeer.getVolume();
        newProperties.balance = this.mediaPeer.getBalance();
        newProperties.fader = this.fader;
        this.syncMovieProperties(newProperties);
    }

    protected synchronized void plugin_setVolume(float volume) {
        if (null != this.mediaPeer) {
            this.mediaPeer.setVolume(volume);
        }
    }

    protected void plugin_transferFrame(int[] pixels, int frameWidth, int frameHeight) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void plugin_transferFrame(VideoDataBuffer db) {
        CoreVideoBuffer videoBuffer = null;
        IdentityHashMap identityHashMap = this.videoBufferList;
        synchronized (identityHashMap) {
            videoBuffer = this.nextVideoFrame;
            this.nextVideoFrame = null;
            db.setBuffer(null);
            if (null != videoBuffer) {
                Buffer nioBuf = videoBuffer.getBuffer();
                nioBuf.rewind();
                if (!this.videoBufferList.containsKey(nioBuf)) {
                    this.videoBufferList.put(nioBuf, videoBuffer);
                }
                db.setBuffer(nioBuf);
                db.setWidth(videoBuffer.getWidth());
                db.setHeight(videoBuffer.getHeight());
                db.setLineStride(videoBuffer.getLineStride());
                db.setFormat(videoBuffer.getFormat());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFrameData(VideoDataBuffer data) {
        Buffer buf = data.getBuffer();
        data.setBuffer(null);
        if (null != buf) {
            CoreVideoBuffer cvBuf = null;
            IdentityHashMap identityHashMap = this.videoBufferList;
            synchronized (identityHashMap) {
                if (this.videoBufferList.containsKey(buf) && null != (cvBuf = (CoreVideoBuffer)this.videoBufferList.get(buf))) {
                    cvBuf.unlock();
                }
            }
            if (null == cvBuf) {
                identityHashMap = this.staleBufferList;
                synchronized (identityHashMap) {
                    if (this.staleBufferList.containsKey(buf) && null != (cvBuf = (CoreVideoBuffer)this.staleBufferList.get(buf))) {
                        cvBuf.unlock();
                        cvBuf.dispose();
                        this.staleBufferList.remove(buf);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ClearVideoBufferList() {
        CoreVideoBuffer buf;
        Iterator iter;
        IdentityHashMap identityHashMap = this.videoBufferList;
        synchronized (identityHashMap) {
            iter = this.videoBufferList.values().iterator();
            while (iter.hasNext()) {
                buf = (CoreVideoBuffer)iter.next();
                if (null != buf) {
                    if (!buf.isLocked()) {
                        buf.dispose();
                    } else {
                        this.staleBufferList.put(buf.getBuffer(), buf);
                    }
                }
                iter.remove();
            }
            this.videoBufferList.clear();
            if (null != this.nextVideoFrame) {
                this.nextVideoFrame.unlock();
                this.nextVideoFrame.dispose();
                this.nextVideoFrame = null;
            }
        }
        identityHashMap = this.staleBufferList;
        synchronized (identityHashMap) {
            iter = this.staleBufferList.values().iterator();
            while (iter.hasNext()) {
                buf = (CoreVideoBuffer)iter.next();
                if (null == buf || buf.isLocked()) continue;
                buf.dispose();
                iter.remove();
            }
        }
    }
}

