/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.track.AudioTrack;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.SubtitleTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmcimpl.Logger;
import com.sun.media.jmcimpl.plugins.directshow.DShowEncodings;
import com.sun.media.jmcimpl.plugins.directshow.DShowMedia;
import com.sun.media.jmcimpl.plugins.directshow.DShowPlayer;
import java.awt.Component;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class DShowEngine {
    static final boolean trace = false;
    static final Logger log = null;
    static final Logger log2 = null;
    static final Logger log3 = null;
    protected static final int eventDurationChanged = 111;
    protected static final int eventMediaError = 112;
    protected static final int eventEndOfMedia = 104;
    protected static final int eventStopped = 114;
    protected static final int eventRepeat = 115;
    protected static final int eventStarted = 103;
    protected static final int eventStopTime = 117;
    protected static final int eventMediaAvailable = 100;
    protected static final int eventMediaFormatChanged = 119;
    protected static final int eventPrerollComplete = 101;
    protected static final int eventMediaStream = 121;
    protected static final int eventStartTimeChanged = 122;
    protected static final int eventStopTimeChanged = 123;
    protected static final int eventMediaTimeStamp = 124;
    protected static final int eventSizeChanged = 102;
    protected static final int eventVideoRendered = 126;
    protected static final int eventVolumeChanged = 127;
    protected static final int eventBufferProgress = 128;
    private static final int eventContentUpdated = 121;
    private static final int TYPE_VIDEO = 0;
    private static final int TYPE_AUDIO = 1;
    private static final int TYPE_TEXT = 2;
    private static final int TYPE_OTHER = 3;
    private static final int RENDER_NOT_RENDERED = 0;
    private static final int RENDER_LIGHTWEIGHT = 1;
    private static final int RENDER_HEAVYWEIGHT = 2;
    private static final int METATYPE_INT = 0;
    private static final int METATYPE_LONG = 1;
    private static final int METATYPE_BOOL = 2;
    private static final int METATYPE_STRING = 3;
    private static final int CONTAINER_AVI = 1;
    private static final int CONTAINER_ASF = 2;
    private static final int CONTAINER_MPEG1AUDIO = 3;
    private static final int CONTAINER_MPEG1VIDEO = 4;
    private static final int CONTAINER_MPEG1VIDEOCD = 5;
    private static final int CONTAINER_MOV = 6;
    private static final int CONTAINER_WAV = 7;
    private static final int CONTAINER_AIFF = 8;
    private static final int CONTAINER_AU = 9;
    private static final int CONTAINER_MIDI = 10;
    private static final int CONTAINER_OGG = 11;
    private static final int CONTAINER_FLV = 12;
    private static final int CONTAINER_UNKNOWN = -1;
    private static final int CONTAINER_NOT_SET = 0;
    private static final int AM_SEEKING_CanSeekAbsolute = 1;
    private static final int AM_SEEKING_CanSeekForwards = 2;
    private static final int AM_SEEKING_CanSeekBackwards = 4;
    private static final int AM_SEEKING_CanGetCurrentPos = 8;
    private static final int AM_SEEKING_CanGetStopPos = 16;
    private static final int AM_SEEKING_CanGetDuration = 32;
    private static final int AM_SEEKING_CanPlayBackwards = 64;
    private static final int AM_SEEKING_CanDoSegments = 128;
    private static final int AM_SEEKING_Source = 256;
    DShowPlayer playerPeer = null;
    long id = 0L;
    boolean newFrame = false;
    Object frameData = null;
    protected final Object tracksLock = new Object();
    protected List<MediaTrack> trackList = null;
    protected MediaTrack[] mediaTracks = null;
    protected int firstVideoTrackIndex = -1;
    protected DShowVideoTrack videoTrack = null;
    private static VideoDataBuffer.Format videoFormat;

    private DShowEngine(DShowPlayer player) {
        this.playerPeer = player;
    }

    private DShowEngine() {
        this.playerPeer = null;
    }

    protected void finalize() {
        if (this.id != 0L) {
            this.nFinalize(this.id);
            this.id = 0L;
        }
    }

    public void ReleaseResources() {
        this.finalize();
    }

    static VideoDataBuffer.Format getVideoFormat() {
        return videoFormat;
    }

    protected static native boolean ndsInit(int var0);

    protected native long ndsCreate();

    protected native void ndsFinalize(long var1);

    protected native boolean ndsIsLightweight(long var1);

    protected native int ndsGetCaps(long var1);

    protected native void ndsSetParent(long var1, Component var3, int var4, int var5, int var6, int var7);

    protected native void ndsSetBounds(long var1, int var3, int var4, int var5, int var6);

    protected native void ndsSetVisible(long var1, boolean var3);

    protected native boolean ndsSetSource(long var1, String var3, String var4, int var5);

    protected native void ndsStart(long var1);

    protected native void ndsPause(long var1);

    protected native void ndsStop(long var1);

    protected native void ndsSetMediaTime(long var1, long var3);

    protected native long ndsGetMediaTime(long var1);

    protected native void ndsSetStartTime(long var1, long var3);

    protected native long ndsGetStartTime(long var1);

    protected native void ndsSetStopTime(long var1, long var3);

    protected native long ndsGetStopTime(long var1);

    protected native long ndsGetDuration(long var1);

    protected native long ndsGetBufferProgress(long var1);

    protected native void ndsSetRate(long var1, double var3);

    protected native double ndsGetRate(long var1);

    protected native void ndsSetVolume(long var1, float var3);

    protected native float ndsGetVolume(long var1);

    protected native void ndsSetBalance(long var1, float var3);

    protected native float ndsGetBalance(long var1);

    protected native void ndsSetAutoRepeat(long var1, boolean var3);

    protected native int ndsFillTracks(long var1, Object var3);

    protected native int ndsGetContainerType(long var1);

    protected native String ndsGetContainerDescr(long var1);

    protected native boolean ndsFillMetadata(long var1, Object var3);

    protected native boolean ndsTransferFrame(long var1, int[] var3, int var4, int var5);

    protected static boolean nInit(VideoDataBuffer.Format format) {
        videoFormat = format;
        boolean retval = DShowEngine.ndsInit(videoFormat.ordinal());
        return retval;
    }

    protected long nCreate() {
        long retval = this.ndsCreate();
        return retval;
    }

    protected boolean nIsLightweight(long id) {
        boolean retval = this.ndsIsLightweight(id);
        return retval;
    }

    protected int nGetCaps(long id) {
        int retval = this.ndsGetCaps(id);
        return retval;
    }

    protected void nFinalize(long id) {
        this.ndsFinalize(id);
    }

    protected void nSetParent(long id, Component hwComp, int x, int y, int w, int h) {
        this.ndsSetParent(id, hwComp, x, y, w, h);
    }

    protected void nSetBounds(long id, int x, int y, int w, int h) {
        this.ndsSetBounds(id, x, y, w, h);
    }

    protected void nSetVisible(long id, boolean b) {
        this.ndsSetVisible(id, b);
    }

    protected boolean nSetSource(long id, String url, String fileName, int renderMode) {
        boolean retval = false;
        retval = this.ndsSetSource(id, url, fileName, renderMode);
        return retval;
    }

    protected void nStart(long id) {
        this.ndsStart(id);
    }

    protected void nPause(long id) {
        this.ndsPause(id);
    }

    protected void nStop(long id) {
        this.ndsStop(id);
    }

    protected void nSetMediaTime(long id, long time) {
        this.ndsSetMediaTime(id, time);
    }

    protected long nGetMediaTime(long id) {
        long retval = this.ndsGetMediaTime(id);
        return retval;
    }

    protected void nSetStartTime(long id, long time) {
        this.ndsSetStartTime(id, time);
    }

    protected long nGetStartTime(long id) {
        long retval = this.ndsGetStartTime(id);
        return retval;
    }

    protected void nSetStopTime(long id, long time) {
        this.ndsSetStopTime(id, time);
    }

    protected long nGetStopTime(long id) {
        long retval = this.ndsGetStopTime(id);
        return retval;
    }

    protected long nGetDuration(long id) {
        long retval = this.ndsGetDuration(id);
        return retval;
    }

    protected void nSetRate(long id, double rate) {
        this.ndsSetRate(id, rate);
    }

    protected double nGetRate(long id) {
        double retval = this.ndsGetRate(id);
        return retval;
    }

    protected void nSetVolume(long id, float volume) {
        this.ndsSetVolume(id, volume);
    }

    protected float nGetVolume(long id) {
        float retval = this.ndsGetVolume(id);
        return retval;
    }

    protected void nSetBalance(long id, float balance) {
        this.ndsSetBalance(id, balance);
    }

    protected float nGetBalance(long id) {
        float retval = this.ndsGetBalance(id);
        return retval;
    }

    protected void nSetAutoRepeat(long id, boolean repeat) {
        this.ndsSetAutoRepeat(id, repeat);
    }

    protected int nFillTracks(long id, Object list) {
        int retval = this.ndsFillTracks(id, list);
        return retval;
    }

    protected int nGetContainerType(long id) {
        int retval = this.ndsGetContainerType(id);
        return retval;
    }

    protected String nGetContainerDescr(long id) {
        String retval = this.ndsGetContainerDescr(id);
        return retval;
    }

    protected boolean nFillMetadata(long id, Object map) {
        boolean retval = this.ndsFillMetadata(id, map);
        return retval;
    }

    protected boolean nTransferFrame(int[] pixels, int frameWidth, int frameHeight) {
        Thread.dumpStack();
        return true;
    }

    protected long time2pos(double time) {
        return (long)(time * 1.0E7);
    }

    protected double pos2time(long pos) {
        return (double)pos / 1.0E7;
    }

    public static DShowEngine canPlay(URI uri, boolean allowReuse) {
        return DShowEngine.canPlay(uri, allowReuse, null);
    }

    public static DShowEngine canPlay(URI uri, boolean allowReuse, DShowPlayer thePlayer) {
        boolean retval = false;
        DShowEngine e = new DShowEngine();
        e.playerPeer = thePlayer;
        e.id = e.nCreate();
        if (e.loadMedia(uri, 1)) {
            retval = true;
        }
        if (!retval || !allowReuse) {
            e.nFinalize(e.id);
            e = null;
        }
        return e;
    }

    boolean loadMedia(URI uri, int renderMode) {
        boolean retval = false;
        String fileStr = "";
        uri.normalize();
        if (uri.getScheme().equalsIgnoreCase("file")) {
            String partStr = uri.getSchemeSpecificPart();
            if (partStr.startsWith("///")) {
                fileStr = partStr.substring(3);
            } else if (partStr.startsWith("/")) {
                fileStr = partStr.substring(1);
            } else if (partStr.startsWith(".") && !partStr.startsWith("..")) {
                fileStr = partStr.substring(1);
            }
        }
        if (retval = this.nSetSource(this.id, uri.toASCIIString(), fileStr, renderMode)) {
            this.processTrackList(null);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTrackLock(int trackID) {
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.mediaTracks == null || trackID >= this.mediaTracks.length) {
                return null;
            }
            return this.mediaTracks[trackID];
        }
    }

    private void sendMediaEvent(int eventID, long pos, long arg2, String arg3) {
        if (this.playerPeer != null) {
            this.playerPeer.sendMediaEvent(eventID, 0L);
        }
    }

    private void sendTrackEvent(int eventID, long pos, int trackID, Object data, int[] frameInfo) {
        double time = pos < 0L ? Double.NEGATIVE_INFINITY : this.pos2time(pos);
        this.frameData = data;
        this.newFrame = true;
    }

    private long nGetBufferProgress(long id) {
        return this.ndsGetBufferProgress(id);
    }

    private void addTrack(Object list, int trackNum, String encoding, String filterName, boolean enabled, int trackType, int renderType, String language, int channels, double rate, int width, int height, boolean hasAlphaChannel) {
        List trackList = (List)list;
        MediaTrack track = null;
        switch (trackType) {
            case 0: {
                track = new DShowVideoTrack(trackNum, encoding, filterName, enabled, renderType, width, height, rate, hasAlphaChannel);
                break;
            }
            case 1: {
                track = new DShowAudioTrack(trackNum, encoding, filterName, enabled, renderType, channels, language, rate);
                break;
            }
            case 2: {
                track = new DShowTextTrack(trackNum, encoding, filterName, enabled, renderType, language);
            }
        }
        trackList.add(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTrackList(DShowMedia m) {
        if (this.trackList != null) {
            return;
        }
        LinkedList<MediaTrack> myTrackList = new LinkedList<MediaTrack>();
        MediaTrack[] myMediaTracks = new MediaTrack[]{};
        DShowVideoTrack myVideoTrack = null;
        int numTracks = this.nFillTracks(this.id, myTrackList);
        boolean findFirstVideoTrackIndex = true;
        int myFirstVideoTrackIndex = -1;
        if (numTracks > 0) {
            myMediaTracks = new MediaTrack[numTracks];
            Iterator iter = myTrackList.iterator();
            int currentTrack = 0;
            while (iter.hasNext()) {
                myMediaTracks[currentTrack] = (MediaTrack)iter.next();
                if (findFirstVideoTrackIndex && myMediaTracks[currentTrack] instanceof DShowVideoTrack) {
                    findFirstVideoTrackIndex = false;
                    myFirstVideoTrackIndex = currentTrack;
                    myVideoTrack = (DShowVideoTrack)myMediaTracks[currentTrack];
                }
                ++currentTrack;
            }
        }
        Object object = this.tracksLock;
        synchronized (object) {
            this.trackList = myTrackList;
            this.mediaTracks = myMediaTracks;
            this.firstVideoTrackIndex = myFirstVideoTrackIndex;
            this.videoTrack = myVideoTrack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMovieProperties(DShowMedia dShowMedia) {
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.videoTrack != null) {
                dShowMedia.width = this.videoTrack.getFrameWidth();
                dShowMedia.height = this.videoTrack.getFrameHeight();
                dShowMedia.fps = this.videoTrack.getFrameRate();
            }
        }
        dShowMedia.duration = this.pos2time(this.nGetDuration(this.id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTracks(DShowMedia dShowMedia) {
        int retval = 0;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            retval = this.mediaTracks.length;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackType(DShowMedia dShowMedia, int i) {
        int retval = 3;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.mediaTracks[i] instanceof DShowVideoTrack) {
                retval = 0;
            } else if (this.mediaTracks[i] instanceof DShowAudioTrack) {
                retval = 1;
            } else if (this.mediaTracks[i] instanceof DShowTextTrack) {
                retval = 2;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackFormat(DShowMedia dShowMedia, int i) {
        String retval = "Unknown";
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            retval = this.mediaTracks[i].getEncodingType().toString();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTrackIsEnabled(DShowMedia dShowMedia, int i) {
        boolean retval = false;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            retval = this.mediaTracks[i] != null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannels(DShowMedia dShowMedia, int i) {
        int retval = 1;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.mediaTracks[i] instanceof DShowAudioTrack) {
                DShowAudioTrack t = (DShowAudioTrack)this.mediaTracks[i];
                retval = t.getChannels();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSampleRate(DShowMedia dShowMedia, int i) {
        long retval = 0L;
        this.processTrackList(dShowMedia);
        Object object = this.tracksLock;
        synchronized (object) {
            if (this.mediaTracks[i] instanceof DShowVideoTrack) {
                DShowVideoTrack t = (DShowVideoTrack)this.mediaTracks[i];
                retval = (long)t.getFrameRate();
            } else if (this.mediaTracks[i] instanceof DShowAudioTrack) {
                DShowAudioTrack t = (DShowAudioTrack)this.mediaTracks[i];
                retval = (long)t.getSampleRate();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMovieProperties(DShowPlayer dShowPlayer) {
        this.processTrackList(null);
        int myWidth = 0;
        int myHeight = 0;
        Object object = this.tracksLock;
        synchronized (object) {
            this.playerPeer = dShowPlayer;
            if (this.videoTrack != null) {
                myWidth = this.videoTrack.getFrameWidth();
                myHeight = this.videoTrack.getFrameHeight();
            }
        }
        double myDuration = this.pos2time(this.nGetDuration(this.id));
        double myRate = this.nGetRate(this.id);
        double myBufferProgressTime = this.pos2time(this.nGetBufferProgress(this.id));
        double myMediaTime = this.pos2time(this.nGetMediaTime(this.id));
        float myVolume = this.nGetVolume(this.id);
        float myBalance = this.nGetBalance(this.id);
        float myFader = 0.0f;
        dShowPlayer.syncMovieProperties(myWidth, myHeight, myDuration, myRate, myBufferProgressTime, myMediaTime, myVolume, myBalance, myFader);
    }

    public double getMediaTime(DShowPlayer dShowPlayer) {
        double mt = this.pos2time(this.nGetMediaTime(this.id));
        return mt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean newFrame(DShowPlayer dShowPlayer) {
        boolean retval = false;
        Object object = this.tracksLock;
        synchronized (object) {
            retval = this.newFrame;
        }
        return retval;
    }

    public void play() {
        this.nStart(this.id);
    }

    public void stop() {
        this.nStop(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transferFrame(VideoDataBuffer data) {
        int height;
        int width;
        Object framePixelsO;
        Object object = this.tracksLock;
        synchronized (object) {
            framePixelsO = this.frameData;
            if (this.videoTrack != null) {
                width = Math.abs(this.videoTrack.getFrameWidth());
                height = Math.abs(this.videoTrack.getFrameHeight());
            } else {
                width = 0;
                height = 0;
            }
            this.newFrame = false;
        }
        if (framePixelsO instanceof byte[]) {
            data.setBuffer(ByteBuffer.wrap((byte[])this.frameData));
            if (videoFormat == VideoDataBuffer.Format.XBGR || videoFormat == VideoDataBuffer.Format.XRGB) {
                System.out.println("WARNING: Wrong format: " + (Object)((Object)videoFormat));
            }
        } else if (framePixelsO instanceof int[]) {
            data.setBuffer(IntBuffer.wrap((int[])this.frameData));
            if (videoFormat != VideoDataBuffer.Format.XBGR && videoFormat != VideoDataBuffer.Format.XRGB) {
                System.out.println("WARNING: Wrong format: " + (Object)((Object)videoFormat));
            }
        } else {
            data.setBuffer(null);
        }
        data.setFormat(videoFormat);
        data.setWidth(width);
        data.setHeight(height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferFrame(int[] pixels, int width, int height) {
        int[] framePixels = null;
        Object object = this.tracksLock;
        synchronized (object) {
            framePixels = (int[])this.frameData;
            this.newFrame = false;
        }
        try {
            if (pixels.length != framePixels.length) {
                Thread.dumpStack();
            }
            System.arraycopy(framePixels, 0, pixels, 0, pixels.length);
        }
        catch (Exception e) {
            System.err.println("framepixels : " + framePixels);
            System.err.println("pixels : " + pixels);
            e.printStackTrace();
        }
    }

    public void preroll() {
    }

    public void setBalance(float newBalance) {
        this.nSetBalance(this.id, newBalance);
    }

    public void setAutoRepeat(boolean autoRepeat) {
        this.nSetAutoRepeat(this.id, autoRepeat);
    }

    public void setRate(double newRate) {
        this.nSetRate(this.id, newRate);
    }

    public long getCurrentPosition(DShowPlayer dShowPlayer) {
        return (long)this.pos2time(this.nGetMediaTime(this.id));
    }

    public float setVolume(float volume) {
        this.nSetVolume(this.id, volume);
        return volume;
    }

    public void setStopTime(double time) {
        this.nSetStopTime(this.id, this.time2pos(time));
    }

    public void setStartTime(double time) {
        this.nSetStartTime(this.id, this.time2pos(time));
    }

    public void initMovie() {
        this.id = this.nCreate();
        this.playerPeer = null;
    }

    public boolean open(URI uri, String libPath, String userPath, DShowPlayer dShowPlayer) {
        boolean retval = this.loadMedia(uri, 1);
        if (retval) {
            this.getMovieProperties(dShowPlayer);
        }
        return retval;
    }

    public void setMediaTime(double time) {
        this.nSetMediaTime(this.id, this.time2pos(time));
    }

    public boolean eom(DShowPlayer dShowPlayer) {
        double t2;
        double t1 = this.nGetMediaTime(this.id);
        return t1 - (t2 = (double)this.nGetStopTime(this.id)) > -0.02;
    }

    public void pause() {
        this.nPause(this.id);
    }

    private class DShowAudioTrack
    extends AudioTrack {
        boolean trackEnabled;
        int trackID;
        int renderType;

        DShowAudioTrack(int trackID, String encoding, String filterName, boolean enabled, int renderType, int channels, String language, double sampleRate) {
            super(DShowEncodings.getAudioEncType(encoding, filterName), "Audio Track", channels, DShowEncodings.getLocale(language), (float)sampleRate);
            this.trackEnabled = false;
            this.trackEnabled = enabled;
            this.trackID = trackID;
            this.renderType = renderType;
        }
    }

    private class DShowTextTrack
    extends SubtitleTrack {
        boolean trackEnabled;
        int trackID;
        int renderType;

        DShowTextTrack(int trackID, String encoding, String filterName, boolean enabled, int renderType, String language) {
            super(DShowEncodings.getTextEncType(encoding, filterName), "Text Track", DShowEncodings.getLocale(language));
            this.trackEnabled = false;
            this.trackEnabled = enabled;
            this.trackID = trackID;
            this.renderType = renderType;
        }
    }

    private class DShowVideoTrack
    extends VideoTrack {
        boolean trackEnabled;
        int trackID;
        int renderType;

        DShowVideoTrack(int trackID, String encoding, String filterName, boolean enabled, int renderType, int width, int height, double frameRate, boolean hasAlphaChannel) {
            super(DShowEncodings.getVideoEncType(encoding, filterName), "Video Track", width, height, (float)frameRate, hasAlphaChannel);
            this.trackEnabled = false;
            this.trackEnabled = enabled;
            this.trackID = trackID;
            this.renderType = renderType;
        }
    }
}

