/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.directshow;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmcimpl.AbstractPlayerPeer;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.directshow.DShowEngine;
import com.sun.media.jmcimpl.plugins.directshow.DShowMedia;
import java.net.URI;

class DShowPlayer
extends AbstractPlayerPeer
implements PlayerPeer {
    private DShowEngine e = null;
    private DShowMedia mediaPeer = null;
    float g_fader = 0.0f;

    private DShowPlayer() throws MediaException {
        VideoDataBuffer.Format f = DShowEngine.getVideoFormat();
        this.platformCoordinatesYFlipped = f != VideoDataBuffer.Format.YV12 && f != VideoDataBuffer.Format.YUV_442 && f != VideoDataBuffer.Format.YUV_444;
        this.earlyTaskLoop = true;
    }

    public DShowPlayer(DShowEngine theEngine, URI theURI) throws MediaException {
        this();
        this.e = theEngine;
        this.uri = theURI.normalize();
        this.setSource(theURI);
    }

    public DShowPlayer(URI theURI) throws MediaException {
        this();
        this.setSource(theURI);
    }

    public DShowPlayer(DShowMedia thePeer, DShowEngine theEngine, URI theURI) throws MediaException {
        this(theEngine, theURI);
        this.mediaPeer = thePeer;
    }

    public synchronized MediaPeer getMediaPeer() {
        if (this.mediaPeer == null && this.e != null) {
            this.mediaPeer = new DShowMedia(this, this.e);
        }
        return this.mediaPeer;
    }

    public void finalize() {
        this.dispose();
    }

    protected synchronized double plugin_getMediaTime() {
        return this.e.getMediaTime(this);
    }

    protected synchronized boolean plugin_newFrame() {
        return this.e.newFrame(this);
    }

    protected synchronized void plugin_pause() {
        this.e.pause();
    }

    protected synchronized void plugin_start() {
        this.e.play();
    }

    protected synchronized void plugin_stop() {
        this.e.stop();
    }

    protected synchronized void plugin_provideCleanContext() {
        if (null != this.e) {
            this.e.ReleaseResources();
        }
        this.e = null;
    }

    synchronized void sendMediaEvent(int eventID, long param) {
        this.getExecutor().execute(new AbstractPlayerPeer.Execute_mediaEvent(eventID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void plugin_prerollMovie() {
        if (this.e != null) {
            DShowPlayer dShowPlayer = this;
            synchronized (dShowPlayer) {
                this.e.preroll();
            }
        }
    }

    protected synchronized void plugin_setBalance(float newBalance) {
        this.e.setBalance(newBalance);
    }

    protected synchronized void plugin_setFader(float newFader) {
        this.g_fader = newFader;
    }

    protected synchronized void plugin_setRate(double newRate) {
        this.e.setRate(newRate);
    }

    protected synchronized void plugin_setSource(URI uri) {
        if (null == uri) {
            if (null != this.e) {
                this.e.ReleaseResources();
            }
            this.e = null;
            return;
        }
        if (null == this.e) {
            this.e = DShowEngine.canPlay(uri, true, this);
        }
        if (null != this.e) {
            this.earlyTaskLoop = true;
        }
    }

    protected synchronized void plugin_setMediaTime(double time) {
        this.e.setMediaTime(time);
    }

    protected synchronized void plugin_setStopTime(double time) {
        this.e.setStopTime(time);
    }

    protected synchronized void plugin_setStartTime(double time) {
        this.e.setStartTime(time);
    }

    protected boolean plugin_endOfMedia() {
        return this.e.eom(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void plugin_getMovieProperties() {
        DShowPlayer dShowPlayer = this;
        synchronized (dShowPlayer) {
            this.e.getMovieProperties(this);
        }
    }

    protected synchronized void plugin_setVolume(float newVolume) {
        newVolume = this.e.setVolume(newVolume);
    }

    protected void plugin_transferFrame(VideoDataBuffer db) {
        this.e.transferFrame(db);
    }

    protected void plugin_transferFrame(int[] pixels, int frameWidth, int frameHeight) {
        this.e.transferFrame(pixels, frameWidth, frameHeight);
    }

    void syncMovieProperties(int myWidth, int myHeight, double myDuration, double myRate, double myBufferProgressTime, double myMediaTime, float myVolume, float myBalance, float myFader) {
        AbstractPlayerPeer.NativePlayerPeerProperties nppProps = new AbstractPlayerPeer.NativePlayerPeerProperties();
        nppProps.imageWidth = myWidth;
        nppProps.imageHeight = myHeight;
        nppProps.duration = myDuration;
        nppProps.rate = myRate;
        nppProps.bufferProgressTime = myBufferProgressTime;
        nppProps.mediaTime = myMediaTime;
        nppProps.volume = myVolume;
        nppProps.balance = myBalance;
        nppProps.fader = this.g_fader;
        super.syncMovieProperties(nppProps);
    }
}

