/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmcimpl.AbstractPlayerPeer;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.Utils;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTMediaInfo;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTMediaPeer;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTUtils;
import java.net.URI;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.EnumSet;

class GSTPlayerPeer
extends AbstractPlayerPeer {
    private long peerInfo;
    private GSTMediaPeer mediaPeer;
    private double rate = 1.0;
    private boolean stateEOS = false;
    private FrameHolder frameHolder = new FrameHolder();
    private EventHandler eventHandler = new EventHandler();

    GSTPlayerPeer() {
    }

    private native long nativeSetURI(String var1, Object var2, Object var3);

    private native void nativeDestroyPeer(long var1);

    private native int nativePlay(long var1);

    private native int nativePause(long var1);

    private native int nativeStop(long var1);

    private native void nativeSetMediaTime(long var1, long var3, double var5);

    private native void nativeSetRate(long var1, double var3);

    private native void nativeSetVolume(long var1, double var3);

    private native void nativeSetStopTime(long var1, long var3, double var5);

    private native void nativeSetStartTime(long var1, long var3, double var5);

    protected synchronized void plugin_setSource(URI uri) {
        if (uri != null) {
            this.peerInfo = this.nativeSetURI(GSTUtils.normalize(uri).toString(), this.frameHolder, this.eventHandler);
            if (this.peerInfo == 0L) {
                throw new MediaException("Could not create GStreamer peer");
            }
            this.sendMediaEvent(100);
        }
    }

    protected synchronized void plugin_provideCleanContext() {
        if (this.peerInfo != 0L) {
            this.plugin_stop();
            this.nativeDestroyPeer(this.peerInfo);
            this.peerInfo = 0L;
            this.mediaPeer = null;
            this.rate = 1.0;
            this.stateEOS = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void plugin_getMovieProperties() {
        AbstractPlayerPeer.NativePlayerPeerProperties result = new AbstractPlayerPeer.NativePlayerPeerProperties();
        MovieProperties props = MovieProperties.queryProperties(this.peerInfo);
        GSTPlayerPeer gSTPlayerPeer = this;
        synchronized (gSTPlayerPeer) {
            result.imageWidth = this.mediaPeer != null ? this.mediaPeer.getFrameWidth() : 0;
            result.imageHeight = this.mediaPeer != null ? this.mediaPeer.getFrameHeight() : 0;
            result.duration = props.getDuration();
            result.mediaTime = this.stateEOS ? result.duration : props.getMediaTime();
            result.volume = props.getVolume();
            result.rate = this.rate;
        }
        this.syncMovieProperties(result);
    }

    protected void setCaps(AbstractPlayerPeer.NativePlayerPeerProperties nppProps) {
        nppProps.caps = EnumSet.noneOf(PlayerPeer.Capabilities.class);
        nppProps.caps.add(PlayerPeer.Capabilities.isLightweight);
        nppProps.caps.add(PlayerPeer.Capabilities.supportsRate);
        nppProps.caps.add(PlayerPeer.Capabilities.supportsVolume);
        if (nppProps.duration != Double.POSITIVE_INFINITY) {
            nppProps.caps.add(PlayerPeer.Capabilities.supportsSeeking);
        }
    }

    protected void plugin_prerollMovie() {
        StateChangeReturn ret;
        if (this.peerInfo != 0L && (ret = StateChangeReturn.forInt(this.nativePause(this.peerInfo))) == StateChangeReturn.NO_PREROLL) {
            this.sendMediaEvent(101);
        }
    }

    protected void plugin_start() {
        if (this.peerInfo != 0L) {
            this.nativePlay(this.peerInfo);
        }
    }

    protected void plugin_pause() {
        if (this.peerInfo != 0L) {
            this.nativePause(this.peerInfo);
        }
    }

    protected void plugin_stop() {
        if (this.peerInfo != 0L) {
            this.nativeStop(this.peerInfo);
        }
    }

    protected void plugin_setMediaTime(double time) {
        if (!this.isSeekable()) {
            throw new MediaException("Seeking is not available");
        }
        if (this.peerInfo != 0L) {
            time = Utils.reduceValue(time, 0.0, this.getDuration());
            this.nativeSetMediaTime(this.peerInfo, GSTUtils.toNanoseconds(time), this.getRate());
        }
        this.stateEOS = false;
    }

    protected void plugin_setStopTime(double time) {
        if (this.peerInfo != 0L) {
            time = Utils.reduceValue(time, 0.0, this.getDuration());
            this.nativeSetStopTime(this.peerInfo, GSTUtils.toNanoseconds(time), this.getRate());
        }
    }

    protected void plugin_setStartTime(double time) {
        if (this.peerInfo != 0L) {
            time = Utils.reduceValue(time, 0.0, this.getDuration());
            this.nativeSetStartTime(this.peerInfo, GSTUtils.toNanoseconds(time), this.getRate());
        }
    }

    protected void plugin_setRate(double newRate) {
        if (newRate != this.rate) {
            if (this.peerInfo != 0L && newRate != 0.0) {
                this.nativeSetRate(this.peerInfo, newRate);
                if (this.rate == 0.0) {
                    this.start();
                }
            } else {
                this.pause();
            }
            this.rate = newRate;
        }
    }

    protected synchronized void plugin_setVolume(float volume) {
        if (this.peerInfo != 0L) {
            this.nativeSetVolume(this.peerInfo, volume);
        }
    }

    protected boolean plugin_newFrame() {
        return this.frameHolder.hasNewFrame();
    }

    protected void plugin_transferFrame(int[] pixels, int frameWidth, int frameHeight) {
        this.frameHolder.transferFrame(pixels, frameWidth, frameHeight);
    }

    protected void plugin_transferFrame(VideoDataBuffer db) {
        int height;
        if (this.mediaPeer == null) {
            db.setBuffer(null);
            return;
        }
        int width = this.mediaPeer.getFrameWidth();
        int bSize = width * (height = this.mediaPeer.getFrameHeight());
        if (bSize == 0) {
            db.setWidth(width);
            db.setHeight(height);
            db.setBuffer(null);
            return;
        }
        Buffer b = db.getBuffer();
        IntBuffer ib = null;
        if (b instanceof IntBuffer && (ib = (IntBuffer)b).capacity() != bSize) {
            ib = null;
        }
        b = null;
        if (ib == null) {
            ib = IntBuffer.allocate(bSize);
            b = ib;
        }
        db.setBuffer(ib);
        ib.clear();
        db.setWidth(width);
        db.setHeight(height);
        db.setFormat(VideoDataBuffer.Format.XRGB);
        this.frameHolder.transferFrame(ib.array(), width, height);
    }

    public synchronized MediaPeer getMediaPeer() {
        return this.mediaPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isSeekable() {
        AbstractPlayerPeer.NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.duration != Double.POSITIVE_INFINITY;
        }
    }

    private void sendMediaEvent(int eventID) {
        this.getExecutor().execute(new AbstractPlayerPeer.Execute_mediaEvent(eventID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double plugin_getMediaTime() {
        AbstractPlayerPeer.NativePlayerPeerProperties nativePlayerPeerProperties = this.currentProps;
        synchronized (nativePlayerPeerProperties) {
            return this.currentProps.mediaTime;
        }
    }

    protected boolean plugin_endOfMedia() {
        return false;
    }

    protected void plugin_setBalance(float newBalance) {
    }

    protected void plugin_setFader(float fader) {
    }

    private class EventHandler {
        private EventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle_eos(long position) {
            GSTPlayerPeer gSTPlayerPeer = GSTPlayerPeer.this;
            synchronized (gSTPlayerPeer) {
                GSTPlayerPeer.this.stateEOS = true;
            }
        }

        private void handle_buffering(int percent) {
        }

        private void handle_preroll() {
            GSTPlayerPeer.this.sendMediaEvent(101);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle_media_info(GSTMediaInfo mediaInfo) {
            GSTPlayerPeer gSTPlayerPeer = GSTPlayerPeer.this;
            synchronized (gSTPlayerPeer) {
                GSTPlayerPeer.this.mediaPeer = GSTMediaPeer.createMediaPeer(GSTPlayerPeer.this.uri, mediaInfo);
            }
        }
    }

    private class FrameHolder {
        private boolean newFrameFlag = false;

        private FrameHolder() {
        }

        private native void nativeTransferFrame(long var1, int[] var3, int var4, int var5);

        private void preroll() {
            this.render();
        }

        private void render() {
            this.newFrameFlag = true;
        }

        public synchronized boolean hasNewFrame() {
            boolean result = this.newFrameFlag;
            this.newFrameFlag = false;
            return result;
        }

        public synchronized void transferFrame(int[] pixels, int frameWidth, int frameHeight) {
            this.nativeTransferFrame(GSTPlayerPeer.this.peerInfo, pixels, frameWidth, frameHeight);
        }
    }

    private static class MovieProperties {
        private long duration;
        private long mediaTime;
        private double volume;

        private static native MovieProperties nativeQueryProperties(long var0);

        private MovieProperties(long duration, long mediaTime, double volume) {
            this.duration = duration;
            this.mediaTime = mediaTime;
            this.volume = volume;
        }

        static MovieProperties queryProperties(long peerInfo) {
            return peerInfo != 0L ? MovieProperties.nativeQueryProperties(peerInfo) : null;
        }

        double getDuration() {
            return GSTUtils.toSeconds(this.duration);
        }

        double getMediaTime() {
            return GSTUtils.toSeconds(this.mediaTime);
        }

        float getVolume() {
            return (float)this.volume;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StateChangeReturn {
        FAILURE(0),
        SUCCESS(1),
        ASYNC(2),
        NO_PREROLL(3);

        private int value;

        private StateChangeReturn(int value) {
            this.value = value;
        }

        static StateChangeReturn forInt(int value) {
            for (StateChangeReturn item : StateChangeReturn.values()) {
                if (item.value != value) continue;
                return item;
            }
            return FAILURE;
        }
    }
}

