/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.NativeLibLoader;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTMediaPeer;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTPlayerPeer;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTUtils;
import com.sun.media.jmcimpl.spi.DefaultPlayerPeerProvider;
import com.sun.media.jmcimpl.spi.MediaPeerProvider;
import com.sun.media.jmcimpl.spi.PlayerPeerProvider;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSTPlayerProvider
extends DefaultPlayerPeerProvider
implements MediaPeerProvider {
    static final int DETECT_TIMEOUT = 10;
    private static boolean isGSTAvailable = false;
    private static Map<String, String[]> typesList;
    private static ContainerType[] containerTypes;

    private static native boolean nativeInitGSTLibrary();

    private static native Map<String, String[]> nativeGetMediaTypes();

    private static native boolean nativeCanPlay(String var0, int var1);

    private static native void nativeRunMainLoop();

    public GSTPlayerProvider() {
        super(containerTypes, PlayerPeerProvider.PlaybackMode.Lightweight);
    }

    @Override
    public PlayerPeer createPlayerPeer(URI uri, VideoDataBuffer.Format[] formats) throws MediaException {
        if (isGSTAvailable) {
            GSTPlayerPeer peer = new GSTPlayerPeer();
            peer.setSource(uri);
            return peer;
        }
        throw new MediaException("GStreamer library couldn't be initialized");
    }

    @Override
    public MediaPeer createMediaPeer(URI uri, VideoDataBuffer.Format[] formats) throws MediaException {
        if (isGSTAvailable) {
            return GSTMediaPeer.getMediaPeer(uri);
        }
        throw new MediaException("GStreamer library couldn't be initialized");
    }

    @Override
    public Class<? extends PlayerPeer> getPlayerPeerClass() {
        return GSTPlayerPeer.class;
    }

    @Override
    public PlayerPeerProvider.PlaybackMode canPlay(URI uri, VideoDataBuffer.Format[] formats) {
        if (isGSTAvailable) {
            return GSTMediaPeer.hasBeenCached(uri) || GSTPlayerProvider.nativeCanPlay(GSTUtils.normalize(uri).toString(), 10) ? PlayerPeerProvider.PlaybackMode.Lightweight : PlayerPeerProvider.PlaybackMode.None;
        }
        return PlayerPeerProvider.PlaybackMode.None;
    }

    @Override
    public boolean canDecode(URI uri, VideoDataBuffer.Format[] formats) {
        return this.canPlay(uri, formats) != PlayerPeerProvider.PlaybackMode.None;
    }

    static Map<String, String[]> getTypesList() {
        return typesList;
    }

    static {
        try {
            Boolean loaded = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String osName = System.getProperty("os.name", "").toLowerCase();
                    if (osName.startsWith("linux") || osName.startsWith("sunos")) {
                        NativeLibLoader.loadLibrary("GStreamer");
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
            if (loaded.booleanValue() && (isGSTAvailable = GSTPlayerProvider.nativeInitGSTLibrary())) {
                typesList = GSTPlayerProvider.nativeGetMediaTypes();
                if (typesList != null && typesList.size() > 0) {
                    containerTypes = new ContainerType[typesList.size()];
                    int index = 0;
                    for (String mimeType : typesList.keySet()) {
                        GSTPlayerProvider.containerTypes[index++] = new ContainerType(GSTUtils.getContainer(mimeType), "GStreamer container type " + mimeType, typesList.get(mimeType), new String[]{mimeType});
                    }
                }
                Thread mainLoopThread = new Thread("GStreamer MainLoop thread"){

                    public void run() {
                        GSTPlayerProvider.nativeRunMainLoop();
                    }
                };
                mainLoopThread.start();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

