/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

abstract class GSTStreamInfo {
    static final int VALUE_UNDEFINED = -1;
    private StreamType streamType;
    private String mimeType;
    private int version;
    private int layer;

    private GSTStreamInfo(StreamType streamType, String mimeType, int version, int layer) {
        this.streamType = streamType;
        this.mimeType = mimeType;
        this.version = version;
        this.layer = layer;
    }

    StreamType getStreamType() {
        return this.streamType;
    }

    String getMimeType() {
        return this.mimeType;
    }

    int getVersion() {
        return this.version;
    }

    int getLayer() {
        return this.layer;
    }

    static class Audio
    extends GSTStreamInfo {
        private int rate;
        private int channels;

        Audio(String mimeType, int version, int layer, int rate, int channels) {
            super(StreamType.AUDIO, mimeType, version, layer);
            this.rate = rate;
            this.channels = channels;
        }

        int getChannels() {
            return this.channels;
        }

        int getRate() {
            return this.rate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StreamType {
        AUDIO,
        VIDEO,
        SUBTITLES;

    }

    static class Subtitles
    extends GSTStreamInfo {
        Subtitles(String mimeType) {
            super(StreamType.SUBTITLES, mimeType, -1, -1);
        }
    }

    static class Video
    extends GSTStreamInfo {
        private int width;
        private int height;
        private double framerate;

        Video(String mimeType, int version, int layer, int width, int height, double framerate) {
            super(StreamType.VIDEO, mimeType, version, layer);
            this.width = width;
            this.height = height;
            this.framerate = framerate;
        }

        int getWidth() {
            return this.width;
        }

        int getHeight() {
            return this.height;
        }

        boolean isSizeValid() {
            return this.width > 0 && this.height > 0;
        }

        double getFramerate() {
            return this.framerate;
        }
    }
}

