/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmcimpl.plugins.gstreamer.GSTStreamInfo;
import java.net.URI;
import java.net.URISyntaxException;

class GSTUtils {
    static final long GST_SECOND = 1000000000L;
    static final long GST_CLOCK_TIME_NONE = -1L;

    GSTUtils() {
    }

    static long toNanoseconds(double seconds) {
        return seconds != Double.POSITIVE_INFINITY ? (long)(seconds * 1.0E9) : -1L;
    }

    static double toSeconds(long nanoseconds) {
        return nanoseconds != -1L ? (double)nanoseconds / 1.0E9 : Double.POSITIVE_INFINITY;
    }

    static EncodingType.Encoding getEncoding(GSTStreamInfo streamInfo) {
        String mimeType = streamInfo.getMimeType();
        if (mimeType.startsWith("audio")) {
            if (mimeType.startsWith("audio/x-raw")) {
                return EncodingType.Encoding.PCM;
            }
            if ("audio/x-vorbis".equals(mimeType)) {
                return EncodingType.Encoding.VORBIS;
            }
            if ("audio/x-adpcm".equals(mimeType)) {
                return EncodingType.Encoding.ADPCM;
            }
            if ("audio/x-alaw".equals(mimeType)) {
                return EncodingType.Encoding.ALAW;
            }
            if ("audio/x-mulaw".equals(mimeType)) {
                return EncodingType.Encoding.MULAW;
            }
            if ("audio/ms-gsm".equals(mimeType)) {
                return EncodingType.Encoding.GSM610;
            }
            if ("audio/mpeg".equals(mimeType)) {
                switch (streamInfo.getVersion()) {
                    case 1: {
                        return streamInfo.getLayer() == 3 ? EncodingType.Encoding.MPEG1LAYER3 : EncodingType.Encoding.MPEG1AUDIO;
                    }
                    case 2: {
                        return EncodingType.Encoding.MPEG2AUDIO;
                    }
                    case 4: {
                        return EncodingType.Encoding.AAC;
                    }
                }
            } else {
                if ("audio/x-voxware".equals(mimeType)) {
                    return EncodingType.Encoding.VOXWARE;
                }
                if ("audio/x-wma".equals(mimeType)) {
                    switch (streamInfo.getVersion()) {
                        case 1: {
                            return EncodingType.Encoding.MSAUDIO1;
                        }
                        case 2: {
                            return EncodingType.Encoding.WMAUDIO8;
                        }
                        case 3: {
                            return EncodingType.Encoding.WMAUDIO9;
                        }
                    }
                } else {
                    if ("audio/x-lpcm".equals(mimeType)) {
                        return EncodingType.Encoding.DVD_LPCM_AUDIO;
                    }
                    if ("audio/x-lpcm".equals(mimeType)) {
                        return EncodingType.Encoding.DVD_LPCM_AUDIO;
                    }
                    if ("audio/x-ac3".equals(mimeType)) {
                        return EncodingType.Encoding.DOLBY_AC3;
                    }
                    if ("audio/x-dts".equals(mimeType)) {
                        return EncodingType.Encoding.DTS;
                    }
                }
            }
        } else if (mimeType.startsWith("video") || mimeType.startsWith("image")) {
            if (mimeType.startsWith("video/x-raw")) {
                return EncodingType.Encoding.RAWVIDEO;
            }
            if ("video/x-theora".equals(mimeType)) {
                return EncodingType.Encoding.THEORA;
            }
            if ("video/mpeg".equals(mimeType) || "video/ms-mpeg".equals(mimeType)) {
                switch (streamInfo.getVersion()) {
                    case 1: {
                        return EncodingType.Encoding.MPEG1VIDEO;
                    }
                    case 2: {
                        return EncodingType.Encoding.MPEG2VIDEO;
                    }
                    case 4: {
                        return EncodingType.Encoding.MSMPEG4;
                    }
                }
            } else if ("video/x-wmv".equals(mimeType)) {
                switch (streamInfo.getVersion()) {
                    case 1: {
                        return EncodingType.Encoding.WMVIDEO7;
                    }
                    case 2: {
                        return EncodingType.Encoding.WMVIDEO8;
                    }
                    case 3: {
                        return EncodingType.Encoding.WMVIDEO9;
                    }
                }
            } else if ("video/x-divx".equals(mimeType)) {
                switch (streamInfo.getVersion()) {
                    case 3: 
                    case 4: {
                        return EncodingType.Encoding.DIVX;
                    }
                    case 5: {
                        return EncodingType.Encoding.DIVX5;
                    }
                }
            } else {
                if ("video/x-h263".equals(mimeType)) {
                    return EncodingType.Encoding.H263;
                }
                if ("video/x-h264".equals(mimeType)) {
                    return EncodingType.Encoding.H264;
                }
                if ("video/x-vp5".equals(mimeType)) {
                    return EncodingType.Encoding.VP5;
                }
                if ("video/x-vp6".equals(mimeType) || "video/x-vp6-flash".equals(mimeType)) {
                    return EncodingType.Encoding.VP6;
                }
                if ("image/jpeg".equals(mimeType)) {
                    return EncodingType.Encoding.MJPEG;
                }
                if ("video/x-indeo".equals(mimeType)) {
                    switch (streamInfo.getVersion()) {
                        case 2: {
                            return EncodingType.Encoding.INDEO2;
                        }
                        case 3: {
                            return EncodingType.Encoding.INDEO3;
                        }
                        case 4: {
                            return EncodingType.Encoding.INDEO4;
                        }
                        case 5: {
                            return EncodingType.Encoding.INDEO5;
                        }
                    }
                }
            }
        }
        return EncodingType.Encoding.CUSTOM;
    }

    static ContainerType.Container getContainer(String mimeType) {
        if ("video/x-msvideo".equals(mimeType)) {
            return ContainerType.Container.AVI;
        }
        if ("application/x-shockwave-flash".equals(mimeType)) {
            return ContainerType.Container.SWF;
        }
        if ("video/quicktime".equals(mimeType)) {
            return ContainerType.Container.MOV;
        }
        if ("application/ogg".equals(mimeType)) {
            return ContainerType.Container.OGG;
        }
        if ("video/x-ms-asf".equals(mimeType)) {
            return ContainerType.Container.ASF;
        }
        if ("video/x-flv".equals(mimeType)) {
            return ContainerType.Container.FLV;
        }
        if ("video/mpeg".equals(mimeType) || "audio/mpeg".equals(mimeType) || "application/x-id3".equals(mimeType)) {
            return ContainerType.Container.MPEG1;
        }
        if ("audio/x-wav".equals(mimeType)) {
            return ContainerType.Container.WAVE;
        }
        if ("audio/x-m4a".equals(mimeType)) {
            return ContainerType.Container.MP4;
        }
        if ("application/x-3gp".equals(mimeType)) {
            return ContainerType.Container.THREEGP;
        }
        return ContainerType.Container.CUSTOM;
    }

    static URI normalize(URI uri) {
        try {
            String host = uri.getHost() != null ? uri.getHost() : "";
            return new URI(uri.getScheme(), uri.getUserInfo(), host, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            return uri;
        }
    }
}

