/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.spi;

import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderRegistry<T> {
    public final Class<T> providerClass;
    private List<T> list = null;
    private long lastRefreshTime = 0L;
    private final int AUTOREFRESH_DEFAULT = 60000;
    private long autoRefreshPeriod = 60000L;
    public final int AUTOREFRESH_NEVER = -1;
    public final int AUTOREFRESH_ALWAYS = 0;

    private <E> List<E> lookupProviders(final Class<E> providerClass) throws NullPointerException {
        PrivilegedAction action = new PrivilegedAction<List<E>>(){

            @Override
            public List<E> run() {
                LinkedList list = new LinkedList();
                Iterator iter = Service.providers((Class)providerClass);
                try {
                    while (iter.hasNext()) {
                        try {
                            list.add(iter.next());
                        }
                        catch (Throwable t) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return list;
            }
        };
        return (List)AccessController.doPrivileged(action);
    }

    public ProviderRegistry(Class<T> providerClass) throws NullPointerException {
        if (providerClass == null) {
            throw new NullPointerException();
        }
        this.providerClass = providerClass;
    }

    private void doRefresh() {
        this.list = this.lookupProviders(this.providerClass);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    private void autoRefresh() {
        if (this.list != null) {
            if (this.autoRefreshPeriod < 0L) {
                return;
            }
            if (this.autoRefreshPeriod > 0L && System.currentTimeMillis() - this.lastRefreshTime < this.autoRefreshPeriod) {
                return;
            }
        }
        this.doRefresh();
    }

    public synchronized void refresh() {
        this.doRefresh();
    }

    public void setAutoRefreshPeriod(int seconds) {
        this.autoRefreshPeriod = (long)seconds * 1000L;
    }

    public synchronized Iterator<T> getProviders() {
        this.autoRefresh();
        return Collections.unmodifiableList(this.list).iterator();
    }

    public synchronized T[] getProviderArray() {
        this.autoRefresh();
        Object[] array = (Object[])Array.newInstance(this.providerClass, this.list.size());
        Iterator<T> iter = this.list.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = iter.next();
        }
        return array;
    }
}

