/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.Gradient;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.image.PointFilter;
import com.jhlabs.math.FBM;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.Noise;
import java.awt.image.BufferedImage;

public class FireFilter
extends PointFilter {
    public float t;
    private TimeRidgedFBM basis = new TimeRidgedFBM();
    private FBM fbm;
    private float min;
    private float max;
    private Colormap colormap = new Gradient(new int[]{0, 180, 200, 255}, new int[]{538824, -2146944824, -1064831235, -7866627});
    private Function2D image;
    private Function2D mask;
    private float octaves = 3.0f;
    private float power = 0.6f;
    private float scale = 64.0f;
    private float stretch = 1.0f;
    private float amount = 0.85f;
    private float flameHeight = 1.9f;
    private float amplitude = 0.5f;
    private float distortion = 0.0f;
    private float radius = 50.0f;
    private float blur = 2.0f;
    private int width;
    private int height;

    public void setTime(float t) {
        this.t = t;
    }

    public FireFilter() {
    }

    public FireFilter(Function2D image, Function2D mask) {
        this.mask = mask;
        this.image = image;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void setOctaves(float octaves) {
        this.octaves = octaves;
    }

    public float getOctaves() {
        return this.octaves;
    }

    public void setPower(float power) {
        this.power = power;
    }

    public float getPower() {
        return this.power;
    }

    public void setDistortion(float distortion) {
        this.distortion = distortion;
    }

    public float getDistortion() {
        return this.distortion;
    }

    public void setFlameHeight(float flameHeight) {
        this.flameHeight = flameHeight;
    }

    public float getFlameHeight() {
        return this.flameHeight;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        this.width = src.getWidth();
        this.height = src.getHeight();
        this.fbm = new FBM(1.0f, 2.07f, this.octaves, this.basis);
        float[] minmax = Noise.findRange(this.fbm, null);
        this.min = minmax[0];
        this.max = minmax[1];
        return super.filter(src, dst);
    }

    public int filterRGB(int x, int y, int rgb) {
        int v;
        this.amplitude = this.power;
        float m = this.mask.evaluate(x, y);
        m = Math.min(1.0f, 5.0f * (1.0f - m));
        float i = this.image.evaluate(x, y);
        y = this.height - y;
        float nx = x;
        float ny = y;
        nx /= this.scale;
        ny /= this.scale * this.stretch;
        ny *= (float)Math.exp(-0.2f * ny);
        ny -= 0.5f * this.t;
        if (this.distortion != 0.0f) {
            float d = this.distortion * ny;
            float a = Noise.noise2(nx, ny) * d;
            nx = (float)((double)nx + 10.0 * Math.sin(a));
            ny = (float)((double)ny + 10.0 * Math.cos(a));
        }
        float f = this.fbm.evaluate(nx, ny);
        f = (f - this.min) / (this.max - this.min);
        f = 1.0f - 2.0f * Math.abs(f - 0.5f);
        f *= this.amount;
        f += 0.8f * (this.amplitude - this.flameHeight * (float)y / (float)this.height);
        f *= m;
        int a = rgb & 0xFF000000;
        if (this.colormap != null) {
            v = this.colormap.getColor(f);
        } else {
            v = PixelUtils.clamp((int)(f * 255.0f));
            int r = v << 16;
            int g = v << 8;
            int b = v;
            v = a | r | g | b;
        }
        int a1 = rgb >> 24 & 0xFF;
        int r1 = rgb >> 16 & 0xFF;
        int g1 = rgb >> 8 & 0xFF;
        int b1 = rgb & 0xFF;
        int a2 = v >> 24 & 0xFF;
        int r2 = v >> 16 & 0xFF;
        int g2 = v >> 8 & 0xFF;
        int b2 = v & 0xFF;
        float aa = (float)a2 / 255.0f;
        float ac = 1.0f - aa;
        if ((r2 += r1) > 255) {
            r2 = 255;
        }
        if ((g2 += g1) > 255) {
            g2 = 255;
        }
        if ((b2 += b1) > 255) {
            b2 = 255;
        }
        r1 = (int)(aa * (float)r2 + ac * (float)r1);
        g1 = (int)(aa * (float)g2 + ac * (float)g1);
        b1 = (int)(aa * (float)b2 + ac * (float)b1);
        return a1 << 24 | r1 << 16 | g1 << 8 | b1;
    }

    public String toString() {
        return "Stylize/Fire...";
    }

    public class TimeRidgedFBM
    implements Function2D {
        public float evaluate(float x, float y) {
            return Noise.noise3(x, y, FireFilter.this.t);
        }
    }
}

